package com.bcxin.ars.webservice.impl;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.context.SecurityContext;
import com.bcxin.ars.dto.bj.PersonInfo;
import com.bcxin.ars.dto.sb.BackgroundApprovalDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.PersonBaseInfo;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.BackgroundApproval;
import com.bcxin.ars.service.ConfigService;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.xml.JaxbUtil;
import com.bcxin.ars.webservice.BackGroupCensorService;
import com.bcxin.ars.webservice.dto.CensorResult;
import com.xiaoleilu.hutool.bean.BeanUtil;
import com.xiaoleilu.hutool.http.HttpUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * 背景筛查 + 人口库  北京库
 * @author linqinglin
 * @date 2019/04/17 0017 17:48
 */
@Service
public class TestBackGroupCensorServiceImpl extends BackGroupCensorServiceImpl implements BackGroupCensorService {

    private static Logger logger = LoggerFactory.getLogger(TestBackGroupCensorServiceImpl.class);

    @Autowired
    private ConfigService configService;

    @Value("${ZAFLAG}")
    private String ZAFLAG;

    @Value("${BJ_RKK_PHOTO_URL}")
    private String BJ_RKK_PHOTO_URL;
/*    @Autowired
    private ArsUtil arsUtil;*/


    private static Map<String,String> map;


    static {
        /**
         * 北京与陕西读取数据类型映射
         * 统一数据类型
         */
        map = new HashMap<>();
        map.put(Constants.INFO_XM, Constants.INFO_XM_BJ);
        map.put(Constants.INFO_DETAIL_ADDRESS, Constants.INFO_ZZXZ_BJ);
        map.put(Constants.INFO_XP, Constants.INFO_XP_BJ);

    }

    /**
     * 人口库获取照片信息
     * 北京库不一样，重写此方法
     * @param idNumber 身份证号
     * @return
     */
    @Override
    public String getPhoto(String idNumber,String name) {
        //生产内网才能调通
        if (ObjectUtils.equals(Constants.INRAW_PRO_YES, ZAFLAG)) {
            try {
//            http://10.8.1.28/hlpda/pda/reponse/CheckPersonBasicInfoAction.do?sfzh=132201196402037013&policesfzh=123456789123456789&policename=测试&policeorg=350100&policemanid=666666
//            sfzh： 身份证号码
//            deviceid    :  设备号(如果PC请求可以不用传，.pda必须传)
//            Policesfzh   :  警员身份证
//            Policesname :警员姓名
//            Policeorg   :警员单位
//
//            *
//             * 从数据库读取北京人口库地址
                String url = BJ_RKK_PHOTO_URL;
                //获取当前用户
                HashMap<String, Object> paramMap = new HashMap<>();

                paramMap.put("policesfzh", Constants.POLICESFZH);
                paramMap.put("policeorg", Constants.POLICEORG);
                paramMap.put("policemanid", Constants.POLICEMANID);
                paramMap.put("clientId", Constants.CLIENTID);
                paramMap.put("policename", Constants.POLICENAME);
                paramMap.put("sfzh", idNumber);
                String result = HttpUtil.get(url, paramMap);
                logger.info("身份证号：" + idNumber + "，北京人口库返回数据:" + result);
                //返回结果 personhuji：详细地址
                //      personname:姓名
                PersonInfo personInfo = JaxbUtil.converyToJavaBean(result, PersonInfo.class);
                return (String) BeanUtil.getFieldValue(personInfo, map.get(Constants.INFO_XP));
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
            }
        }
        return StringUtil.EMPTY;
    }
    /**
     * 获取系统当前登录用户
     * @return
     */
    public User getCurrentUser() {
        User user = SecurityContext.currentUser.get();
        return user;
    }


    /****
     * 背景筛查
     * 不同省份不同实现
     * @param dto 业务信息
     */
    @Override
    public List<BackgroundApproval> censorFromBase(BackgroundApprovalDto dto,boolean needCZ) {
        List<BackgroundApproval> list = new ArrayList<>();
        try {
            //业务ID
            Long businessid = dto.getBusinessid();
            //业务类型
            String businesstype = dto.getBusinesstype();
            //身份证号
            String idNumber = dto.getIdNumber();
            //姓名
            String name = dto.getRealName();
            //背景筛查
            BackgroundApproval cz_BackgroundApproval = new BackgroundApproval();
            cz_BackgroundApproval.setActive(true);
            cz_BackgroundApproval.setCreateTime(new Date());
            cz_BackgroundApproval.setUpdateTime(new Date());
            cz_BackgroundApproval.setApprovaldate(new Date());
            cz_BackgroundApproval.setBusinessid(businessid);
            cz_BackgroundApproval.setBusinesstype(businesstype);
            /**
             * 克隆对象，减少重复创建对象赋值代码
             * 自定义类需要实现Cloneable的clone()方法
             */
            BackgroundApproval tempBackgroundApproval = cz_BackgroundApproval.clone();
            //吸毒
            BackgroundApproval xd_BackgroundApproval = cz_BackgroundApproval.clone();
            //在逃
            BackgroundApproval dt_BackgroundApproval= cz_BackgroundApproval.clone();
            //犯罪
            BackgroundApproval wf_BackgroundApproval = cz_BackgroundApproval.clone();
            if(needCZ) {
                censorCZ(idNumber,name,cz_BackgroundApproval);
                list.add(cz_BackgroundApproval);
            }
            /*
            背景核查
            核查接口地址：http://14.28.2.32:8080/verify
            接口参数
            userid:必填（通常填写警号）
            key:核查证件号码
            返回值位：JSON
            */
            try {
                /**
                 * 从数据库读取北京核查库地址
                 */
                String url = StringUtil.EMPTY;
                Config censorConfig = configService.getConfigByKey(Constants.ZAURL_BJ);
                if(censorConfig == null){
                    throw new ArsException("Config中北京人口库及核查库地址未配置,key:"+ Constants.ZAURL_BJ);
                }else{
                    url = censorConfig.getValue();
                }

                HashMap<String, Object> paramMap = new HashMap<>();
                //警号
                paramMap.put("userid", "044656");
                //身份证号转成大写
                paramMap.put("key", idNumber.toUpperCase());
                String result = HttpUtil.get(url, paramMap);
                logger.info("身份证号：" + idNumber + "，北京核查库返回数据:"+result);
                if(StringUtil.isNotEmpty(result)) {
                    CensorResult censorResult = JSONObject.parseObject(result, CensorResult.class);
                    String type = censorResult.getType();
                    if (StringUtil.isNotEmpty(type)) {
                        //背景筛查原因列表
                        String[] types = type.split(",");
                        for (String t :
                                types) {
                            BackgroundApproval backgroundApproval = tempBackgroundApproval.clone();
                            //不通过原因
                            backgroundApproval.setApprovalreason(t);
                            //背景筛查不通过
                            backgroundApproval.setApprovalstate(Constants.APPROVALSTATE_BTG);
                            backgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_BTG);
                            //公安核查库
                            backgroundApproval.setLibraryType(Constants.LIBRARYTYPE_BJ_HC);
                            list.add(backgroundApproval);
                        }
                    }
                }
            }catch(Exception e){
                logger.error(e.getMessage(),e);
            }
        }catch (Exception e){
            logger.error(e.getMessage(),e);
            if(e instanceof ArsException){
                throw new ArsException(e.getMessage());
            }

        }
        return list;
    }

    @Override
    public PersonBaseInfo getPopulationInfo(String idNumber,boolean needPhoto) {
        PersonBaseInfo infoDto = new PersonBaseInfo();
        infoDto.setIdnum(idNumber);
        String resultPerson = getPopulationInfoFromBase(idNumber);
        logger.info("照片返回接口信息："+resultPerson);

        if(StringUtil.isNotEmpty(resultPerson)){
            PersonInfo personInfo = JaxbUtil.converyToJavaBean(resultPerson, PersonInfo.class);
            if(personInfo != null){
                infoDto.setName(personInfo.getPersonname());
                infoDto.setAddress(personInfo.getPersonhuji());
                infoDto.setPhoto(personInfo.getXp());
            }
        }

        return infoDto;
    }

    private String getPopulationInfoFromBase(String cardnumber){
        String url = BJ_RKK_PHOTO_URL;
        HashMap<String, Object> paramMap = new HashMap<>();
        paramMap.put("policesfzh", Constants.POLICESFZH);
        paramMap.put("policeorg", Constants.POLICEORG);
        paramMap.put("policemanid", Constants.POLICEMANID);
        paramMap.put("clientId", Constants.CLIENTID);
        paramMap.put("policename", Constants.POLICENAME);
        paramMap.put("sfzh", cardnumber);
        return HttpUtil.get(url, paramMap);
    }
}
