package com.bcxin.ars.webservice.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.log.BjRestLogDao;
import com.bcxin.ars.dto.sb.BackgroundApprovalDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.PersonBaseInfo;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.log.BjRestLog;
import com.bcxin.ars.model.sb.BackgroundApproval;
import com.bcxin.ars.service.ConfigService;
import com.bcxin.ars.service.sys.SysareaService;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.ftp.FtpUtils;
import com.bcxin.ars.util.redis.RedisUtil;
import com.bcxin.ars.webservice.BackGroupCensorService;
import com.bcxin.ars.webservice.dto.SNCensorResult;
import com.bcxin.ars.webservice.dto.SNPerInfoDto;
import com.dragonsoft.node.adapter.comm.RbspCall;
import com.dragonsoft.node.adapter.comm.RbspConsts;
import com.dragonsoft.node.adapter.comm.RbspService;
import com.google.common.collect.Maps;
import com.xiaoleilu.hutool.http.HttpUtil;
import com.xiaoleilu.hutool.io.IoUtil;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.dom4j.tree.DefaultElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author linqinglin
 * @date 2019/04/17 0017 17:48
 */
@Service("backGroupCensorService_610000")
public class SNBackGroupCensorServiceImpl extends BackGroupCensorServiceImpl implements BackGroupCensorService {

    /***
     * 日志
     */
    private static Logger logger = LoggerFactory.getLogger(SNBackGroupCensorServiceImpl.class);
    @Autowired
    private BjRestLogDao bjRestLogDao;

    @Autowired
    private SecurityPersonDao securityPersonDao;

    @Value("${ZAFLAG}")
    private String ZAFLAG;

    @Value("${ZAURL}")
    private String ZAURL;

    @Autowired
    private ConfigService configService;

    @Autowired
    private SysareaService sysareaService;

    @Autowired
    private RedisUtil redisUtil;

    /**
     * 调人口库获取人口库照片信息
     *
     * @param idNumber 身份证号
     * @return
     */
    @Override
    public String getPhoto(String idNumber, String name) {
        PersonBaseInfo populationInfo = getPopulationInfo(idNumber, true);
        /*String strResult = "";
        String code = "";
        int errorCount = 0;
        if (ZAFLAG != null && ZAFLAG.equals(Constants.ZAFLAG_YES)) {
            //人口库调用会异常或超时，循环三次，三次还是异常或超时，则获取失败
            for (int i = 0; i < 3; i++) {
                String result = send(idNumber, Constants.CZ_REQUESTID, Constants.CZ_SERVICEID, new String[]{Constants.INFO_XP});
                //增加日志
                BjRestLog log = new BjRestLog();
                log.setResttype(Constants.CZ_SERVICEID);
                log.setRequestContext(idNumber);
                //创建时间
                log.setCreateTime(new Date());
                //有效标记
                log.setActive(true);
                //更新时间
                log.setUpdateTime(new Date());
                //更新者
                log.setUpdateBy(Constants.APPROVAL_SYSTEM);
                bjRestLogDao.save(log);
                if (StringUtil.isNotEmpty(result)) {
                    try {
                        SAXReader reader = new SAXReader();
                        org.dom4j.Document doc = reader.read(new ByteArrayInputStream(result.getBytes(Constants.CHARSETUTF8)));
                        Element root = doc.getRootElement();
                        Element valueElement = root.element("Method").element("Items").element("Item").element("Value");
                        if (valueElement != null) {
                            List<Element> list = valueElement.elements();
                            //获取执行返回编码
                            if (list != null && list.size() > 0) {
                                Element e = list.get(0);
                                code = e.element("Data").getText();
                            }
                            if (list != null && list.size() > 2) {
                                Element e = list.get(2);
                                strResult = e.element("Data").getText();
                            }
                        } else {
                            //异常次数加1
                            errorCount++;
                        }
                    } catch (Exception e) {
                        logger.error("身份证号：" + idNumber);
                        logger.error("人口库获取异常：" + result);
                        logger.error(e.getMessage(), e);
                        //异常次数加1
                        errorCount++;
                    }
                } else {
                    logger.error("人口库获取异常,没有返回值,身份证号：" + idNumber);
                    //异常次数加1
                    errorCount++;
                }
                //如果执行成功则返回
                if (Constants.ZAFLAG_CODE_SUCCESS.equals(code)) {
                    break;
                }
            }
            if (errorCount == 3) {
                throw new ArsException("调用公安部接口异常！！");
            }
        }*/
        return populationInfo.getPhoto();
    }

    /**
     * 获取人口库信息
     *
     * @param idnum
     * @param needPhoto
     * @return
     */
    @Override
    public PersonBaseInfo getPopulationInfo(String idnum, boolean needPhoto) {
        PersonBaseInfo person = new PersonBaseInfo();
        String code = "";
        int errorCount = 0;
        String key = DateUtil.getCurrentDate(DateUtil.FORMAT11) + "_" + Constants.CZ_SERVICEID;
        String count = redisUtil.get(key);
        if (StringUtil.isNotEmpty(count)) {
            Long total = Long.parseLong(count);
            Long max = 8000L;
            try {
                String configValue = configService.getValueByKey(Constants.POLICE_INTERFACE_MAX);
                max = Long.parseLong(configValue);
            } catch (Exception e) {

            }

            if (total >= max) {
                return person;
            }
        }

        String url = Constants.SN_BACKGROUND_CENSOR_PER_INFO_URL;
        Map<String, Object> snPersonParams = Maps.newHashMap();
        snPersonParams.put("resId", "49");
        snPersonParams.put("sql", " (`GMSFHM`=?)");
        snPersonParams.put("accessId", "ba3146d4");
        snPersonParams.put("accessKey", "99565732e1654334859d52ae98b52c77");
        snPersonParams.put("reqId", "40");
        snPersonParams.put("queryValues", String.format("[{\"type\":\"string\",\"value\":\"%s\"}]", idnum));
        // 调用新接口
        logger.error("snPersonRequestUrl:{}", url);
        logger.error("snPersonParams:{}", JSON.toJSONString(snPersonParams));
        String responseContent = HttpUtil.post(url, snPersonParams);
        SNCensorResult snCensorResult = JSON.parseObject(responseContent, SNCensorResult.class);
        logger.error("snCensorResult:{}", snCensorResult);
        JSONArray data = snCensorResult.getData();
        if (data.size() > 0) {
            JSONObject jsonObject = (JSONObject) data.get(0);
            SNPerInfoDto snPerInfo = JSON.toJavaObject(jsonObject, SNPerInfoDto.class);
            logger.error("snPerInfo:{}", snPerInfo);
            if (snPerInfo != null) {
                if (needPhoto) {
                    String xp = snPerInfo.getZp();
                    String path = xp.substring(0, xp.lastIndexOf("/"));
                    String fileName = xp.substring(xp.lastIndexOf("/") + 1);
                    InputStream photoInputStream = FtpUtils.downloadFile("92.1.31.25", "xyyh", "xyyh@123", 12100, path, fileName);
                    byte[] bytes = IoUtil.readBytes(photoInputStream);
                    String base64Code = Base64.getEncoder().encodeToString(bytes);
                    person.setPhoto(base64Code);
                }
                person.setName(snPerInfo.getXm());
                person.setIdnum(snPerInfo.getGmsfhm());
                return person;
            }
        }

        //人口库调用会异常或超时，循环三次，三次还是异常或超时，则获取失败
/*        for (int i = 0; i < Constants.ZAFLAG_COUNT; i++) {
            //数据保留7天
            redisUtil.getCount(key, 7L);

            RbspService service = new RbspService(Constants.CZ_REQUESTID, Constants.CZ_SERVICEID);
            //用户信息
            service.setUserCardId("asdfasd");
            service.setUserDept("0100");
            service.setUserName("ptjian");
            RbspCall call = service.createCall();
            call.setUrl(ZAURL);
            call.setMethod(RbspConsts.METHOD_QUERY);
            Map<String, Object> params = new HashMap<String, Object>();
            params.put("DataObjectCode", "M001");
            params.put("InfoCodeMode", "1");
            //按身份证号查
            params.put("Condition", "SFZH = '" + idnum.toUpperCase() + "'");
            //返回字段：照片
            params.put("RequiredItems", new String[]{Constants.INFO_XM, Constants.INFO_JGSSX, Constants.INFO_ZZXZ});
            logger.error("params:" + JSONObject.toJSONString(params));
            String requestResult = call.invoke(params);

            //增加日志
            BjRestLog log = new BjRestLog();
            log.setResttype(Constants.CZ_SERVICEID);
            log.setRequestContext("身份证号：" + idnum);
            log.setResponseContext(requestResult);
            //创建时间
            log.setCreateTime(new Date());
            //有效标记
            log.setActive(true);
            //更新时间
            log.setUpdateTime(new Date());
            //更新者
            log.setUpdateBy(Constants.APPROVAL_SYSTEM);
            bjRestLogDao.save(log);

            //如果不为空则没有数据
            if (requestResult != null && !requestResult.equals("")) {
                try {
                    logger.error("requestResult:" + requestResult);
                    String pattern = "\\s{2,}";
                    Pattern r = Pattern.compile(pattern);
                    Matcher m = r.matcher(requestResult);
                    requestResult = m.replaceAll("");
                    SAXReader reader = new SAXReader();
                    Document doc = reader.read(new ByteArrayInputStream(requestResult.getBytes(Constants.CHARSETUTF8)));
                    Element root = doc.getRootElement();
                    Element valueElement = root.element("Method").element("Items").element("Item").element("Value");
                    if (valueElement != null) {
                        List<Element> list = valueElement.elements();
                        //获取执行返回编码
                        if (list != null && list.size() > 0) {
                            Element e = list.get(0);
                            code = e.element("Data").getText();
                        }
                        //获取返回值
                        if (list != null && list.size() > 2) {
                            Element e = list.get(2);
                            String address = ((DefaultElement) e.content().get(2)).getText();
                            //户籍地址，增加   从八大库获取户籍地址，解决保安员证上面的“户籍地址”是不合规问题，从八大库获取合规的户籍信息
                            String areaAdd = sysareaService.findByCodeForFullName(((DefaultElement) e.content().get(1)).getText());
                            address = areaAdd + address.replace(areaAdd, "");
                            person.setName(((DefaultElement) e.content().get(0)).getText());
                            person.setAddress(address);
                            if (needPhoto) {
                                person.setPhoto((getPhoto(idnum, person.getName())));
                            }
                        }
                    }
                } catch (Exception e) {
                    logger.error(e.getMessage(), e);
                    //异常次数加1
                    errorCount++;
                }
            } else {
                logger.error("人口库获取异常,没有返回值,身份证号：" + idnum);
                //异常次数加1
                errorCount++;
            }
            //如果执行成功则返回
            if (Constants.ZAFLAG_CODE_SUCCESS.equals(code)) {
                break;
            }
            if (errorCount == 3) {
                throw new ArsException("调用公安部接口异常！！");
            }
        }*/

        return person;
    }

    /****
     * 背景筛查
     * 不同省份 各自实现
     * @param dto 业务信息
     */
    @Override
    public List<BackgroundApproval> censorFromBase(BackgroundApprovalDto dto, boolean needCZ) {
        Long businessid = dto.getBusinessid();
        String businesstype = dto.getBusinesstype();
        String idNumber = dto.getIdNumber();
        String name = dto.getRealName();
        List<BackgroundApproval> list = new ArrayList<>();
        try {
            BackgroundApproval cz_BackgroundApproval = new BackgroundApproval();
            cz_BackgroundApproval.setActive(true);
            cz_BackgroundApproval.setCreateTime(new Date());
            cz_BackgroundApproval.setUpdateTime(new Date());
            cz_BackgroundApproval.setBusinessid(businessid);
            cz_BackgroundApproval.setApprovaldate(new Date());
            cz_BackgroundApproval.setBusinesstype(businesstype);
            BackgroundApproval xd_BackgroundApproval = cz_BackgroundApproval.clone();
            BackgroundApproval dt_BackgroundApproval = cz_BackgroundApproval.clone();
            BackgroundApproval wf_BackgroundApproval = cz_BackgroundApproval.clone();

            if (needCZ) {
                boolean policeInterface = true;
                if (!Constants.AUTH_STATE_PASS.equals(dto.getAuthState())) {
                    if (Constants.BAYZ.equals(businesstype)) {
                        SecurityPerson person = securityPersonDao.findByIdCardAndActive(idNumber);
                        if (person != null && Constants.AUTH_STATE_PASS.equals(person.getIdentityAuthState())) {
                            policeInterface = false;
                        }
                    }
                } else {
                    policeInterface = false;
                }

                if (policeInterface) {
                    censorCZ(idNumber, name, cz_BackgroundApproval);
                } else {
                    cz_BackgroundApproval.setApprovalreason("主项信息符合");
                    cz_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_TG);
                    cz_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_TG);
                }
                list.add(cz_BackgroundApproval);
            }

            // 吸毒
            try {
                xd_BackgroundApproval.setLibraryType(Constants.LIBRARYTYPE_XD);
                boolean xdResult;
                boolean snCensorResult = getSNCensorResult(idNumber, Constants.LIBRARYTYPE_XD);
                // 吸毒结果为新库结果
                //xdResult = snCensorResult || send(idNumber, name, Constants.XD_REQUESTID, Constants.XD_SERVICEID);
                xdResult = snCensorResult;

                if (xdResult) {
                    xd_BackgroundApproval.setApprovalreason("吸毒人员");
                    xd_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_BTG);
                    xd_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_BTG);
                } else {
                    xd_BackgroundApproval.setApprovalreason("无吸毒记录");
                    xd_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_TG);
                    xd_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_TG);
                }
                list.add(xd_BackgroundApproval);
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
                e.printStackTrace();
            }

            // 在逃
            try {
                dt_BackgroundApproval.setLibraryType(Constants.LIBRARYTYPE_DT);
                boolean ztResult;
                boolean ztCensorResult = getSNCensorResult(idNumber, Constants.LIBRARYTYPE_DT);
                // 在逃结果为新库结果 || 全国库
                //ztResult = ztCensorResult || send(idNumber, name, Constants.DT_REQUESTID, Constants.DT_SERVICEID);
                ztResult = ztCensorResult;

                if (ztResult) {
                    dt_BackgroundApproval.setApprovalreason("在逃人员");
                    dt_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_BTG);
                    dt_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_BTG);
                } else {
                    dt_BackgroundApproval.setApprovalreason("无在逃记录");
                    dt_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_TG);
                    dt_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_TG);
                }
                list.add(dt_BackgroundApproval);
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
                e.printStackTrace();
            }

            // 犯罪
            try {
                wf_BackgroundApproval.setLibraryType(Constants.LIBRARYTYPE_WF);
                boolean wfResult;
                boolean wfCensorResult = getSNCensorResult(idNumber, Constants.LIBRARYTYPE_WF);
                // 违法结果为新库结果 || 全国库
                //wfResult = wfCensorResult || send(idNumber, name, Constants.WF_REQUESTID, Constants.WF_SERVICEID);
                wfResult = wfCensorResult;
                if (wfResult) {
                    wf_BackgroundApproval.setApprovalreason("有违法犯罪记录");
                    wf_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_BTG);
                    wf_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_BTG);
                } else {
                    wf_BackgroundApproval.setApprovalreason("无违法犯罪记录");
                    wf_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_TG);
                    wf_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_TG);
                }
                list.add(wf_BackgroundApproval);
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
                e.printStackTrace();
            }

        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new ArsException("查询人口库异常！");
        }
        return list;
    }

    /***
     * 请求四大库
     * @param idNumber 身份证号
     * @param requestID 请求ID
     * @param serviceID 服务ID
     */
    private boolean send(String idNumber, String name, String requestID, String serviceID) {
        //执行返回的编码
        String code = "";
        //结果返回
        boolean result = false;
        if (ZAFLAG != null && ZAFLAG.equals(Constants.ZAFLAG_YES)) {
            //人口库调用会异常或超时，循环三次，三次还是异常或超时，则获取失败
            for (int i = 0; i < Constants.ZAFLAG_COUNT; i++) {
                String requestResult = send(idNumber, requestID, serviceID, new String[]{Constants.INFO_XM});
                //增加日志
                BjRestLog log = new BjRestLog();
                log.setResttype(serviceID);
                log.setResponseContext(requestResult);
                log.setRequestContext(idNumber);
                //创建时间
                log.setCreateTime(new Date());
                //有效标记
                log.setActive(true);
                //更新时间
                log.setUpdateTime(new Date());
                //更新者
                log.setUpdateBy(Constants.APPROVAL_SYSTEM);
                bjRestLogDao.save(log);
                //如果不为空则没有数据
                if (requestResult != null && !requestResult.equals("")) {
                    try {
                        SAXReader reader = new SAXReader();
                        Document doc = reader.read(new ByteArrayInputStream(requestResult.getBytes("UTF-8")));
                        Element root = doc.getRootElement();
                        Element valueElement = root.element("Method").element("Items").element("Item").element("Value");
                        //valueElement节点为空的话，请求人口库异常
                        if (valueElement != null) {
                            List<Element> list = valueElement.elements();
                            //获取执行返回编码
                            if (list != null && list.size() > 0) {
                                Element e = list.get(0);
                                code = e.element("Data").getText();
                            }
                            //获取查询结果
                            if (list != null && list.size() > 2) {
                                Element e = list.get(2);
                                String resultname = e.element("Data").getText();
                                if (resultname != null && resultname.equals(name)) {
                                    result = true;
                                } else {
                                    result = false;
                                }
                            }
                        }
                    } catch (Exception e) {
                        logger.error("身份证号：" + idNumber + "---姓名：" + name);
                        logger.error("人口库获取异常：" + result);
                        logger.error(e.getMessage(), e);
                        e.printStackTrace();
                    }
                }
                //如果执行成功则返回
                if (Constants.ZAFLAG_CODE_SUCCESS.equals(code)) {
                    break;
                }
            }
            return result;
        } else {
            return true;
        }
    }


    /***
     * 请求四大库
     * @param idNumber 身份证号
     * @param requestID 请求ID
     * @param serviceID 服务ID
     * @param requiredItems 返回结果集
     */
    private String send(String idNumber, String requestID, String serviceID, String[] requiredItems) {
        //结果返回
        String result = StringUtil.EMPTY;
        if (ZAFLAG != null && ZAFLAG.equals(Constants.ZAFLAG_YES)) {
            String key = DateUtil.getCurrentDate(DateUtil.FORMAT11) + "_" + serviceID;
            String count = redisUtil.get(key);
            if (StringUtil.isNotEmpty(count)) {
                Long total = Long.parseLong(count);
                Long max = 8000L;
                try {
                    String configValue = configService.getValueByKey(Constants.POLICE_INTERFACE_MAX);
                    max = Long.parseLong(configValue);
                } catch (Exception e) {

                }

                if (total >= max) {
                    return result;
                }
            }
            //数据保留7天
            redisUtil.getCount(key, 7L);
            RbspService service = new RbspService(requestID, serviceID);
            //用户信息
            service.setUserCardId("asdfasd");
            service.setUserDept("0100");
            service.setUserName("ptjian");
            RbspCall call = service.createCall();
            call.setUrl(ZAURL);
            call.setMethod(RbspConsts.METHOD_QUERY);
            Map<String, Object> params = new HashMap<String, Object>();
            params.put("DataObjectCode", "M001");
            params.put("InfoCodeMode", "1");
            //按身份证号查
            params.put("Condition", "SFZH = '" + idNumber.toUpperCase() + "'");
            //返回字段：身份证号、照片、姓名、性别、文化程度、民族、籍贯省县
            params.put("RequiredItems", requiredItems);
            return call.invoke(params);
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        String requestResult = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" +
                "<RBSPMessage>" +
                "    <Version/>" +
                "    <ServiceID>S10-00000298</ServiceID>" +
                "    <TimeStamp/>" +
                "    <Validity/>" +
                "    <Security>" +
                "        <Signature Algorithm=\"\"/>" +
                "        <CheckCode Algorithm=\"\"/>" +
                "        <Encrypt/>" +
                "    </Security>" +
                "    <Method>" +
                "        <Name>Query</Name>" +
                "        <Items>" +
                "            <Item>" +
                "                <Value Type=\"arrayOfArrayOf_string\">" +
                "                    <Row>" +
                "                        <Data>000</Data>" +
                "                        <Data/>" +
                "                        <Data/>" +
                "                    </Row>" +
                "                    <Row>" +
                "                        <Data>XM</Data>" +
                "                        <Data>JGSSX</Data>" +
                "                        <Data>ZZXZ</Data>" +
                "                    </Row>" +
                "                    <Row>" +
                "                        <Data>张立</Data>" +
                "                        <Data>612523</Data>" +
                "                        <Data>棣花镇万湾社区居委会东塬38号</Data>" +
                "                    </Row>" +
                "                </Value>" +
                "            </Item>" +
                "        </Items>" +
                "    </Method>" +
                "</RBSPMessage>";


        String pattern = "\\s{2,}";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(requestResult);
        requestResult = m.replaceAll("");
        SAXReader reader = new SAXReader();
        Document doc = reader.read(new ByteArrayInputStream(requestResult.getBytes(Constants.CHARSETUTF8)));
        Element root = doc.getRootElement();
        Element valueElement = root.element("Method").element("Items").element("Item").element("Value");
        if (valueElement != null) {
            List<Element> list = valueElement.elements();
            //获取执行返回编码
            if (list != null && list.size() > 0) {
                Element e = list.get(0);
                System.out.println(e.element("Data").getText());
            }
            //获取返回值
            if (list != null && list.size() > 2) {
                Element e = list.get(2);
                System.out.println(((DefaultElement) e.content().get(0)).getText());
                System.out.println(((DefaultElement) e.content().get(1)).getText());
                System.out.println(((DefaultElement) e.content().get(2)).getText());
            }
        }

    }

    /**
     * 陕西获取背景筛查结果
     *
     * @param idNumber 身份证号码
     * @param type     类型
     * @return {@link Boolean} 是否违法/吸毒/在逃
     */
    private boolean getSNCensorResult(String idNumber,
                                      String type) {
        String requestUrl = Constants.SN_BACKGROUND_CENSOR_PER_INFO_URL;
        Map<String, Object> params = Maps.newHashMap();
        switch (type) {
            case Constants.LIBRARYTYPE_DT:
                params.put("resId", "38");
                params.put("sql", "(`ZJHM`=? and `ryzt_jyqk`=0)");
                break;
            case Constants.LIBRARYTYPE_WF:
                params.put("resId", "62");
                params.put("sql", "(`ZJHM`=? and `ryjbxxbj` in ('0','1','5'))");
                break;
            case Constants.LIBRARYTYPE_XD:
                params.put("resId", "57");
                params.put("sql", "(`gmsfhm`=? and `yxx`=1)");
                break;
            default:
                return false;
        }
        params.put("accessId", "ba3146d4");
        params.put("accessKey", "99565732e1654334859d52ae98b52c77");
        params.put("reqId", "40");
        params.put("queryValues", String.format("[{\"type\":\"string\",\"value\":\"%s\"}]", idNumber));
        logger.error("CensorRequestUrl:{}", requestUrl);
        logger.error("censorParams:{}", JSON.toJSONString(params));
        String responseContent = HttpUtil.post(requestUrl, params);
        logger.error("陕西背景筛查新库查询{}返回:{}", idNumber, responseContent);
        SNCensorResult snCensorResult = JSON.parseObject(responseContent, SNCensorResult.class);
        return snCensorResult.getData().size() > 0;
    }
}

