package com.bcxin.ars.webservice.impl;

import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.log.BjRestLogDao;
import com.bcxin.ars.dto.sb.BackgroundApprovalDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.PersonBaseInfo;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.log.BjRestLog;
import com.bcxin.ars.model.sb.BackgroundApproval;
import com.bcxin.ars.service.ConfigService;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.redis.RedisUtil;
import com.bcxin.ars.webservice.BackGroupCensorService;
import com.dragonsoft.node.adapter.comm.RbspCall;
import com.dragonsoft.node.adapter.comm.RbspConsts;
import com.dragonsoft.node.adapter.comm.RbspService;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.dom4j.tree.DefaultElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.ByteArrayInputStream;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author linqinglin
 * @date 2019/04/17 0017 17:48
 */
@Service("backGroupCensorService_640000")
public class NXBackGroupCensorServiceImpl extends BackGroupCensorServiceImpl implements BackGroupCensorService {

    private static Logger logger = LoggerFactory.getLogger(NXBackGroupCensorServiceImpl.class);


    @Autowired
    private BjRestLogDao bjRestLogDao;

    @Autowired
    private SecurityPersonDao securityPersonDao;

    @Autowired
    private ConfigService configService;

    @Autowired
    private RedisUtil redisUtil;

    @Value("${ZAFLAG}")
    private String ZAFLAG;

    @Value("${ZAURL}")
    private String ZAURL;

    @Override
    public String getPhoto(String idNumber,String name) {
        String strResult = "";
        String code = "";
        int errorCount = 0;
        if (ZAFLAG != null && ZAFLAG.equals(Constants.ZAFLAG_YES)) {
            //人口库调用会异常或超时，循环三次，三次还是异常或超时，则获取失败
            for (int i = 0; i < 3; i++) {
                String result = send(idNumber, Constants.NX_CZ_REQUESTID, Constants.NX_CZ_SERVICEID_PHOTO,
                        new String[]{Constants.INFO_XP},Constants.NX_CZPHOTO_DataObjectCode,"001",
                        "GMSFHM");
                //增加日志
                BjRestLog log = new BjRestLog();
                log.setResttype(Constants.NX_CZ_SERVICEID_PHOTO);
                log.setRequestContext(idNumber);
                //创建时间
                log.setCreateTime(new Date());
                //有效标记
                log.setActive(true);
                //更新时间
                log.setUpdateTime(new Date());
                //更新者
                log.setUpdateBy(Constants.APPROVAL_SYSTEM);
                bjRestLogDao.save(log);
                if (StringUtil.isNotEmpty(result)) {
                    try {
                        SAXReader reader = new SAXReader();
                        org.dom4j.Document doc = reader.read(new ByteArrayInputStream(result.getBytes(Constants.CHARSETUTF8)));
                        Element root = doc.getRootElement();
                        Element valueElement = root.element("Method").element("Items").element("Item").element("Value");
                        if (valueElement != null) {
                            List<Element> list = valueElement.elements();
                            //获取执行返回编码
                            if (list != null && list.size() > 0) {
                                Element e = list.get(0);
                                code = e.element("Data").getText();
                            }
                            if (list != null && list.size() > 2) {
                                Element e = list.get(2);
                                strResult = e.element("Data").getText();
                            }
                        } else {
                            //异常次数加1
                            errorCount++;
                        }
                    } catch (Exception e) {
                        logger.error("身份证号：" + idNumber);
                        logger.error("人口库获取异常：" + result);
                        logger.error(e.getMessage(), e);
                        //异常次数加1
                        errorCount++;
                    }
                } else {
                    logger.error("人口库获取异常,没有返回值,身份证号：" + idNumber);
                    //异常次数加1
                    errorCount++;
                }
                //如果执行成功则返回
                if (Constants.ZAFLAG_CODE_SUCCESS.equals(code)) {
                    break;
                }
            }
            if (errorCount == 3) {
                throw new ArsException("调用公安部接口异常！！");
            }
        }
        return strResult;
    }

    @Override
    public PersonBaseInfo getPopulationInfo(String idNumber, boolean needPhoto) {
        PersonBaseInfo person = new PersonBaseInfo();
        String code = "";
        int errorCount = 0;
        //String key = DateUtil.getCurrentDate(DateUtil.FORMAT11) + "_" + Constants.NX_CZ_SERVICEID_INFO;
        //String count = redisUtil.get(key);
        //if (StringUtil.isNotEmpty(count)) {
        //    Long total = Long.parseLong(count);
        //    Long max = 8000L;
        //    try {
        //        String configValue = configService.getValueByKey(Constants.POLICE_INTERFACE_MAX);
        //        max = Long.parseLong(configValue);
        //    } catch (Exception e) {
        //
        //    }
        //
        //    if (total >= max) {
        //        return person;
        //    }
        //}

        //人口库调用会异常或超时，循环三次，三次还是异常或超时，则获取失败
        for (int i = 0; i < Constants.ZAFLAG_COUNT; i++) {
            //数据保留7天
            //redisUtil.getCount(key, 7L);
            String requestResult = send(idNumber, Constants.NX_CZ_REQUESTID, Constants.NX_CZ_SERVICEID_INFO,
                    new String[]{Constants.INFO_XM, Constants.INFO_JGSSX, Constants.INFO_ZZ},
                    Constants.NX_CZINFO_DataObjectCode,"002","GMSFHM");

            //增加日志
            BjRestLog log = new BjRestLog();
            log.setResttype(Constants.NX_CZ_SERVICEID_INFO);
            log.setRequestContext(idNumber);
            log.setResponseContext(requestResult);
            //创建时间
            log.setCreateTime(new Date());
            //有效标记
            log.setActive(true);
            //更新时间
            log.setUpdateTime(new Date());
            //更新者
            log.setUpdateBy(Constants.APPROVAL_SYSTEM);
            bjRestLogDao.save(log);

            //如果不为空则没有数据
            if (requestResult != null && !requestResult.equals("")) {
                try {
                    String pattern = "\\s{2,}";
                    Pattern r = Pattern.compile(pattern);
                    Matcher m = r.matcher(requestResult);
                    requestResult = m.replaceAll("");
                    SAXReader reader = new SAXReader();
                    Document doc = reader.read(new ByteArrayInputStream(requestResult.getBytes(Constants.CHARSETUTF8)));
                    Element root = doc.getRootElement();
                    Element valueElement = root.element("Method").element("Items").element("Item").element("Value");
                    if (valueElement != null) {
                        List<Element> list = valueElement.elements();
                        //获取执行返回编码
                        if (list != null && list.size() > 0) {
                            Element e = list.get(0);
                            code = e.element("Data").getText();
                        }
                        //获取返回值
                        if (list != null && list.size() > 2) {
                            Element e = list.get(2);
                            String address = ((DefaultElement) e.content().get(2)).getText();
                            person.setName(((DefaultElement) e.content().get(0)).getText());
                            person.setAddress(address);
                            if (needPhoto) {
                                person.setPhoto((getPhoto(idNumber, person.getName())));
                            }
                        }
                    }
                } catch (Exception e) {
                    logger.error(e.getMessage(), e);
                    //异常次数加1
                    errorCount++;
                }
            } else {
                logger.error("人口库获取异常,没有返回值,身份证号：" + idNumber);
                //异常次数加1
                errorCount++;
            }
            //如果执行成功则返回
            if (Constants.ZAFLAG_CODE_SUCCESS.equals(code)) {
                break;
            }
            if (errorCount == 3) {
                throw new ArsException("调用公安部接口异常！！");
            }
        }

        return person;
    }



    /***
     * 请求四大库 获取基本信息，图片
     * @param idNumber 身份证号
     * @param requestID 请求ID
     * @param serviceID 服务ID
     * @param requiredItems 返回结果集
     */
    private String send(String idNumber, String requestID, String serviceID, String[] requiredItems,
                        String DataObjectCode,String InfoCodeMode ,String idType) {
        //结果返回
        String result = StringUtil.EMPTY;
        if (ZAFLAG != null && ZAFLAG.equals(Constants.ZAFLAG_YES)) {
            //String key = DateUtil.getCurrentDate(DateUtil.FORMAT11) + "_" + serviceID;
            //String count = redisUtil.get(key);
            //if (StringUtil.isNotEmpty(count)) {
            //    Long total = Long.parseLong(count);
            //    Long max = 8000L;
            //    try {
            //        String configValue = configService.getValueByKey(Constants.POLICE_INTERFACE_MAX);
            //        max = Long.parseLong(configValue);
            //    } catch (Exception e) {
            //
            //    }
            //
            //    if (total >= max) {
            //        return result;
            //    }
            //}
            ////数据保留7天
            //redisUtil.getCount(key, 7L);
            RbspService service = new RbspService(requestID, serviceID);
            //用户信息
            service.setUserCardId("asdfasd");
            service.setUserDept("0100");
            service.setUserName("ptjian");
            RbspCall call = service.createCall();
            call.setUrl(ZAURL);
            call.setMethod(RbspConsts.METHOD_QUERY);
            Map<String, Object> params = new HashMap<String, Object>();
            params.put("DataObjectCode", DataObjectCode);
            params.put("InfoCodeMode", InfoCodeMode);
            //按身份证号查
            params.put("Condition", idType+ "= '" + idNumber.toUpperCase() + "'");
            //返回字段：
            params.put("RequiredItems", requiredItems);

            logger.error("请求地址：{}", ZAURL);
            logger.error("请求参数：{}", JSON.toJSONString(params));
            result = call.invoke(params);
            logger.error("返回结果：{}", result);
        }
        return result;
    }
    /****
     * 背景筛查
     * 不同省份 各自实现
     * @param dto 业务信息
     */
    @Override
    public List<BackgroundApproval> censorFromBase(BackgroundApprovalDto dto, boolean needCZ) {
        Long businessid = dto.getBusinessid();
        String businesstype = dto.getBusinesstype();
        String idNumber = dto.getIdNumber();
        String name = dto.getRealName();
        List<BackgroundApproval> list = new ArrayList<>();
        try {
            BackgroundApproval cz_BackgroundApproval = new BackgroundApproval();
            cz_BackgroundApproval.setActive(true);
            cz_BackgroundApproval.setCreateTime(new Date());
            cz_BackgroundApproval.setUpdateTime(new Date());
            cz_BackgroundApproval.setBusinessid(businessid);
            cz_BackgroundApproval.setApprovaldate(new Date());
            cz_BackgroundApproval.setBusinesstype(businesstype);
            BackgroundApproval xd_BackgroundApproval = cz_BackgroundApproval.clone();
            BackgroundApproval dt_BackgroundApproval = cz_BackgroundApproval.clone();
            BackgroundApproval wf_BackgroundApproval = cz_BackgroundApproval.clone();

            if (needCZ) {
                boolean policeInterface = true;
                if (!Constants.AUTH_STATE_PASS.equals(dto.getAuthState())) {
                    if (Constants.BAYZ.equals(businesstype)) {
                        SecurityPerson person = securityPersonDao.findByIdCardAndActive(idNumber);
                        if (person != null && Constants.AUTH_STATE_PASS.equals(person.getIdentityAuthState())) {
                            policeInterface = false;
                        }
                    }
                } else {
                    policeInterface = false;
                }

                if (policeInterface) {
                    censorCZ(idNumber, name, cz_BackgroundApproval);
                } else {
                    cz_BackgroundApproval.setApprovalreason("主项信息符合");
                    cz_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_TG);
                    cz_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_TG);
                }
                list.add(cz_BackgroundApproval);
            }

            // 吸毒
            try {
                xd_BackgroundApproval.setLibraryType(Constants.LIBRARYTYPE_XD);
                boolean xdResult = send(idNumber, name, Constants.NX_XD_REQUESTID, Constants.NX_XD_SERVICEID);

                if (xdResult) {
                    xd_BackgroundApproval.setApprovalreason("吸毒人员");
                    xd_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_BTG);
                    xd_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_BTG);
                } else {
                    xd_BackgroundApproval.setApprovalreason("无吸毒记录");
                    xd_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_TG);
                    xd_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_TG);
                }
                list.add(xd_BackgroundApproval);
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
                e.printStackTrace();
            }

            // 在逃
            try {
                dt_BackgroundApproval.setLibraryType(Constants.LIBRARYTYPE_DT);
                boolean ztResult = send(idNumber, name, Constants.NX_DT_REQUESTID, Constants.NX_DT_SERVICEID);

                if (ztResult) {
                    dt_BackgroundApproval.setApprovalreason("在逃人员");
                    dt_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_BTG);
                    dt_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_BTG);
                } else {
                    dt_BackgroundApproval.setApprovalreason("无在逃记录");
                    dt_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_TG);
                    dt_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_TG);
                }
                list.add(dt_BackgroundApproval);
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
                e.printStackTrace();
            }

            // 犯罪
            try {
                wf_BackgroundApproval.setLibraryType(Constants.LIBRARYTYPE_WF);
                boolean wfResult = send(idNumber, name, Constants.NX_WF_REQUESTID, Constants.NX_WF_SERVICEID);

                if (wfResult) {
                    wf_BackgroundApproval.setApprovalreason("有违法犯罪记录");
                    wf_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_BTG);
                    wf_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_BTG);
                } else {
                    wf_BackgroundApproval.setApprovalreason("无违法犯罪记录");
                    wf_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_TG);
                    wf_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_TG);
                }
                list.add(wf_BackgroundApproval);
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
                e.printStackTrace();
            }

        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new ArsException("查询人口库异常！");
        }
        return list;
    }

    /***
     * 请求四大库
     * @param idNumber 身份证号
     * @param requestID 请求ID
     * @param serviceID 服务ID
     */
    private boolean send(String idNumber, String name, String requestID, String serviceID) {

        String DataObjectCode=Constants.NX_ZDRY_DataObjectCode;
        String InfoCodeMode="002";
        //执行返回的编码
        String code = "";
        //结果返回
        boolean result = false;
        if (ZAFLAG != null && ZAFLAG.equals(Constants.ZAFLAG_YES)) {
            //人口库调用会异常或超时，循环三次，三次还是异常或超时，则获取失败
            for (int i = 0; i < Constants.ZAFLAG_COUNT; i++) {
                String requestResult = send(idNumber, requestID, serviceID, new String[]{Constants.INFO_XM}
                ,DataObjectCode,InfoCodeMode,"SFZH");
                //增加日志
                BjRestLog log = new BjRestLog();
                log.setResttype(serviceID);
                log.setResponseContext(requestResult);
                log.setRequestContext(idNumber);
                //创建时间
                log.setCreateTime(new Date());
                //有效标记
                log.setActive(true);
                //更新时间
                log.setUpdateTime(new Date());
                //更新者
                log.setUpdateBy(Constants.APPROVAL_SYSTEM);
                bjRestLogDao.save(log);
                //如果不为空则没有数据
                if (requestResult != null && !requestResult.equals("")) {
                    try {
                        SAXReader reader = new SAXReader();
                        Document doc = reader.read(new ByteArrayInputStream(requestResult.getBytes("UTF-8")));
                        Element root = doc.getRootElement();
                        Element valueElement = root.element("Method").element("Items").element("Item").element("Value");
                        //valueElement节点为空的话，请求人口库异常
                        if (valueElement != null) {
                            List<Element> list = valueElement.elements();
                            //获取执行返回编码
                            if (list != null && list.size() > 0) {
                                Element e = list.get(0);
                                code = e.element("Data").getText();
                            }
                            //获取查询结果
                            if (list != null && list.size() > 2) {
                                Element e = list.get(2);
                                String resultname = e.element("Data").getText();
                                if (resultname != null && resultname.equals(name)) {
                                    result = true;
                                } else {
                                    result = false;
                                }
                            }
                        }
                    } catch (Exception e) {
                        logger.error("身份证号：" + idNumber + "---姓名：" + name);
                        logger.error("人口库获取异常：" + result);
                        logger.error(e.getMessage(), e);
                        e.printStackTrace();
                    }
                }
                //如果执行成功则返回
                if (Constants.ZAFLAG_CODE_SUCCESS.equals(code)) {
                    break;
                }
            }
            return result;
        } else {
            return true;
        }
    }

    public static void main(String[] args) {
        String requestResult = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><RBSPMessage>    <Version/>    <ServiceID>S64-00000075</ServiceID>    <TimeStamp/>    <Validity/>    <Security>        <Signature Algorithm=\"\"/>        <CheckCode Algorithm=\"\"/>        <Encrypt/>    </Security>    <Method>        <Name>Query</Name>        <Items>            <Item>                <Value Type=\"arrayOfArrayOf_string\">                    <Row>                        <Data>000</Data>                        <Data/>                        <Data/>                    </Row>                    <Row>                        <Data>XM</Data>                        <Data>JGSSX</Data>                        <Data>ZZ</Data>                    </Row>                    <Row>                        <Data>王军</Data>                        <Data>山东</Data>                        <Data>宁夏银川市西夏区朔方路68号9-1-501号</Data>                    </Row>                </Value>            </Item>        </Items>    </Method></RBSPMessage>";
        PersonBaseInfo person = new PersonBaseInfo();
        String code = "";
        try {
            String pattern = "\\s{2,}";
            Pattern r = Pattern.compile(pattern);
            Matcher m = r.matcher(requestResult);
            requestResult = m.replaceAll("");
            SAXReader reader = new SAXReader();
            Document doc = reader.read(new ByteArrayInputStream(requestResult.getBytes(Constants.CHARSETUTF8)));
            Element root = doc.getRootElement();
            Element valueElement = root.element("Method").element("Items").element("Item").element("Value");
            if (valueElement != null) {
                List<Element> list = valueElement.elements();
                //获取执行返回编码
                if (list != null && list.size() > 0) {
                    Element e = list.get(0);
                    code = e.element("Data").getText();
                }
                //获取返回值
                if (list != null && list.size() > 2) {
                    Element e = list.get(2);
                    String address = ((DefaultElement) e.content().get(2)).getText();
                    person.setName(((DefaultElement) e.content().get(0)).getText());
                    person.setAddress(address);
                }
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
        }

        System.out.println(JSON.toJSONString(person));
    }

}
