package com.bcxin.ars.webservice;

import com.bcxin.ars.dao.ProblemPersonDao;
import com.bcxin.ars.dao.SecurityCompanyPersonDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dao.gxhlwWeb.SxlwlogDao;
import com.bcxin.ars.dao.log.BjRestLogDao;
import com.bcxin.ars.dao.sb.*;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.gxhlwWeb.Sxlwlog;
import com.bcxin.ars.model.log.BjRestLog;
import com.bcxin.ars.model.sb.*;
import com.bcxin.ars.service.ConfigService;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import org.apache.axis.client.Call;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.*;

/**
 * web service 服务工具类 Created by 苏 on 2017/7/19.
 */
@Service
public class ClientUtil {
	private static Logger logger = LoggerFactory.getLogger(ClientUtil.class);
	//@Value("${SIGNATURE}")
	private static String SIGNATURE="" ;
	//@Value("${ACCOUNT_ID}")
	private static String ACCOUNT_ID="";
	//@Value("${ORG_CODE}")
	private  static String ORG_CODE ="";
	//	@Value("${ORG_NAME}")
	private static String ORG_NAME="" ;
	//	@Value("${PASSWORD}")
	private static   String PASSWORD="";
	//	@Value("${ZAURL}")
	private static String ZAURL="";
	private static String SXNWCode = "";
	private static String SXNWAddress = "";
	//	@Value("${serviceAddress}")
	private static String serviceAddress ="";

	private String current_native ="";

	//广西指纹库地址
	private static String GXZWAddress = "";
	private static String ZAFLAG;
	@Autowired
	private BackgroundApprovalDao backgroundApprovalDao;

	@Autowired
	private SecurityPersonDao securityPersonDao;

	@Autowired
	private ProblemPersonDao problemPersonDao;

	@Autowired
	private UserDao userDao;

	@Autowired
	private SecurityCompanyPersonDao securityCompanyPersonDao;
    @Autowired
    private GradePersonDao gradePersonDao;
	@Autowired
	private PersoncertificateDao personcertificateDao;

	@Autowired
	private SponsorlicenseDao sponsorlicenseDao;

	@Autowired
	private ShareholderDao shareholderDao;

	@Autowired
	private TraincompanyapplyDao traincompanyapplyDao;

	@Autowired
	private SubsidiaryDao subsidiaryDao;

	@Autowired
	private ConfesscompanyDao confesscompanyDao;

	@Autowired
	private CrosscompanyDao crosscompanyDao;

	@Autowired
	private LegalchangeDao legalchangeDao;

	@Autowired
	private TrainChangeDao trainChangeDao;

	@Autowired
	private ArmtrainorgDao armtrainorgDao;

	@Autowired
	private ArmorgchargeDao armorgchargeDao;

	@Autowired
	private ArmtrainchargeDao armtrainchargeDao;

	@Autowired
	private ArmorgteachDao armorgteachDao;

	@Autowired
	private SxlwlogDao sxlwlogDao;

	@Autowired
	private BjRestLogDao bjRestLogDao;

	@Autowired
	private ConfigService configService;

	@Autowired
	private ConfesscompanyundoDao confesscompanyundoDao;

	@Autowired
	private PersonGradeDao personGradeDao;

	@Autowired
	private SbSponsorlicenseManagerDao sbSponsorlicenseManagerDao;

	@Autowired
	private SbSponsorlicenseVmanagerDao sbSponsorlicenseVmanagerDao;

	@Autowired
	private PersonAdaptDao personAdaptDao;

	@Autowired
	private TrainrecordDao trainrecordDao;

	@Value("${base-folder}")
	private String baseFolder;

	static {
		ResourceBundle rb = ResourceBundle.getBundle("config");
		SIGNATURE = rb.getString("SIGNATURE");
		serviceAddress = rb.getString("serviceAddress");
		ACCOUNT_ID = rb.getString("ACCOUNT_ID");
		ORG_CODE = rb.getString("ORG_CODE");
		ORG_NAME = rb.getString("ORG_NAME");
		PASSWORD = rb.getString("PASSWORD");
		ZAURL = rb.getString("ZAURL");
		ZAFLAG =rb.getString("ZAFLAG");
		SXNWAddress = rb.getString("SXNWAddress");
		SXNWCode = rb.getString("SXNWCode");
		//广西指纹库地址
		GXZWAddress = rb.getString("GXZWAddress");
	}
	/***
	 * 请求头部拼凑
	 * @param requestSoap
	 */
	public  void buildRequestHeadData(StringBuffer requestSoap) {
		requestSoap.append("<dat:LICENSE>").append("<web:SIGNATURE>").append(SIGNATURE).append("</web:SIGNATURE>").append("<web:USERINFO>")
				.append("<web:ACCOUNT_ID>").append(ACCOUNT_ID).append("</web:ACCOUNT_ID>").append("<web:ORG_CODE>").append(ORG_CODE).append("</web:ORG_CODE>")
				.append("<web:ORG_NAME>").append(ORG_NAME).append("</web:ORG_NAME>").append("<web:PASSWORD>").append(PASSWORD).append("</web:PASSWORD>")
				.append("</web:USERINFO>").append("</dat:LICENSE>");
	}
	/***
	 * 数据拼接
	 * @param requestSoap
	 * @param obj
	 */
	public  void buildRequestRecord(StringBuffer requestSoap, Object obj) {
		if("".equals(current_native)){
			Config config = configService.getConfigByKey(Constants.CURRENT_NATIVE);
			current_native = config.getValue();
		}

		String className = obj.getClass().getSimpleName().toLowerCase().substring(0, 3);

		requestSoap.append("<dat:PACKAGE>").append("<" + className + ":DATA>").append("<" + className + ":RECORD>");
		Field[] field = obj.getClass().getDeclaredFields();
		try {
			for (int j = 0; j < field.length; j++) { // 遍历所有属性
				String name = field[j].getName(); // 获取属性的名字
				String valuestr = "";
				name = name.substring(0, 1).toUpperCase() + name.substring(1); // 将属性的首字符大写，方便构造get，set方法
				String type = field[j].getGenericType().toString(); // 获取属性的类型
				if (type.equals("class java.lang.String")) { // 如果type是类类型，则前面包含"class "，后面跟类名
					Method m = obj.getClass().getMethod("get" + name);
					String value = (String) m.invoke(obj); // 调用getter方法获取属性值
					if (value != null && !"null".equals(value)) {
						valuestr = value;
					}
				}
				if (type.equals("class java.lang.Integer")) {
					Method m = obj.getClass().getMethod("get" + name);
					Integer value = (Integer) m.invoke(obj);
					if (value != null && !"null".equals(value)) {
						valuestr = value.toString();
					}
				}
				if (type.equals("class java.lang.Boolean")) {
					Method m = obj.getClass().getMethod("get" + name);
					Boolean value = (Boolean) m.invoke(obj);
					if (value != null && !"null".equals(value)) {
						valuestr = value.toString();
					}
				}
				if (type.equals("class java.util.Date")) {
					Method m = obj.getClass().getMethod("get" + name);
					Date value = (Date) m.invoke(obj);
					if (value != null && !"null".equals(value)) {
						valuestr = value.toString();
					}
				}
				requestSoap.append("<" + className + ":" + name.toUpperCase() + ">" + valuestr + "</" + className + ":" + name.toUpperCase() + ">");
			}
		} catch (NoSuchMethodException e) {
			logger.error(e.getMessage(),e);
		} catch (SecurityException e) {
			logger.error(e.getMessage(),e);
		} catch (IllegalAccessException e) {
			logger.error(e.getMessage(),e);
		} catch (IllegalArgumentException e) {
			logger.error(e.getMessage(),e);
		} catch (InvocationTargetException e) {
			logger.error(e.getMessage(),e);
		}

		String FSSJ = DateUtil.getCurrentDateTime(DateUtil.FORMAT12);

		String JYLCH ="00"+current_native+FSSJ+getRadom(11);


		requestSoap.append("</" + className + ":RECORD>").append("</" + className + ":DATA>").append("<" + className + ":PACKAGEHEAD>")
				.append("<web:DQY></web:DQY>").append("<web:FSSJ>"+FSSJ+"</web:FSSJ>").append("<web:JLS></web:JLS>")
				.append("<web:JYLCH>"+JYLCH+"</web:JYLCH>").append("<web:MYJLS></web:MYJLS>").append("<web:SBH>"+current_native+"</web:SBH>")
				.append("<web:SID></web:SID>").append("</" + className + ":PACKAGEHEAD>").append("</dat:PACKAGE>");
	}
    /***
     * 生成随机数
     * @param length 长度
     * @return
     */
	public static String getRadom(int length){
		//获取一个随机数
		double rand = Math.random();
		//将随机数转换为字符串
		String str = String.valueOf(rand).replace("0.", "");
		//截取字符串
		String newStr = str.substring(0, length);
	    return newStr;
	}


	/***
	 * 发送请求
	 * 部级接口对接
	 * @param type
	 *            类型
	 * @param o
	 *            对象
	 * @return
	 */
	public Result send(String type, Object o) {

		//弃用，用定时器MinisterialUtil
		if(true){
			return new Result();
		}
		/**
		 * 调用日志信息
		 */
		BjRestLog bjRestLog= new BjRestLog();
		bjRestLog.setResttype(type);
		StringBuffer requestSoap = new StringBuffer();

		String className = o.getClass().getSimpleName();

		// 头部
		requestSoap.append("<?xml version=\"1.0\" encoding=\"utf-8\"?><soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" "
				+ "xmlns:dat=\"http://datarecord.webservice.ssis.com\" xmlns:web=\"http://webservice.entity.ssis.com\" xmlns:"
				+ className.toLowerCase().substring(0, 3) + "=\"http://" + className.toLowerCase() + ".request.datarecord.webservice.entity.ssis.com\">"
				+ "<soapenv:Header/>" + "<soapenv:Body>");
		if(className.equals("Babzjl")) {
			requestSoap.append("<dat:xxba_").append(o.getClass().getSimpleName()).append("xx>");
		}else{
			requestSoap.append("<dat:xxba_").append(o.getClass().getSimpleName()).append(">");
		}
		/***
		 * 许可证
		 */
		buildRequestHeadData(requestSoap);
		/***
		 * 申报数据
		 */
		buildRequestRecord(requestSoap, o);
		/***
		 *
		 */
		if(className.equals("Babzjl")) {
			requestSoap.append("</dat:xxba_").append(o.getClass().getSimpleName()).append("xx>");
		}else{
			requestSoap.append("</dat:xxba_").append(o.getClass().getSimpleName()).append(">");
		}
		// 结尾
		requestSoap.append("</soapenv:Body>").append("</soapenv:Envelope>");
		String charSet = "utf-8";
		String contentType = "text/xml; charset=utf-8";

		// 返回结果
		Result result = new Result();
		SAXReader reader = new SAXReader();
		String responseSoapxml ="";
		try {
			Map<String, Object> responseSoapMap = responseSoap(requestSoap.toString(), serviceAddress, charSet, contentType);
			int statusCode = (int) responseSoapMap.get("statusCode");
			// 如果是200则调用成功，并且返回相应的信息
			if (statusCode == 200) {
				responseSoapxml = (String) responseSoapMap.get("responseSoap");
				org.dom4j.Document doc = reader.read(new ByteArrayInputStream(responseSoapxml.getBytes("UTF-8")));
				Element root = doc.getRootElement();
				List<Element> list = null;
				if(className.equals("Babzjl")) {
					className +="xx";
				}
				list = root.element("Body").element("xxba_" +className + "Response").element("PACKAGE").element("DATA")
						.elements();
				if (list != null && list.size() >= 1) {
					result.setCODE(root.element("Body").element("xxba_" +className + "Response").element("PACKAGE").element("DATA")
							.element("RESRECORD").element("CODE").getText());
					result.setMSG(root.element("Body").element("xxba_" +className + "Response").element("PACKAGE").element("DATA")
							.element("RESRECORD").element("MSG").getText());
				}
			} else {
				result.setCODE(statusCode + "");
				result.setMSG("调用接口接口出错");
				result.setERRORMSG("调用部级接口接口出错");
			}
		} catch (Exception e) {

			result.setCODE(Constants.MINISTRY_CODE_ERROR);
			result.setMSG(e.getMessage());
			result.setERRORMSG(e.getMessage());
			logger.error(e.getMessage(),e);
		}
		//执行结果编码
		bjRestLog.setCode(result.getCODE());
		//执行结果信息
		bjRestLog.setMsg(result.getMSG());
		//请求报文，照片不需要存在请求报文格式
		if(!type.equals(Constants.XXBA_ZPXXB)){
			bjRestLog.setRequestContext(requestSoap.toString());
		}

		//响应报文
		bjRestLog.setResponseContext(responseSoapxml);
		//创建时间
		bjRestLog.setCreateTime(new Date());
		//有效标记
		bjRestLog.setActive(true);
		//更新时间
		bjRestLog.setUpdateTime(new Date());
		//更新者
		bjRestLog.setUpdateBy(Constants.APPROVAL_SYSTEM);
		bjRestLogDao.save(bjRestLog);
		return result;
	}

	public static void main(String[] arg) throws Exception {
		/*String xml ="<?xml version=\"1.0\" encoding=\"UTF-8\"?><Package><PackageHead><BBH>2.0</BBH><SJBBH>450000000000201810100001</SJBBH><SJBLX>zw_hc</SJBLX><DWDM>450000000000</DWDM><DWMC>广西壮族自治区公安厅</DWMC><JLS>1</JLS><FSSJ>20181017105152</FSSJ></PackageHead><Data><Record><SFZHM MC=\"SFZHM\">45262919980717272X</SFZHM><SFZWZ MC=\"SFZWZ\">1</SFZWZ></Record></Data></Package>";
		SAXReader reader = new SAXReader();
		org.dom4j.Document doc = reader.read(new ByteArrayInputStream(xml.getBytes("UTF-8")));
		org.dom4j.Element root = doc.getRootElement();
		List<Element> list = root.element("Data").element("Record").elements();
		if (list != null && list.size() >= 2) {
			Element e = list.get(1);
			System.out.println( e.getText());
		}*/
				/*String xml ="<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" +
				"<RBSPMessage>\n" +
				"    <Version/>\n" +
				"    <ServiceID>S10-00000008</ServiceID>\n" +
				"    <TimeStamp/>\n" +
				"    <Validity/>\n" +
				"    <Security>\n" +
				"        <Signature Algorithm=\"\"/>\n" +
				"        <CheckCode Algorithm=\"\"/>\n" +
				"        <Encrypt/>\n" +
				"    </Security>\n" +
				"    <Method>\n" +
				"        <Name>Query</Name>\n" +
				"        <Items>\n" +
				"            <Item>\n" +
				"                <Value Type=\"arrayOfArrayOf_string\">\n" +
				"                    <Row>\n" +
				"                        <Data>000</Data>\n" +
				"                    </Row>\n" +
				"                    <Row>\n" +
				"                        <Data>XP</Data>\n" +
				"                    </Row>\n" +
				"                    <Row>\n" +
				"                        <Data>1234567kfljdakljflkadj8</Data>\n" +
				"                    </Row>\n" +
				"                </Value>\n" +
				"            </Item>\n" +
				"        </Items>\n" +
				"    </Method>\n" +
				"</RBSPMessage>";
		SAXReader reader = new SAXReader();
		org.dom4j.Document doc = reader.read(new ByteArrayInputStream(xml.getBytes("UTF-8")));
		org.dom4j.Element root = doc.getRootElement();
		List<Element> list = root.element("Method").element("Items").element("Item").element("Value").elements();
				Element e  = list.get(2);

			System.out.println(	e.element("Data").getText());*/

		/*String xml = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:dat=\"http://dataquery.webservice.ssis.com\" xmlns:web=\"http://webservice.entity.ssis.com\" xmlns:dat1=\"http://dataquery.webservice.entity.ssis.com\" xmlns:res=\"http://response.dataquery.webservice.entity.ssis.com\">\n" +
				"<soapenv:Header/>\n" +
				"<soapenv:Body>\n" +
				"<dat:dataQueryNow>\n" +
				"<dat:in0><web:SIGNATURE>aaa</web:SIGNATURE>\n" +
				"<web:USERINFO>\n" +
				"<web:ACCOUNT_ID>123</web:ACCOUNT_ID>\n" +
				"<web:ORG_CODE></web:ORG_CODE>\n" +
				"<web:ORG_NAME></web:ORG_NAME>\n" +
				"<web:PASSWORD>111</web:PASSWORD>\n" +
				"</web:USERINFO>\n" +
				"</dat:in0>\n" +
				"<dat:in1>\n" +
				"<dat1:packageHead>\n" +
				"<web:DQY></web:DQY>\n" +
				"<web:FSSJ>20160715182301001</web:FSSJ>\n" +
				"<web:JLS></web:JLS>\n" +
				"<web:JYLCH>20160715182301000001</web:JYLCH>\n" +
				"<web:MYJLS></web:MYJLS>\n" +
				"<web:SBH>11</web:SBH>\n" +
				"<web:SID>0103</web:SID>\n" +
				"</dat1:packageHead>\n" +
				"<dat1:record>\n" +
				"<!--Zero or more repetitions:-->\n" +
				"<res:MapData>\n" +
				"<res:list>\n" +
				"<!--Zero or more repetitions:-->\n" +
				"<res:Entry>\n" +
				"<res:key>sfzh</res:key>\n" +
				"<res:value>640381199307226149</res:value>\n" +
				"</res:Entry>\n" +
				"<res:Entry>\n" +
				"<res:key>zpfl</res:key>\n" +
				"<res:value>01</res:value>\n" +
				"</res:Entry>\n" +
				"</res:list>\n" +
				"</res:MapData>\n" +
				"</dat1:record>\n" +
				"</dat:in1>\n" +
				"</dat:dataQueryNow>\n" +
				"</soapenv:Body>\n" +
				"</soapenv:Envelope>";
		String charSet = "utf-8";
		String contentType = "text/xml; charset=utf-8";
		ClientUtil clientUtil = new ClientUtil();
		Result result = new Result();
		SAXReader reader = new SAXReader();
		Map<String, Object> responseSoapMap = clientUtil.responseSoap(xml, "http://123.59.94.75:50000/ssis/ws/DataQueryService", charSet, contentType);
		try {
			int statusCode = (int) responseSoapMap.get("statusCode");
			// 如果是200则调用成功，并且返回相应的信息
			if (statusCode == 200) {
				String responseSoapxml = (String) responseSoapMap.get("responseSoap");
				 System.out.println(responseSoapxml);
			} else {
				result.setCODE(statusCode + "");
				result.setMSG("调用接口接口出错");
				result.setERRORMSG("调用部级接口接口出错");
			}
		} catch (Exception e) {
			result.setCODE("500");
			result.setMSG(e.getMessage());
			result.setERRORMSG(e.getMessage());
			logger.error(e.getMessage(),e);
		}*/
		/*
		 * Bayxxb bayxxb = new Bayxxb(); bayxxb.setBaydj("20");
		 * bayxxb.setBayzbm("11012011010011");
		 *//*
			 * Hwjyxx hwjyxx = new Hwjyxx(); hwjyxx.setBagsbm("11");
			 * hwjyxx.setBagsmc("12121"); hwjyxx.setGj("1");
			 *//*
				 *
				 * Result result = send("",bayxxb);
				 */
		/*
		 * Bayxxb bayxxb = new Bayxxb(); bayxxb.setBaydj("20");
		 * bayxxb.setBayzbm("11012011010011"); bayxxb.setByzk(2);
		 * bayxxb.setBz1("备注1"); bayxxb.setBz2("备注2"); bayxxb.setBz3("备注3");
		 * bayxxb.setCsrq("2017-31-01"); bayxxb.setDxjdjg("机构2");
		 * bayxxb.setDxjdjgbm("123456789011"); bayxxb.setFzjgbm("110100001234");
		 * bayxxb.setFzjgmc("北京市公安局"); bayxxb.setFzrq("2017-07-21");
		 * bayxxb.setHj("110101"); bayxxb.setHyzk("10");
		 * bayxxb.setLrjgbm("110000000001"); bayxxb.setLrjgmc("北京市公安局");
		 * bayxxb.setPxdwbm("BAP110011"); bayxxb.setSfzh("211402198903091056");
		 * bayxxb.setSg(180.0); bayxxb.setWhcd("10"); bayxxb.setXb(1);
		 * bayxxb.setXm("刘北京"); bayxxb.setXxdz("北京市朝阳区小营北路100号");
		 * bayxxb.setZpxx("刘北京证件照"); bayxxb.setZwxx("BA211402198903091056");
		 * bayxxb.setZzmm("10");
		 *
		 * System.out.println(result.getMSG());
		 */
	}

	/**
	 * <p>
	 * Description: 根据请求报文，请求服务地址获取 响应报文
	 *
	 * @param requestSoap
	 *            请求报文
	 * @param serviceAddress
	 *            响应报文
	 * @param charSet
	 *            字符集
	 * @param contentType
	 *            类型
	 * @return map封装的 服务器响应参数和返回报文.PS:statusCode :200 正常响应。responseSoap：响应报文
	 *         <p>
	 *         thinking:
	 *         </p>
	 *
	 * @author huoge </span>
	 * */
	public  Map<String, Object> responseSoap(String requestSoap, String serviceAddress, String charSet, String contentType) {
		String responseSoap = "";
		Map<String, Object> resultmap = new HashMap<String, Object>();
		PostMethod postMethod = new PostMethod(serviceAddress);
		byte[] b = new byte[0];
		try {
			b = requestSoap.getBytes(charSet);
		} catch (UnsupportedEncodingException e) {
			logger.error(e.getMessage(),e);
		}
		InputStream is = new ByteArrayInputStream(b, 0, b.length);
		RequestEntity re = new InputStreamRequestEntity(is, b.length, contentType);
		postMethod.setRequestEntity(re);

		HttpClient httpClient = new HttpClient();
		int statusCode = 0;
		try {
			statusCode = httpClient.executeMethod(postMethod);
			resultmap.put("statusCode", statusCode);
		} catch (IOException e) {
			throw new RuntimeException("执行http请求失败", e);
		}
		if (statusCode == 200) {
			try {
				responseSoap = postMethod.getResponseBodyAsString();
				resultmap.put("responseSoap", responseSoap);
			} catch (IOException e) {
				throw new RuntimeException("获取请求返回报文失败", e);
			}
		} else {
			logger.error("请求内容：", requestSoap);
			throw new RuntimeException("请求失败：" + statusCode);
		}
		return resultmap;
	}
	/***
	 * 保安员背景筛查保存到问题人员表
	 * @param person 人员信息
	 * @return
	 *//*
	@Deprecated
	public boolean queryPerosnInfoSC(SecurityPerson person) {
        //身份证号码
        String idNumber = person.getIdNumber();
        //姓名
        String name = person.getUser().getRealname();
        //问题人员
        ProblemPerson problemPerson  = new ProblemPerson();
        problemPerson.setCreateTime(new Date());
        //处理状态
        problemPerson.setDispose(Constants.DISPOSE_NO);
        //如果身份证号为空，显示返回
        if (person == null || person.getUser() == null) {
            logger.error("异常身份证号：" + idNumber);
            return false;
        }
        User user = userDao.findById(person.getUser().getId());
        SecurityCompanyPerson securityCompanyPerson = securityCompanyPersonDao.findByPersonId(person.getId());
        problemPerson.setUpdateTime(new Date());
        problemPerson.setActive(true);
        problemPerson.setUpdateBy("systemAuto");
        problemPerson.setIdnumber(idNumber);
        //就职状态
        problemPerson.setIncumbencyStatus(person.getIncumbencyStatus());
        //获取公司信息
        if (securityCompanyPerson != null) {
            if (securityCompanyPerson.getCompany() != null) {
                //公司名称
                problemPerson.setCompanyid(securityCompanyPerson.getCompany().getId());
                //公司主键
                problemPerson.setCompanyname(securityCompanyPerson.getCompany().getName());
                //监控机构ID
                if (StringUtil.isNotEmpty(securityCompanyPerson.getCompany().getOrgId())) {
                    problemPerson.setOrgId(Long.valueOf(securityCompanyPerson.getCompany().getOrgId()));
                }
                //监控机构名称
                problemPerson.setOrgName(securityCompanyPerson.getCompany().getOrgName());
                //所属区域
                problemPerson.setAreaCode(securityCompanyPerson.getCompany().getAreaCode());
            }
        }
        //用户信息
        if (user != null) {
            //手机
            problemPerson.setPhone(user.getPhone());
            //姓名
            problemPerson.setName(user.getRealname());
        }
        //性别
        problemPerson.setSex(person.getGender());
        //人员
        problemPerson.setPersonid(person.getId());


        //背景筛查标记
        boolean result = true;
        BackgroundApprovalDto dto = new BackgroundApprovalDto();
        //身份证号
        dto.setIdNumber(idNumber);
        //姓名
        dto.setRealName(name);
        //主键
        dto.setBusinessid(person.getId());
        //问题人员
        dto.setBusinesstype(Constants.BAY_FZR);
        //背景筛查
        List<BackgroundApproval> backgroundApprovals = censor(dto);
        //循环背景筛查记录，检查是否有不通过
        for (BackgroundApproval backgroundApproval : backgroundApprovals) {
            if (!problemPersonSetStatus(problemPerson, backgroundApproval)) {
                result = false;
            }
        }
        problemPerson.setUpdateflag(true);
        if (!result && problemPerson.getProblemtype()!=null && !"".equals(problemPerson.getProblemtype())) {
            //只有背景筛查不通过再生成记录
            problemPersonDao.save(problemPerson);
        }
		//保存审查报告，如果有记录的话，删除以前记录信息
		backgroundApprovalDao.delete(dto);
		//批量保存
		backgroundApprovalDao.batchSave(backgroundApprovals);
		return result;
	}*/
	/**
	 * 根据背景筛查结果判断问题人员状态
	 * @param problemPerson
	 * @param backgroundApproval
	 * @return
	 *//*
	private boolean problemPersonSetStatus(ProblemPerson problemPerson,BackgroundApproval backgroundApproval){
		boolean result = true;
		if(ApprovalState.SHBTG.equals(backgroundApproval.getApprovalstate())){
			result = false;
		}
		StringBuffer problemtype = null;
		if(StringUtil.isNotEmpty(problemPerson.getProblemtype())){
			problemtype =  new StringBuffer(problemPerson.getProblemtype());
		}else{
			problemtype = new StringBuffer();
		}
		//问题类型描述
		StringBuffer problemTypeFail = new StringBuffer();
		switch (backgroundApproval.getLibraryType()){
			case Constants.LIBRARYTYPE_CZ:
				problemPerson.setCz(result);
				problemTypeFail.append(Constants.LIBRARYTYPE_CZ_FAIL);
				break;
			case Constants.LIBRARYTYPE_XD:
				problemPerson.setXd(result);
				problemTypeFail.append(Constants.LIBRARYTYPE_XD_FAIL);
				break;
			case Constants.LIBRARYTYPE_DT:
				problemPerson.setZt(result);
				problemTypeFail.append(Constants.LIBRARYTYPE_DT_FAIL);
				break;
			case Constants.LIBRARYTYPE_WF:
				problemPerson.setWf(result);
				problemTypeFail.append(Constants.LIBRARYTYPE_WF_FAIL);
				break;
			default:
				break;
		}
		if(!result) {
			if (StringUtil.isEmpty(problemtype.toString())) {
				problemtype.append(problemTypeFail.toString());
			} else {
				problemtype.append(Constants.COMMA).append(problemTypeFail.toString());
			}
			problemPerson.setProblemtype(problemtype.toString());
		}
		return result;
	}*/
	/**
	 * 根据业务id，业务类型 获取姓名
	 * @param businessid
	 * @param businesstype
	 * @return
	 */
	public String getName(Long businessid,String businesstype) {
		String name="";
		switch (businesstype) {
			case Constants.BAFW_FR:/*保安服务公司许可证法人*/
				Sponsorlicense sponsorlicense = sponsorlicenseDao.findById(businessid);
				if(sponsorlicense != null) {
					name = sponsorlicense.getRepresentative();
				}
				break;
			case Constants.BAFW_GD:
				Shareholder shareholder = shareholderDao.findById(businessid);
				if(shareholder != null) {
					name = shareholder.getName();
				}
				break;
			case Constants.PXDW_JBFR:
				Traincompanyapply traincompany = traincompanyapplyDao.findById(businessid);
				if(traincompany != null) {
					name = traincompany.getLegalname();
				}
				break;
			case Constants.BAFW_NPXDWGD:
				Traincompanyapply frTraincompany = traincompanyapplyDao.findById(businessid);
				if(frTraincompany != null) {
					name = frTraincompany.getTrainlegalname();
				}
				break;
			case Constants.BAYZ:
				Personcertificate personcertificate = personcertificateDao.findById(businessid);
				if(personcertificate != null) {
					name = personcertificate.getName();
				}
				break;
			case Constants.FGS_FR:
				Subsidiary subsidiary = subsidiaryDao.findById(businessid);
				if(subsidiary != null) {
					name = subsidiary.getLegalname();
				}
				break;
			case Constants.FGS_FZR:
				Subsidiary fzrSubsidiary = subsidiaryDao.findById(businessid);
				if(fzrSubsidiary != null) {
					name = fzrSubsidiary.getChargename();
				}
				break;
			case Constants.ZZ_FR:
				Confesscompany confesscompany = confesscompanyDao.findById(businessid);
				if(confesscompany != null) {
					name = confesscompany.getLegalname();
				}
				break;
			case Constants.ZZ_FZR:
				Confesscompany fzrConfesscompany = confesscompanyDao.findById(businessid);
				if(fzrConfesscompany != null) {
					name = fzrConfesscompany.getChargename();
				}
				break;
			case Constants.KQ_FR:
				Crosscompany crosscompany = crosscompanyDao.findById(businessid);
				if(crosscompany != null) {
					name = crosscompany.getLegalname();
				}
				break;
			case Constants.KQ_FZR:
				Crosscompany fzrCrosscompany = crosscompanyDao.findById(businessid);
				if(fzrCrosscompany != null) {
					name = fzrCrosscompany.getChargename();
				}
				break;
			case Constants.GRBG_YFR:
				Legalchange legalchange = legalchangeDao.findById(businessid);
				if(legalchange != null) {
					name = legalchange.getLegalname();
				}
				break;
			case Constants.GRBG_NFR:
				Legalchange ndLegalchange = legalchangeDao.findById(businessid);
				if(ndLegalchange != null) {
					name = ndLegalchange.getNdlegalname();
				}
				break;
			case Constants. PXDWGRBG_YFR:
				TrainChange trainChange = trainChangeDao.findById(businessid);
				if(trainChange != null) {
					name = trainChange.getLegalname();
				}
				break;
			case Constants. PXDWGRBG_NFR:
				TrainChange ndTrainChange = trainChangeDao.findById(businessid);
				if(ndTrainChange != null) {
					name = ndTrainChange.getNdlegalname();
				}
				break;
			case Constants.GRBG_FZR:

				break;
			case Constants.BAY_FZR:

				break;
			case Constants.QZPX_YFR:
				Armtrainorg armtrainorg = armtrainorgDao.findById(businessid);
				if(armtrainorg != null) {
					name = armtrainorg.getLegalname();
				}
				break;
			case Constants.QZPX_JGFZR:
				Armorgcharge armorgcharge = armorgchargeDao.findById(businessid);
				if(armorgcharge != null) {
					name = armorgcharge.getName();
				}
				break;
			case Constants.QZPX_PXFZR:
				Armtraincharge armtraincharge = armtrainchargeDao.findById(businessid);
				if(armtraincharge != null) {
					name = armtraincharge.getPxname();
				}
				break;
			case Constants.QZPX_JY:
				Armorgteach armorgteach = armorgteachDao.findById(businessid);
				if(armorgteach != null) {
					name = armorgteach.getJyname();
				}
				break;
			case Constants.QZPX_ZZCX:
				Confesscompanyundo confesscompanyundo = confesscompanyundoDao.findById(businessid);
				if(confesscompanyundo != null) {
					name = confesscompanyundo.getLegalname();
				}
				break;
            case Constants.GRADEPERSON_CENSORSTATUS:
                GradePerson gradePerson = gradePersonDao.findById(businessid);
                if(gradePerson != null) {
                    name = gradePerson.getName();
                }
                break;
            case Constants.PERSONGRADE_CENSORSTATUS:
				PersonGrade personGrade = personGradeDao.findById(businessid);
                if(personGrade != null) {
                    name = personGrade.getName();
                }
                break;
            case Constants.BAFW_ZJL:
				SbSponsorlicenseManager manager = sbSponsorlicenseManagerDao.findById(businessid);
                if(manager != null) {
                    name = manager.getName();
                }
                break;
			case Constants.BAFW_FZJL:
				SbSponsorlicenseVmanager vmanager = sbSponsorlicenseVmanagerDao.findById(businessid);
				if(vmanager != null) {
					name = vmanager.getVname();
				}
				break;
			case Constants.PERSONADAPT_CENSORSTATUS:
				PersonAdapt personAdapt = personAdaptDao.findById(businessid);
				if(personAdapt != null) {
					name = personAdapt.getName();
				}
				break;
			case Constants.BAPXDWBA_FR:
				Trainrecord trainrecord = trainrecordDao.findById(businessid);
				if(trainrecord != null) {
					name = trainrecord.getLegalName();
				}
				break;
			case Constants.BAPXDWBA_FZR:
				Trainrecord trainrecord1 = trainrecordDao.findById(businessid);
				if(trainrecord1 != null) {
					name = trainrecord1.getChargeName();
				}
				break;
			default:
				break;
		}
		return name.trim();
	}
	/**
	 * 根据业务id，业务类型 获取身份证
	 * @param businessid
	 * @param businesstype
	 * @return
	 */
	public String getIdNum(Long businessid,String businesstype) {
		String idnum="";
		switch (businesstype) {
			case Constants.BAFW_FR:/*保安服务公司许可证法人*/
				Sponsorlicense sponsorlicense = sponsorlicenseDao.findById(businessid);
				if(sponsorlicense != null) {
					idnum = sponsorlicense.getLegalPersonNo();
				}
				break;
			case Constants.BAFW_GD:
				Shareholder shareholder = shareholderDao.findById(businessid);
				if(shareholder != null) {
					idnum = shareholder.getIdnumber();
				}
				break;
			case Constants.PXDW_JBFR:
				Traincompanyapply traincompany = traincompanyapplyDao.findById(businessid);
				if(traincompany != null) {
					idnum = traincompany.getLegalcode();
				}
				break;
			case Constants.BAFW_NPXDWGD:
				Traincompanyapply frTraincompany = traincompanyapplyDao.findById(businessid);
				if(frTraincompany != null) {
					idnum = frTraincompany.getTraincreditcode();
				}
				break;
			case Constants.BAYZ:
				Personcertificate personcertificate = personcertificateDao.findById(businessid);
				if(personcertificate != null) {
					idnum = personcertificate.getCardnumber();
				}
				break;
			case Constants.FGS_FR:
				Subsidiary subsidiary = subsidiaryDao.findById(businessid);
				if(subsidiary != null) {
					idnum = subsidiary.getLegalcardnumber();
				}
				break;
			case Constants.FGS_FZR:
				Subsidiary fzrSubsidiary = subsidiaryDao.findById(businessid);
				if(fzrSubsidiary != null) {
					idnum = fzrSubsidiary.getChargecardnumber();
				}
				break;
			case Constants.ZZ_FR:
				Confesscompany confesscompany = confesscompanyDao.findById(businessid);
				if(confesscompany != null) {
					idnum = confesscompany.getLegalcardnumber();
				}
				break;
			case Constants.ZZ_FZR:
				Confesscompany fzrConfesscompany = confesscompanyDao.findById(businessid);
				if(fzrConfesscompany != null) {
					idnum = fzrConfesscompany.getChargecardnumber();
				}
				break;
			case Constants.KQ_FR:
				Crosscompany crosscompany = crosscompanyDao.findById(businessid);
				if(crosscompany != null) {
					idnum = crosscompany.getLegalcardnumber();
				}
				break;
			case Constants.KQ_FZR:
				Crosscompany fzrCrosscompany = crosscompanyDao.findById(businessid);
				if(fzrCrosscompany != null) {
					idnum = fzrCrosscompany.getChargecardnumber();
				}
				break;
			case Constants.GRBG_YFR:
				Legalchange legalchange = legalchangeDao.findById(businessid);
				if(legalchange != null) {
					idnum = legalchange.getLegalcardnumber();
				}
				break;
			case Constants.GRBG_NFR:
				Legalchange ndLegalchange = legalchangeDao.findById(businessid);
				if(ndLegalchange != null) {
					idnum = ndLegalchange.getNdlegalcardnum();
				}
				break;
			case Constants.GRBG_FZR:

				break;
			case Constants.BAY_FZR:

				break;
			case Constants.QZPX_YFR:
				Armtrainorg armtrainorg = armtrainorgDao.findById(businessid);
				if(armtrainorg != null) {
					idnum = armtrainorg.getLegalcardnumber();
				}
				break;
			case Constants.QZPX_JGFZR:
				Armorgcharge armorgcharge = armorgchargeDao.findById(businessid);
				if(armorgcharge != null) {
					idnum = armorgcharge.getIdnum();
				}
				break;
			case Constants.QZPX_PXFZR:
				Armtraincharge armtraincharge = armtrainchargeDao.findById(businessid);
				if(armtraincharge != null) {
					idnum = armtraincharge.getPxidnum();
				}
				break;
			case Constants.QZPX_JY:
				Armorgteach armorgteach = armorgteachDao.findById(businessid);
				if(armorgteach != null) {
					idnum = armorgteach.getJyidnum();
				}
				break;
			case Constants.QZPX_ZZCX:
				Confesscompanyundo confesscompanyundo = confesscompanyundoDao.findById(businessid);
				if(confesscompanyundo != null) {
					idnum = confesscompanyundo.getLegalcard();
				}
				break;
			case Constants.GRADEPERSON_CENSORSTATUS:
				GradePerson gradePerson = gradePersonDao.findById(businessid);
				if(gradePerson != null) {
					idnum = gradePerson.getIdnum();
				}
				break;
			case Constants.PERSONGRADE_CENSORSTATUS:
				PersonGrade personGrade = personGradeDao.findById(businessid);
				if(personGrade != null) {
					idnum = personGrade.getIdNum();
				}
				break;
			case Constants.BAFW_ZJL:
				SbSponsorlicenseManager manager = sbSponsorlicenseManagerDao.findById(businessid);
				if(manager != null) {
					idnum = manager.getIdnum();
				}
				break;
			case Constants.BAFW_FZJL:
				SbSponsorlicenseVmanager vmanager = sbSponsorlicenseVmanagerDao.findById(businessid);
				if(vmanager != null) {
					idnum = vmanager.getVidnum();
				}
				break;
			case Constants.PERSONADAPT_CENSORSTATUS:
				PersonAdapt personAdapt = personAdaptDao.findById(businessid);
				if(personAdapt != null) {
					idnum = personAdapt.getIdNum();
				}
				break;
			default:
				break;
		}
		return idnum.trim();
	}

	/****
	 * 查询背景筛查结果
	 * @param idNumber 身份证号
	 * @param name 姓名
	 *//*
	@Deprecated
	public String queryAndBGInfo(String idNumber,String name){
		BackgroundApprovalDto dto = new BackgroundApprovalDto();
		dto.setIdNumber(idNumber);
		dto.setRealName(name);
		List<BackgroundApproval> backgroundApprovals = censor(dto);
		StringBuffer problemtype = new StringBuffer(StringUtil.EMPTY);
		for (BackgroundApproval backgroundApproval : backgroundApprovals){
			String strResult = StringUtil.EMPTY;
			if(ApprovalState.SHBTG.equals(backgroundApproval.getApprovalstate())){
				switch (backgroundApproval.getLibraryType()){
					case Constants.LIBRARYTYPE_CZ:
						strResult = Constants.LIBRARYTYPE_CZ_FAIL;
						break;
					case Constants.LIBRARYTYPE_XD:
						strResult = Constants.LIBRARYTYPE_XD_FAIL;
						break;
					case Constants.LIBRARYTYPE_DT:
						strResult = Constants.LIBRARYTYPE_DT_FAIL;
						break;
					case Constants.LIBRARYTYPE_WF:
						strResult = Constants.LIBRARYTYPE_WF_FAIL;
						break;
					default:
						break;
				}
				if (StringUtil.isEmpty(problemtype.toString())) {
					problemtype.append(strResult);
				} else {
					problemtype.append(Constants.COMMA + strResult);
				}
			}
		}

		return problemtype.toString();
	}
	*//****
	 * 查询背景筛查结果
	 * @param businessid 业务ID
	 * @param businesstype 业务类型
	 * @param idNumber 身份证号
	 * @param name 姓名
	 *//*
	@Deprecated
	public void queryAndBGInfo(Long businessid,String businesstype,String idNumber,String name){
		//如果姓名没传，先查询
		if(StringUtil.isEmpty(name)) {
			name = getName(businessid, businesstype);
		}
		if(StringUtil.isEmpty(name)) {
			throw new ArsException("无法获取到姓名!");
		}
		BackgroundApprovalDto dto = new BackgroundApprovalDto();
		dto.setBusinessid(businessid);
		dto.setBusinesstype(businesstype);
		dto.setIdNumber(idNumber);
		dto.setRealName(name);
		//如果有记录的话，删除以前记录信息
		backgroundApprovalDao.delete(dto);
        List<BackgroundApproval> backgroundApprovals = censor(dto);
        //批量保存
        backgroundApprovalDao.batchSave(backgroundApprovals);
	}*/

  /*  *//****
     * 查询背景筛查结果
	 * 判断直接调人口库还是间接调西安接口
     * @param dto
     *//*
    @Deprecated
	private List<BackgroundApproval> censor(BackgroundApprovalDto dto){
		Config current_native_config = configService.getConfigByKey(Constants.CURRENT_NATIVE);
		if(current_native_config == null || StringUtil.isEmpty(current_native_config.getValue())){
			throw new ArsException("当前省份编码未配置！");
		}
		*//**
		 * 是否通过调陕西接口间接调人口库
		 * 如果没有配置，或者配置0 为直接调人口库
		 *//*
		Config remote_background_config = configService.getConfigByKey(Constants.NEED_REMOTE_BACKGROUND);
		//如果是陕西的，则调人口库
		if(remote_background_config != null && Constants.NEED_REMOTE_YES.equals(remote_background_config.getValue()) && !Constants.SHANGXI.equals(current_native_config.getValue())) {
			//如果不是陕西的，调用陕西的接口，由陕西去调人口库
			//获取陕西的背景筛查接口地址
			Config remoteConfig = configService.getConfigByKey(Constants.REMOTE_BACKGROUND_URL);
			if(remoteConfig != null && StringUtil.isNotEmpty(remoteConfig.getValue())) {
				//拼接参数
				StringBuffer url = new StringBuffer(remoteConfig.getValue());
				url.append("?businessid="+dto.getBusinessid());
				url.append("&businesstype="+dto.getBusinesstype());
				url.append("&idNumber="+dto.getIdNumber());
				url.append("&realName="+dto.getRealName());
				String resultStr = messageUtils.getJsonByInternet(url.toString());
				//获取结果
				AjaxResult result = JSONObject.parseObject(resultStr,AjaxResult.class);
				//成功且有值
				if(result.isSuccessful() && result.getData() != null) {
					//结果会有多条 批量保存到数据库
					return (List)result.getData();
				}
				return null;
			}
			return queryAndBGInfo(dto);
		}else{
			return queryAndBGInfo(dto);
		}
	}*/
   /* *//****
     * 查询背景筛查结果
	 * 直接调人口库
     * @param dto
     *//*
    @Deprecated
    public List<BackgroundApproval> queryAndBGInfo(BackgroundApprovalDto dto){
		Long businessid = dto.getBusinessid();
		String businesstype = dto.getBusinesstype();
		String idNumber = dto.getIdNumber();
		String name = dto.getRealName();
		List<BackgroundApproval> list = new ArrayList<>();
		BackgroundApproval cz_BackgroundApproval = new BackgroundApproval();
		cz_BackgroundApproval.setActive(true);
		cz_BackgroundApproval.setCreateTime(new Date());
		cz_BackgroundApproval.setUpdateTime(new Date());
		BackgroundApproval xd_BackgroundApproval = new BackgroundApproval();
		xd_BackgroundApproval.setActive(true);
		xd_BackgroundApproval.setCreateTime(new Date());
		xd_BackgroundApproval.setUpdateTime(new Date());
		BackgroundApproval dt_BackgroundApproval = new BackgroundApproval();
		dt_BackgroundApproval.setActive(true);
		dt_BackgroundApproval.setCreateTime(new Date());
		dt_BackgroundApproval.setUpdateTime(new Date());
		BackgroundApproval wf_BackgroundApproval = new BackgroundApproval();
		wf_BackgroundApproval.setActive(true);
		wf_BackgroundApproval.setCreateTime(new Date());
		wf_BackgroundApproval.setUpdateTime(new Date());
		//人口库
		try {
			cz_BackgroundApproval.setApprovaldate(new Date());
			cz_BackgroundApproval.setLibraryType(Constants.LIBRARYTYPE_CZ);
			cz_BackgroundApproval.setBusinessid(businessid);
			cz_BackgroundApproval.setBusinesstype(businesstype);
			boolean cz = send(idNumber,name, Constants.CZ_REQUESTID, Constants.CZ_SERVICEID);
			if(cz){
				cz_BackgroundApproval.setApprovalreason("主项信息符合");
				cz_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_TG);
				cz_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_TG);
			}else{
                cz_BackgroundApproval.setApprovalreason(Constants.LIBRARYTYPE_CZ_FAIL);
                cz_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_BTG);
                cz_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_BTG);
			}
		}catch(Exception e){
			cz_BackgroundApproval.setApprovalreason("查询公安部人口库超时，请过一会再尝试，如多次失败，请联系客服！");
			cz_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_CS);
			cz_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_DSP);
		}
		list.add(cz_BackgroundApproval);
		// 吸毒
		try {
			xd_BackgroundApproval.setApprovaldate(new Date());
			xd_BackgroundApproval.setLibraryType(Constants.LIBRARYTYPE_XD);
			xd_BackgroundApproval.setBusinessid(businessid);
			xd_BackgroundApproval.setBusinesstype(businesstype);
			boolean xd = send(idNumber, name,Constants.XD_REQUESTID, Constants.XD_SERVICEID);
			if(xd && ZAFLAG!=null && ZAFLAG.equals(Constants.ZAFLAG_YES)){
				xd_BackgroundApproval.setApprovalreason("吸毒人员");
				xd_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_BTG);
				xd_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_BTG);
			}else{

				xd_BackgroundApproval.setApprovalreason("无吸毒记录");
				xd_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_TG);
				xd_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_TG);
			}
		}catch(Exception e){
			xd_BackgroundApproval.setApprovalreason("网络通讯异常，比对不成功，请重新审批");
			xd_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_CS);
			xd_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_DSP);
		}
		list.add(xd_BackgroundApproval);
		// 在逃
		try {
			dt_BackgroundApproval.setApprovaldate(new Date());
			dt_BackgroundApproval.setLibraryType(Constants.LIBRARYTYPE_DT);
			dt_BackgroundApproval.setBusinessid(businessid);
			dt_BackgroundApproval.setBusinesstype(businesstype);
			boolean dt = send(idNumber, name,Constants.DT_REQUESTID, Constants.DT_SERVICEID);
			if(dt && ZAFLAG!=null && ZAFLAG.equals(Constants.ZAFLAG_YES)){
				dt_BackgroundApproval.setApprovalreason("在逃人员");
				dt_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_BTG);
				dt_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_BTG);
			}else{
				dt_BackgroundApproval.setApprovalreason("无在逃记录");

				dt_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_TG);
				dt_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_TG);
			}
		}catch(Exception e){
			dt_BackgroundApproval.setApprovalreason("网络通讯异常，比对不成功，请重新审批");
			dt_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_CS);
			dt_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_DSP);
		}
		list.add(dt_BackgroundApproval);
		// 犯罪
		try {
			wf_BackgroundApproval.setApprovaldate(new Date());
			wf_BackgroundApproval.setLibraryType(Constants.LIBRARYTYPE_WF);
			wf_BackgroundApproval.setBusinessid(businessid);
			wf_BackgroundApproval.setBusinesstype(businesstype);
			boolean wf = send(idNumber, name,Constants.WF_REQUESTID, Constants.WF_SERVICEID);
			if(wf && ZAFLAG!=null && ZAFLAG.equals(Constants.ZAFLAG_YES)){
				wf_BackgroundApproval.setApprovalreason("有违法犯罪记录");
				wf_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_BTG);
				wf_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_BTG);
			}else{
				wf_BackgroundApproval.setApprovalreason("无违法犯罪记录");
				wf_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_TG);
				wf_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_TG);
			}
		}catch(Exception e){
			wf_BackgroundApproval.setApprovalreason("网络通讯异常，比对不成功，请重新审批");
			wf_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_CS);
			wf_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_DSP);
		}
		list.add(wf_BackgroundApproval);
		return list;
    }*/
	/***
     * 请求四大库
     * @param idNumber 身份证号
     * @param requestID 请求ID
     * @param serviceID 服务ID
     *//*
    public boolean send(String idNumber,String name ,String requestID,String serviceID){
        if(ZAFLAG!=null && ZAFLAG.equals(Constants.ZAFLAG_YES)) {
            //执行返回的编码
            String code= "";
            //结果返回
            boolean result = false;
            //人口库调用会异常或超时，循环三次，三次还是异常或超时，则获取失败
            for(int i= 0;i< Constants.ZAFLAG_COUNT; i++) {
                RbspService service = new RbspService(requestID, serviceID);
                //用户信息
                service.setUserCardId("asdfasd");
                service.setUserDept("0100");
                service.setUserName("ptjian");
                RbspCall call = service.createCall();
                call.setUrl(ZAURL);
                call.setMethod(RbspConsts.METHOD_QUERY);
                Map<String, Object> params = new HashMap<String, Object>();
                params.put("DataObjectCode", "M001");
                params.put("InfoCodeMode", "1");
                //按身份证号查
                params.put("Condition", "SFZH = '" + idNumber.toUpperCase() + "'");
                //返回字段：身份证号、照片、姓名、性别、文化程度、民族、籍贯省县
                params.put("RequiredItems", new String[]{"XM"});
                String requestResult = call.invoke(params);
                //增加日志
                BjRestLog log = new BjRestLog();
                log.setResttype(serviceID);
                log.setResponseContext(requestResult);
                log.setRequestContext("身份证号：" + idNumber + "---姓名：" + name);
                //创建时间
                log.setCreateTime(new Date());
                //有效标记
                log.setActive(true);
                //更新时间
                log.setUpdateTime(new Date());
                //更新者
                log.setUpdateBy(Constants.APPROVAL_SYSTEM);
                bjRestLogDao.save(log);
                //如果不为空则没有数据
                if (requestResult != null && !requestResult.equals("")) {
                    try {
                        SAXReader reader = new SAXReader();
                        org.dom4j.Document doc = reader.read(new ByteArrayInputStream(requestResult.getBytes("UTF-8")));
                        org.dom4j.Element root = doc.getRootElement();
                        Element valueElement = root.element("Method").element("Items").element("Item").element("Value");
                        //valueElement节点为空的话，请求人口库异常
                        if (valueElement != null) {
                            List<Element> list = valueElement.elements();
                            //获取执行返回编码
                            if(list!=null &&  list.size()>0){
                                Element e = list.get(0);
                                code = e.element("Data").getText();
                            }
                            //获取查询结果
                            if (list != null && list.size() > 2) {
                                Element e = list.get(2);
                                String resultname = e.element("Data").getText();
                                if (resultname != null && resultname.equals(name)) {
                                    result =  true;
                                } else {
                                    result =  false;
                                }
                            }
                        }
                    } catch (Exception e) {
                        logger.error("身份证号：" + idNumber + "---姓名：" + name);
                        logger.error("人口库获取异常：" + result);
                        logger.error(e.getMessage(), e);
                    }
                }
                //如果执行成功则返回
                if(Constants.ZAFLAG_CODE_SUCCESS.equals(code)){
                    break;
                }
            }
            return result;
        }else{
            return true;
        }
    }*/
	/***
	 * 调人口库获取人口库信息
	 * 判断直接调人口库还是间接调西安接口
	 * @param idNumber 身份证号
	 * @param infoType 获取信息类型 XM 姓名  ZZXZ 详细地址信息 JGSSX 省市区  XP照片
	 */
/*	@Deprecated
	public String getInfo(String idNumber,String infoType) {
		Config current_native_config = configService.getConfigByKey(Constants.CURRENT_NATIVE);
		if(current_native_config == null || StringUtil.isEmpty(current_native_config.getValue())){
			throw new ArsException("当前省份编码未配置！");
		}
		*//**
		 * 是否通过调陕西接口间接调人口库
		 * 如果没有配置，或者配置0 为直接调人口库
		 *//*
		Config remote_background_config = configService.getConfigByKey(Constants.NEED_REMOTE_BACKGROUND);
		//如果是陕西的，则调人口库
		if(remote_background_config != null && Constants.NEED_REMOTE_YES.equals(remote_background_config.getValue()) && !Constants.SHANGXI.equals(current_native_config.getValue())) {
			//如果不是陕西的，调用陕西的接口，由陕西去调人口库
			//获取陕西的背景筛查接口地址
			Config remoteConfig = configService.getConfigByKey(Constants.REMOTE_BACKGROUND_URL);
			if(remoteConfig != null && StringUtil.isNotEmpty(remoteConfig.getValue())) {
				//拼接参数
				StringBuffer url = new StringBuffer(remoteConfig.getValue());
				url.append("?idNumber=" + idNumber);
				url.append("&infoType=" + infoType);
				String resultStr = messageUtils.getJsonByInternet(url.toString());
				//获取结果
				AjaxResult result = JSONObject.parseObject(resultStr,AjaxResult.class);
				//成功且有值
				if(result.isSuccessful() && result.getData() != null) {
					//结果会有多条 批量保存到数据库
					return result.getData().toString();
				}
				return null;
			}
			return getInfoFromPopulationBase(idNumber,infoType);
		}else{
			return getInfoFromPopulationBase(idNumber,infoType);
		}
	}*/
/*	*//***
	 * 调人口库获取人口库信息
	 * @param idNumber 身份证号
	 * @param infoType 获取信息类型 XM 姓名  ZZXZ 详细地址信息 JGSSX 省市区  XP照片
	 *//*
	@Deprecated*/
	/*public String getInfoFromPopulationBase(String idNumber,String infoType) {
		String strResult = "";
        String code  ="";
		if (ZAFLAG != null && ZAFLAG.equals(Constants.ZAFLAG_YES)) {
            //人口库调用会异常或超时，循环三次，三次还是异常或超时，则获取失败
            for(int i= 0;i< 3; i++) {
                RbspService service = new RbspService(Constants.XD_REQUESTID, Constants.XD_SERVICEID);
                //用户信息
                service.setUserCardId("asdfasd");
                service.setUserDept("0100");
                service.setUserName("ptjian");
                RbspCall call = service.createCall();
                call.setUrl(ZAURL);
                call.setMethod(RbspConsts.METHOD_QUERY);
                Map<String, Object> params = new HashMap<String, Object>();
                params.put("DataObjectCode", "M001");
                params.put("InfoCodeMode", "1");
                //按身份证号查
                params.put("Condition", "SFZH = '" + idNumber.toUpperCase() + "'");
                //返回字段：照片
                params.put("RequiredItems", new String[]{infoType});
                String result = call.invoke(params);
                //如果不为空则没有数据
                if (result != null && !result.equals("")) {
                    try {
                        SAXReader reader = new SAXReader();
                        org.dom4j.Document doc = reader.read(new ByteArrayInputStream(result.getBytes(Constants.CHARSETUTF8)));
                        org.dom4j.Element root = doc.getRootElement();
                        Element valueElement = root.element("Method").element("Items").element("Item").element("Value");
                        if (valueElement != null) {
                            List<Element> list = valueElement.elements();
                            //获取执行返回编码
                            if (list != null && list.size() > 0) {
                                Element e = list.get(0);
                                code = e.element("Data").getText();
                            }
                            if (list != null && list.size() > 2) {
                                Element e = list.get(2);
                                strResult = e.element("Data").getText();
                            }
                        }
                    } catch (Exception e) {
                        logger.error("身份证号：" + idNumber);
                        logger.error("人口库获取异常：" + result);
                        logger.error(e.getMessage(), e);
                    }
                }
                //如果执行成功则返回
                if(Constants.ZAFLAG_CODE_SUCCESS.equals(code)){
                    break;
                }
            }
		}
		return strResult;
	}*/
	/**
	 * 陕西单点登录
	 * @param username
	 * @param pwd
	 * @return
	 */
	public Result verifySXNW(String username, String pwd) {
		Result result = new Result();
		//拼接报文
		StringBuffer requestSoap = new StringBuffer();
		// 头部
		requestSoap.append("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:web=\"http://webservice.ahsga.linewell.com\">\n" +
				"   <soapenv:Header/>\n" +
				"   <soapenv:Body>\n" +
				"      <web:getUserinfo>\n");

		//添加code
		requestSoap.append("<web:in0>");
		requestSoap.append(SXNWCode);
		requestSoap.append("</web:in0>\n");

		//添加用户名
		requestSoap.append("<web:in1>\n");
		requestSoap.append(username);
		requestSoap.append("</web:in1>\n");

		//添加密码
		requestSoap.append("<web:in2>\n");
		requestSoap.append(pwd);
		requestSoap.append("</web:in2>\n");

		//添加尾部
		requestSoap.append("</web:getUserinfo>\n" +
				"   </soapenv:Body>\n" +
				"</soapenv:Envelope>");


		String charSet = "utf-8";
		String contentType = "text/xml; charset=utf-8";
		ClientUtil clientUtil = new ClientUtil();
		SAXReader reader = new SAXReader();

		//webservies请求
		try {
			Map<String, Object> responseSoapMap = responseSoap(requestSoap.toString(), SXNWAddress, charSet, contentType);
			int statusCode = (int) responseSoapMap.get("statusCode");
			String responseSoapxml = (String) responseSoapMap.get("responseSoap");
			//日志记录
			Sxlwlog sxlwlog = new Sxlwlog();
			sxlwlog.setCreateTime(new Date());
			sxlwlog.setUpdateTime(new Date());
			sxlwlog.setCode(SXNWCode);
			sxlwlog.setUserName(username);
			sxlwlog.setPwd(pwd);
			sxlwlog.setActive(true);
			sxlwlog.setRequestContext(requestSoap.toString());
			sxlwlog.setResponseContext(responseSoapxml);
			sxlwlog.setStatusCode(String.valueOf(statusCode));
			sxlwlogDao.save(sxlwlog);
			// 如果是200则调用成功，并且返回相应的信息
			if (StringUtil.equals(String.valueOf(statusCode),Constants.MINISTRY_CODE_SUCCES_SXNW)) {
				System.out.println(responseSoapxml);
				org.dom4j.Document doc = reader.read(new ByteArrayInputStream(responseSoapxml.getBytes("UTF-8")));
				Element root = doc.getRootElement().element("Body").element("getUserinfoResponse").element("out");
				if (root != null ) {
					result.setDATE(root.getText());
					result.setCODE(Constants.MINISTRY_CODE_SUCCES_SXNW);
				}
			} else {
				result.setCODE(statusCode + "");
				result.setMSG("调用接口接口出错");
				result.setERRORMSG("调用陕西南威公司登录验证出错");

			}
		} catch (Exception e) {
			result.setCODE(Constants.MINISTRY_CODE_ERROR);
			result.setMSG(e.getMessage());
			result.setERRORMSG(e.getMessage());
			logger.error(e.getMessage(),e);
		}

		return result;
	}
	/***
	 * 根据身份证从人口库获取指纹信息(广西)
	 * @param personcertificate 保安资格证报名信息
	 * @return 指纹信息
	 */
	public String queryZWForIdNumber(Personcertificate personcertificate) {
		//增加日志
		BjRestLog log =new BjRestLog();
		String result = "";
		String xml ="";
		//拼接报文
		StringBuffer requestSoap = new StringBuffer();
		// 头部
		requestSoap.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
		//添加code
		requestSoap.append("<Package>");
			requestSoap.append("<PackageHead>");
				requestSoap.append("<BBH>2.0</BBH>");//暂定为2.00
				requestSoap.append("<SJBBH>450000000000201905300001</SJBBH>");//查看已发布服务的说明
				requestSoap.append("<SJBLX>ba_zw_hc</SJBLX>");//查看已发布服务的说明
				requestSoap.append("<DWDM>"+personcertificate.getPoliceCode()+"</DWDM>");//发送单位的代码
				requestSoap.append("<DWMC>"+personcertificate.getPoliceName()+"</DWMC>");//发送单位的名称
				requestSoap.append("<JLS>1</JLS>");//由不超过5位数字字符组成
				requestSoap.append("<FSSJ>"+DateUtil.getCurrentDate(DateUtil.FORMAT8)+"</FSSJ>");//年月日时分秒
			requestSoap.append("</PackageHead>");

			requestSoap.append("<Data>");
				requestSoap.append("<Record>");
				 	requestSoap.append("<gmsfhm>"+personcertificate.getCardnumber().toUpperCase()+"</gmsfhm>");//身份证号
				requestSoap.append("</Record>");
			requestSoap.append("</Data>");
		//添加尾部
		requestSoap.append("</Package>");
		try {
			// 直接引用远程的wsdl文件
			org.apache.axis.client.Service service = new org.apache.axis.client.Service();
			Call call = (Call) service.createCall();
			//地址
			call.setTargetEndpointAddress(GXZWAddress);
			call.setOperationName("sjpsfw");// WSDL里面描述的接口名称
			call.addParameter("dbSource",
					org.apache.axis.encoding.XMLType.XSD_DATE,
					javax.xml.rpc.ParameterMode.IN);// 接口的参数，dbSource：数据源，接口内部标识，现暂定为tchdb，
			String tchdb = "tchdb";
			call.addParameter("psxml",
					org.apache.axis.encoding.XMLType.XSD_DATE,
					javax.xml.rpc.ParameterMode.IN);// 接口的参数,psxml：交换数据内容
			call.setReturnType(org.apache.axis.encoding.XMLType.XSD_STRING);// 设置返回类型
			xml  = (String) call.invoke(new Object[] { tchdb,requestSoap.toString()});
			// 给方法传递参数，并且调用方法
			SAXReader reader = new SAXReader();
			org.dom4j.Document doc = reader.read(new ByteArrayInputStream(xml.getBytes("UTF-8")));
			org.dom4j.Element root = doc.getRootElement();
			if(root.element("Data")!=null) {
				if( root.element("Data").element("Record")!=null) {
					List<Element> list = root.element("Data").element("Record").elements();
					if (list != null && list.size() >= 3 ) {
						Element ezw = list.get(2);
						String iszw = ezw.getText();
						if(Constants.FINGER_YES.equals(iszw)){
							Element e = list.get(0);
							result = e.getText();
							log.setCode("200");
						}
					}
				}
			}
		} catch (Exception e) {
			logger.error(e.getMessage(),e);
			logger.error("人口库获取异常"+personcertificate.getCardnumber());
			log.setResponseContext(e.getMessage());
		}
		log.setRequestContext(requestSoap.toString());
		if(StringUtil.isNotEmpty(xml)) {
			log.setResponseContext(xml);
		}
		log.setMsg("广西人口库指纹身份证号："+personcertificate.getCardnumber());
		//创建时间
		log.setCreateTime(new Date());
		//有效标记
		log.setActive(true);
		//更新时间
		log.setUpdateTime(new Date());
		//更新者
		log.setUpdateBy(Constants.APPROVAL_SYSTEM);
		bjRestLogDao.save(log);
		return result;
	}
}
