package com.bcxin.ars.util.approval;

import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;

/**
 * Created by SUBH on 2017/4/30.
 */
public class BusinessType {
    /**
     * 保安服务公司许可证
     */
    public static final String BAFWGS = "001";
    /***
     * 培训单位
     */
    public static final String PXDW = "002";
    /***
     * 保安公司子公司
     */
    public static final String BAGSZGS = "003";
    /***
     * 保安员证
     */
    public static final String BAYZ = "004";
    /***
     *跨区域经营保安公司
     */
    public static final String KQYBAGS = "005";
    /***
     * 自行招用保安员单位
     */
    public static final String ZXZY = "006";
    /***
     * 法人变更
     */
    public static final String FRBG = "007";
    /***
     * 年度报告
     */
    public static final String NDBG = "008";

    /***
     * 从事武装守护押运服务的保安员的枪支培训机构备案
     */
    public static final String QZPX = "009";

    /***
     * 自行招用保安员单位撤销备案
     */
    public static final String ZZBACX = "010";

    /***
     * 等级证补贴审批
     */
    public static final String DJZBT = "011";

    /***
     * 资格证补贴审批
     */
    public static final String ZGZBT = "012";

    /***
     * 培训单位项目变更
     */
    public static final String PXDWXMBG = "013";

    /***
     * 保安培训单位备案
     */
    public static final String BAPXDWBA = "014";

    /***
     * 保安员证核发
     */
    public static final String BAYZHF = "015";

    public static String getBusinessType(String tempCode) {
    	String result = "";
    	switch (tempCode) {
		case Constants.ACTIVITI_PROCESS_CONFESSCOMPANY:
			result = ZXZY;
			break;
		case Constants.ACTIVITI_PROCESS_SUBSIDIARY:
			result = BAGSZGS;
			break;
		case Constants.ACTIVITI_PROCESS_CROSSCOMPANY:
			result = KQYBAGS;
			break;
		case Constants.ACTIVITI_PROCESS_LEGALCHANGE:
			result = FRBG;
			break;
		case Constants.ACTIVITI_PROCESS_PERSONCERTIFICATE:
			result = BAYZ;
			break;
		case Constants.ACTIVITI_PROCESS_SPONSORLICENSE:
			result = BAFWGS;
			break;
		case Constants.ACTIVITI_PROCESS_TRAINCOMPANYAPPLY:
			result = PXDW;
			break;
		case Constants.ACTIVITI_PROCESS_YEARREPORT:
			result = NDBG;
			break;
		case Constants.ACTIVITI_PROCESS_YEARREPORT_ARMED:
			result = NDBG;
			break;
		case Constants.ACTIVITI_PROCESS_ARMTRAINORG:
			result = QZPX;
			break;
		case Constants.ACTIVITI_PROCESS_CONFESSCOMPANYUNDO:
			result = ZZBACX;
			break;
		case Constants.ACTIVITI_PROCESS_GRADESUBSIDY:
			result = DJZBT;
			break;
		case Constants.ACTIVITI_PROCESS_QUALIFICATIONSUBSIDY:
			result = ZGZBT;
			break;
		case Constants.ACTIVITI_PROCESS_TRAINCHANGE:
			result = PXDWXMBG;
			break;
		case Constants.ACTIVITI_PROCESS_PERCERGRANT:
			result = BAYZHF;
			break;

		default:
			break;
		}
    	
    	return result;
    }


	public static String getBusinessTypeName(String tempCode) {
		String result = "";
		switch (tempCode) {
			case ZXZY:
				result = Constants.ACTIVITI_PROCESS_CONFESSCOMPANY;
				break;
			case BAGSZGS:
				result = Constants.ACTIVITI_PROCESS_SUBSIDIARY;
				break;
			case KQYBAGS:
				result = Constants.ACTIVITI_PROCESS_CROSSCOMPANY;
				break;
			case FRBG:
				result = Constants.ACTIVITI_PROCESS_LEGALCHANGE;
				break;
			case BAYZ:
				result = Constants.ACTIVITI_PROCESS_PERSONCERTIFICATE;
				break;
			case BAFWGS:
				result = Constants.ACTIVITI_PROCESS_SPONSORLICENSE;
				break;
			case PXDW:
				result = Constants.ACTIVITI_PROCESS_TRAINCOMPANYAPPLY;
				break;
			case NDBG:
				result = Constants.ACTIVITI_PROCESS_YEARREPORT;
				break;
			case QZPX:
				result = Constants.ACTIVITI_PROCESS_ARMTRAINORG;
				break;
			case ZZBACX:
				result = Constants.ACTIVITI_PROCESS_CONFESSCOMPANYUNDO;
				break;
			case DJZBT:
				result = Constants.ACTIVITI_PROCESS_GRADESUBSIDY;
				break;
			case ZGZBT:
				result = Constants.ACTIVITI_PROCESS_QUALIFICATIONSUBSIDY;
				break;
			case PXDWXMBG:
				result = Constants.ACTIVITI_PROCESS_TRAINCHANGE;
				break;
			case BAPXDWBA:
				result = Constants.ACTIVITI_PROCESS_TRAINCOMPANYAPPLY;
				break;
			case BAYZHF:
				result = Constants.ACTIVITI_PROCESS_PERCERGRANT;
				break;
			default:
				break;
		}

		return result;
	}
	/***
	 * 根据业务类型和申报保安公司类型获取流程Key
	 * Created by subh 2019-02-27
	 * @param businessType 业务类型编码
	 * @param sponsorlicenseType 保安公司类型 01-保安公司，02-武装押运，03-合资
	 * @return 返回业务流程Key
	 */
	public static String getBusinessTypeName(String businessType,String sponsorlicenseType) {
		//返回业务流程Key 变量
		String result = "";
		//判断保安公司类型是否为空，如果为空，则不是保安公司申报业务，获取根据业务类型编码获取业务流程Key
		if(StringUtil.isEmpty(sponsorlicenseType)){
			//根据业务类型编码获取业务流程Key
			result= getBusinessTypeName(businessType);
		}else{
			if(NDBG.equals(businessType)){
				//判断申报保安公司类型，并返回业务流程Key
				switch (sponsorlicenseType) {
					//武装守护押运保安服务公司
					case Constants.SPONSORLICENSE_WZ:
						result = Constants.ACTIVITI_PROCESS_YEARREPORT_ARMED;
						break;
					default:
						result = Constants.ACTIVITI_PROCESS_YEARREPORT;
						break;
				}
			}else if(FRBG.equals(businessType)){
				//判断申报保安公司类型，并返回业务流程Key
				switch (sponsorlicenseType) {
					//保安服务公司
					case Constants.SPONSORLICENSE_FW:
						result = Constants.ACTIVITI_PROCESS_LEGALCHANGE;
						break;
					//武装守护押运保安服务公司
					case Constants.SPONSORLICENSE_WZ:
						result = Constants.ACTIVITI_PROCESS_LEGALCHANGEARM;
						break;
					//中外合资经营、中外合作经营或外资独资经营保安服务公司
					case Constants.SPONSORLICENSE_HZ:
						result = Constants.ACTIVITI_PROCESS_LEGALCHANGEJOINT;
						break;
					default:
						result = Constants.ACTIVITI_PROCESS_LEGALCHANGE;
						break;
				}
			}else{
				//判断申报保安公司类型，并返回业务流程Key
				switch (sponsorlicenseType) {
					//保安服务公司
					case Constants.SPONSORLICENSE_FW:
						result = Constants.ACTIVITI_PROCESS_SPONSORLICENSE;
						break;
					//武装守护押运保安服务公司
					case Constants.SPONSORLICENSE_WZ:
						result = Constants.ACTIVITI_PROCESS_SPONSORLICENSEARM;
						break;
					//中外合资经营、中外合作经营或外资独资经营保安服务公司
					case Constants.SPONSORLICENSE_HZ:
						result = Constants.ACTIVITI_PROCESS_SPONSORLICENSEJOINT;
						break;
					default:
						break;
				}
			}

		}
		return result;
	}
}
