package com.bcxin.ars.util;

import com.bcxin.ars.dto.pdf.PdfChangeDTO;
import com.itextpdf.text.*;
import com.itextpdf.text.pdf.*;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/****
 * PDF生成工具类
 *
 */
public class PDFUtils {
    //日志
    final static Logger logger = LoggerFactory.getLogger(PDFUtils.class);
    /***
     * 生成PDF文件
     * @param templatePath 模块路径
     * @param pdfPath 生成pdf文件路径
     * @param obj 表单赋值对象
     */
    public static void createPDFForTemplate(String templatePath,String pdfPath,Object obj) throws IOException, DocumentException {
        PdfReader reader = null;
        FileOutputStream out = null;
        ByteArrayOutputStream bos= null;
        PdfStamper stamper = null;
        Document doc = null;
        try {
            //输出流
            out = new FileOutputStream(pdfPath);
            //读取pdf模板
            reader = new PdfReader(templatePath);
            bos = new ByteArrayOutputStream();
            stamper = new PdfStamper(reader, bos);
            //pdf表单相关信息展示
            AcroFields form = stamper.getAcroFields();
            Iterator<String> it = form.getFields().keySet().iterator();
            while (it.hasNext()) {
                //name就是pdf模版中各个文本域的名字
                String fieldName = it.next();
                //设置表单字段的值
                form.setField(fieldName, BeanUtils.getProperty(obj,fieldName));
            }
            // 如果为false那么生成的PDF文件还能编辑，一定要设为true
            stamper.setFormFlattening(true);
            stamper.close();
            //生成新的pdf文件
            doc = new Document();
            PdfCopy copy = new PdfCopy(doc, out);
            doc.open();
            PdfImportedPage importPage = copy.getImportedPage(new PdfReader(bos.toByteArray()), 1);
            copy.addPage(importPage);
        } catch (IOException e) {
            logger.error(e.getMessage(),e);
        } catch (DocumentException e) {
            logger.error(e.getMessage(),e);
        } catch (IllegalAccessException e) {
            logger.error(e.getMessage(),e);
        } catch (InvocationTargetException e) {
            logger.error(e.getMessage(),e);
        } catch (NoSuchMethodException e) {
            logger.error(e.getMessage(),e);
        } finally {
            //最后关闭相关的流
            if(stamper!=null){
                stamper.close();
            }
            if(doc!=null){
                doc.close();
            }
        }
    }

    public static void main(String[] args) throws IOException, DocumentException {
      //  String TemplatePDF = "d:/CompanyTrain-2-2.pdf"; //魔板路径
      String TemplatePDF = "d:/CompanyCertificate-2-6.pdf"; //魔板路径
       // CompanyTrain-2-2.pdfm,CompanyCertificate-2-6.pdf
        String outFile = "d:/test.pdf"; //生成新的pdf的路径
        List<PdfChangeDTO> pdfChangeDTOList=new ArrayList<>();
        // 插入文字
        for (int i=0;i<6;i++) {
            PdfChangeDTO pdfChangeDTO = new PdfChangeDTO();
            pdfChangeDTO.setProject("公司地址变更"+i);
            pdfChangeDTO.setAfterChange("西安市北二环西段西安农资大厦6层弄岗路"+i);
            pdfChangeDTO.setTime("2019-01-24");
            pdfChangeDTOList.add(pdfChangeDTO);
        }
        PDFUtils.addPDFChange(TemplatePDF, outFile, pdfChangeDTOList);
    }

    public static void addPDFChange(String templatePDF, String outFile,List<PdfChangeDTO> pdfChangeDTOList) throws IOException, DocumentException {
        PdfReader reader = new PdfReader(templatePDF);
        PdfStamper ps = new PdfStamper(reader, new FileOutputStream(outFile)); // 生成的输出流
        AcroFields s = ps.getAcroFields();

        insertText(ps,s,pdfChangeDTOList);
        ps.close();
        reader.close();
    }


    /**
     * 插入文本
     *
     * @return
     * @author WangMeng
     * @date 2016年6月16日
     */
    public static void insertText(PdfStamper ps, AcroFields s, List<PdfChangeDTO> pdfChangeDTOList)  throws IOException, DocumentException
    {
        //获取字段
        List<AcroFields.FieldPosition> list = s.getFieldPositions("change");
        Rectangle rect = list.get(0).position;
        PdfContentByte cb = ps.getOverContent(1);
        //生成四列表格
        PdfPTable table = new PdfPTable(4);
        //设置表格具体宽度
        table.setTotalWidth(270);
        //设置每一列所占的长度
        table.setWidths(new float[]{14f, 29f,16f, 20f});
        //解决中文在pdf不显示的问题
        BaseFont bfChinese = BaseFont.createFont( "STSongStd-Light" ,"UniGB-UCS2-H",BaseFont.NOT_EMBEDDED);
        Font font_10 = new Font(bfChinese, 10,Font.NORMAL);
        Font font_7 = new Font(bfChinese, 8,Font.NORMAL);
        Font font_12 = new Font(bfChinese, 12,Font.NORMAL);
        table.addCell(changeCellAlignment("项   目", font_12,true,true,28F));
        table.addCell(changeCellAlignment("变更后内容", font_12,true,true,28F));
        table.addCell(changeCellAlignment("变更时间", font_12,true,true,28F));
        table.addCell(changeCellAlignment("变更专用章", font_12,true,true,28F));
        //判断是否有变更内容 edit
        if(pdfChangeDTOList!=null) {
            for (PdfChangeDTO pdfChangeDTO : pdfChangeDTOList) {
                table.addCell(changeCellAlignment(pdfChangeDTO.getProject(), font_10, true, true,0.0F));
                table.addCell(changeCellAlignment(pdfChangeDTO.getAfterChange(), font_7, false, true,0.0F));
                table.addCell(changeCellAlignment(pdfChangeDTO.getTime(), font_10, true, true,0.0F));
                PdfPCell blankCell = new PdfPCell();
                blankCell.setMinimumHeight(28);
                table.addCell(blankCell);
            }
        }else{
            //如果为空设置一个空数组
            pdfChangeDTOList  =  new ArrayList<PdfChangeDTO>();
        }
        //内容
        int size=7-pdfChangeDTOList.size();
        for (int i=0;i<size;i++){
            PdfPCell blankCell = new PdfPCell();
            blankCell .setMinimumHeight(28);
            table.addCell(blankCell);
            table.addCell(new Paragraph("",font_10));
            table.addCell(new Paragraph("",font_10));
            table.addCell(new PdfPCell(new Phrase("")));
        }
        //写入
        table.writeSelectedRows(0, -1, rect.getLeft(), rect.getTop(), cb);
    }

    private static PdfPCell changeCellAlignment(String projectName, Font font,boolean horizontal,boolean vertical,float minimumHeight) {
        //表单
        Paragraph paragraph= new Paragraph(projectName,font);
        paragraph.setAlignment(Element.ALIGN_CENTER);
        PdfPCell cell1 = new PdfPCell();
        cell1.setUseAscender(true);
        if (horizontal) {
            cell1.setHorizontalAlignment(Element.ALIGN_CENTER); //水平居中
        }
        if (vertical) {
            cell1.setVerticalAlignment(Element.ALIGN_MIDDLE);//垂直居中
        }
        cell1.setPhrase(paragraph);
        cell1.setMinimumHeight(minimumHeight);
        return cell1;
    }


}
