package com.bcxin.ars.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.MSGConstants;
import com.bcxin.ars.dao.sys.InterfaceLogDao;
import com.bcxin.ars.dao.sys.MessageLogDao;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.sys.InterfaceLog;
import com.bcxin.ars.model.sys.MessageLog;
import com.bcxin.ars.util.sms.RequestUtil;
import com.xiaoleilu.hutool.http.HttpUtil;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.*;

public class MessageUtil {
	// 账户
	private static String msgAccount = "";
	// 密码
	private static String msgPassword = "";
	//短信调用地址
	private static String serviceURL = "";
	//1分钟最大条数
	private static int minmax =0;
	//1小时最大条数
	private static int hourmax =0;
	//1天最大条数
	private static int daymax =0;
	//短信开关 0关 1开
	private static String message_switch ="1";
    //短信环境标识
    private static String channel ="1";
	final static Logger logger = LoggerFactory.getLogger(MessageUtil.class);

	/***
	 * 内容列表
	 */
	public static final Map<String,String> contextList = new HashMap<>();
	static {
		ResourceBundle rb = ResourceBundle.getBundle("config");
		serviceURL = rb.getString("msg_service_url");
		msgAccount = rb.getString("msg_account");
		msgPassword = rb.getString("msg_pwd");
		minmax = Integer.parseInt(rb.getString("minmax"));
		hourmax =  Integer.parseInt(rb.getString("hourmax"));
		daymax =  Integer.parseInt(rb.getString("daymax"));
		message_switch = rb.getString("message_switch");
        channel = rb.getString("message_channel");

	}

	public static Integer sendMessageHaveCode(String to,MessageLogDao messageLogDao,Integer code) throws Exception {

		MessageLog log = new MessageLog();
		log.setPhone(to);
		log.setTimecount(1*60);
		List list = messageLogDao.findAll(log);
		if(list!=null && list.size()>=minmax){
			throw new ArsException("一分钟内不能重复发！！！");
		}
		log.setTimecount(1*60*60);
		List list2 = messageLogDao.findAll(log);
		if(list2!=null && list2.size()>=hourmax){
			throw new ArsException("一小时最多只能发送3条！！！");
		}
		log.setTimecount(1440*60);
		List list1 = messageLogDao.findAll(log);
		if(list1!=null && list1.size()>=daymax){
			throw new ArsException("一天最多只能发送10条！！！");
		}
		//保存短信记录
		log.setCreateTime(new Date());
		messageLogDao.save(log);


		HuaWeiSmsContent  huaWeiSmsContent = new HuaWeiSmsContent();
		//手机号码
		huaWeiSmsContent.setMobile(to);
		//平台
		huaWeiSmsContent.setPlatform(MSGConstants.PLATFORM_BCXIN);
		//模版
		huaWeiSmsContent.setSmsCode(MSGConstants.SMSCODE_P01);
		huaWeiSmsContent.setParams(JSON.toJSONString(new String[]{""+code}));
		InterfaceLog interfaceLog = MessageUtil.sendHuaWeiSMS(huaWeiSmsContent);
		/**
		 * 异步保存
		 */
		new Thread(()->{
			messageLogDao.insert(interfaceLog);
		}).start();
		return code;
	}
	/****
	 * 批量发送短信信息
	 * @param phones 手机列表
	 * @param context 内容
	 */
	public  static void sendMessage(List<String> phones,String context,MessageLogDao messageLogDao){
		//异步执行，记录发送短信情况
		new Thread(()-> {
			//循环遍历手机发送短信
			for (String phone:
					phones) {
				//发送短信
				sendMessage(phone,context,messageLogDao);

			}
		}).start();
	}
	/***
	 * 发送验证码
	 * @param to 手机
	 * @param messageLogDao 日志
	 * @return 返回调用情况编码
	 * @throws Exception
	 */
	public static Integer sendMessageCode(String to,MessageLogDao messageLogDao) throws Exception {

		MessageLog log = new MessageLog();
		log.setPhone(to);
		log.setTimecount(1*60);
		List list = messageLogDao.findAll(log);
		if(list!=null && list.size()>=minmax){
			throw new ArsException("一分钟内不能重复发！！！");
		}
		log.setTimecount(1*60*60);
		List list2 = messageLogDao.findAll(log);
		if(list2!=null && list2.size()>=hourmax){
			throw new ArsException("一小时最多只能发送3条！！！");
		}
		log.setTimecount(1440*60);
		List list1 = messageLogDao.findAll(log);
		if(list1!=null && list1.size()>=daymax){
			throw new ArsException("一天最多只能发送10条！！！");
		}
		//保存短信记录
		log.setCreateTime(new Date());
		messageLogDao.save(log);

		Random r = new Random();
		int code = r.nextInt(899999);
		code += 100000;

		HuaWeiSmsContent  huaWeiSmsContent = new HuaWeiSmsContent();
		//手机号码
		huaWeiSmsContent.setMobile(to);
		//平台
		huaWeiSmsContent.setPlatform(MSGConstants.PLATFORM_BCXIN);
		//模版
		huaWeiSmsContent.setSmsCode(MSGConstants.SMSCODE_P01);
		huaWeiSmsContent.setParams(JSON.toJSONString(new String[]{""+code}));
		InterfaceLog interfaceLog = MessageUtil.sendHuaWeiSMS(huaWeiSmsContent);
		/**
		 * 异步保存
		 */
		new Thread(()->{
			messageLogDao.insert(interfaceLog);
		}).start();
		return code;
	}


	public static void sendMessage(String to,String content,MessageLogDao messageLogDao){
		try {
			//记录发送日志
			MessageLog log = new MessageLog();
			log.setPhone(to);
			log.setCreateTime(new Date());
			log.setMsgcontext(content);
			messageLogDao.save(log);
			if("0".equals(message_switch)) {
				return;
			}
			if (StringUtils.isEmpty(content) || StringUtils.isEmpty(to)){
				return;
			}
			// 开始时间
			String requestId = System.currentTimeMillis()+"";
			JSONObject json = new JSONObject();


			json.put("type",msgAccount);
			//内容
			json.put("content",content);
			//手机号码
			json.put("mobile",to);
			json.put("requestId",requestId);
			//秘钥
			json.put("token", com.bcxin.ars.util.sms.MD5Util.string2MD5(requestId+msgAccount+msgPassword));
			String ret = RequestUtil.initHttp().doPost(serviceURL, json.toString(), "application/json", "UTF-8");
			JSONObject  retJson = JSONObject.parseObject(ret);
			if("200".equals(retJson.get("status"))){
				logger.info("短信发送成功，手机号：[{}]，短信内容：[{}]",to,content);
			} else {
				logger.info("短信发送失败，手机号：[{}]，短信内容：[{}]",to,content);
			}

		} catch (Exception e) {
			logger.error(e.getMessage(),e);
		}
	}
	
	public List<String[]> responseMessage() {
		try {
			StringBuffer url = new StringBuffer();
			url.append("?action=query");
			url.append("&userid=666");
			url.append("&account="+msgAccount);
			url.append("&password="+msgPassword);
			String result = getHtmlCodeByURL(url.toString());
			return disposeXML(result);
		} catch (Exception e) {
			logger.error(e.getMessage(),e);
		}
		return new ArrayList<String[]>();
	}
	
	private List<String[]> disposeXML(String result){
		List<String[]> responses = new ArrayList<String[]>();
		Document document;
		try {
			document = DocumentHelper.parseText(result);
			Element root = document.getRootElement();
			List<Element> elements = root.elements("callbox");;
			for (Element element : elements) {
				Element mobile = element.element("mobile");
				Element content = element.element("content");
				String[] str = new String[2];
				str[0] = mobile.getText();
				str[1] = content.getText();
				responses.add(str);
			}
		} catch (DocumentException e) {
			logger.error(e.getMessage(),e);
		}
		return responses;
	}
	
	public static String getHtmlCodeByURL(String str) throws java.io.IOException {
		URL url = new URL(str);
		HttpURLConnection urlConnection  = (HttpURLConnection)url.openConnection();
		InputStream in = urlConnection.getInputStream();
		byte[] data = new byte[in.available()];  
		in.read(data);
		return new String(data);
	}
	/***
	 * 发送短信华为云
	 * @param to 手机号码
	 * @param context 内容
	 * @param messageLogDao 记录日志
	 * @param parems 华为云参数
	 * @param smsCode 平台对应的短信编号
	 */
	public static void sendMessageHuaWei(String to,String context,MessageLogDao messageLogDao,String[] parems,String smsCode){
		try {
			//记录发送日志
			MessageLog log = new MessageLog();
			log.setPhone(to);
			log.setCreateTime(new Date());
			log.setMsgcontext(context);
			log.setPhone(to);
			log.setTimecount(1*60);
			List list = messageLogDao.findAll(log);
			if(list!=null && list.size()>=minmax){
				throw new ArsException("一分钟内不能重复发！！！");
			}
			log.setTimecount(1*60*60);
			List list2 = messageLogDao.findAll(log);
			if(list2!=null && list2.size()>=hourmax){
				throw new ArsException("一小时最多只能发送3条！！！");
			}
			log.setTimecount(1440*60);
			List list1 = messageLogDao.findAll(log);
			if(list1!=null && list1.size()>=daymax){
				throw new ArsException("一天最多只能发送10条！！！");
			}
			//保存短信记录
			log.setCreateTime(new Date());
			messageLogDao.save(log);


			if("0".equals(message_switch)) {
				return;
			}
			if (StringUtils.isEmpty(context) || StringUtils.isEmpty(to)){
				return;
			}
			HuaWeiSmsContent  huaWeiSmsContent = new HuaWeiSmsContent();
			//手机号码
			huaWeiSmsContent.setMobile(to);
			//平台
			huaWeiSmsContent.setPlatform(MSGConstants.PLATFORM_ARS);
			//模版
			huaWeiSmsContent.setSmsCode(smsCode);
			huaWeiSmsContent.setParams(JSON.toJSONString(parems));
			InterfaceLog interfaceLog = MessageUtil.sendHuaWeiSMS(huaWeiSmsContent);
			/**
			 * 异步保存
			 */
			new Thread(()->{
				messageLogDao.insert(interfaceLog);
			}).start();
		} catch (Exception e) {
			logger.error(e.getMessage(),e);
		}
	}
	/**
	 * 发送华为短信
	 * @param huaWeiSmsContent
	 * @return
	 */
	public static InterfaceLog sendHuaWeiSMS(HuaWeiSmsContent huaWeiSmsContent) {
		if("0".equals(message_switch)) {
			return null;
		}
		String url = "http://msg.bcxin.com.cn:9165/sms/huawei/sendSMS";
		Map<String,Object> params =  new HashMap<>();
		//环境标识
        huaWeiSmsContent.setChannel(channel);
		params.put("data", JSON.toJSONString(huaWeiSmsContent));
		params.put("token", MD5Util.string2MD5("BCXIN" + huaWeiSmsContent.getMobile() + DateUtil.getCurrentDate()));
		//增加调用短信日志
		InterfaceLog interfaceLog = new InterfaceLog();
		interfaceLog.setCreateTime(new Date());
		interfaceLog.setActive(true);
		interfaceLog.setUrl(url);
		interfaceLog.setParameters(JSONObject.toJSONString(params));
		interfaceLog.setResult(HttpUtil.post(url,params));
		return interfaceLog;
	}



}
