package com.bcxin.ars.util;

import java.util.Calendar;

/**
 * 
 * <b>Function </b>身份证帮助类
 * 
 * @author LinQingLin
 * @date 2017年2月16日 下午9:24:02
 * @注意事项 </b>
 * <b>
 */
public class IdNumUtil {
	
	 /** 中国公民身份证号码最小长度。 */
    public  final int CHINA_ID_MIN_LENGTH = 15;

    /** 中国公民身份证号码最大长度。 */
    public  final int CHINA_ID_MAX_LENGTH = 18;
    
    /**
     * 
     * <b>Function </b> 身份证获得nativeCode
     * 
     * @param idNum
     * @param type
     * @return
     * @author LinQingLin 
     * @date 2017年2月21日 下午4:58:37
     * @注意事项 </b>
     * <b>
     */
	public static String getNativeCodeByIdNum(String idNum,int type){
		String nativeCode = idNum.substring(0, type);//type 分 2（省）、4（市）、6（区）
		return deDuplication(nativeCode);
	}
	
	private static String deDuplication(String nativeCode){
		if(nativeCode.substring(nativeCode.length()-2,nativeCode.length()).equals("00")){
			nativeCode = deDuplication(nativeCode.substring(0,nativeCode.length()-2));
		}
		return nativeCode;
	}
	
	/**
     * 根据身份编号获取年龄
     *
     * @param idCard
     *            身份编号
     * @return 年龄
     */
    public static int getAgeByIdCard(String idCard) {
        int iAge = 0;
        Calendar cal = Calendar.getInstance();
        String year = idCard.substring(6, 10);
        int iCurrYear = cal.get(Calendar.YEAR);
        iAge = iCurrYear - Integer.valueOf(year);
        return iAge;
    }

    /**
     * 根据身份编号获取生日
     *
     * @param idCard 身份编号
     * @return 生日(yyyyMMdd)
     */
    public static String getBirthByIdCard(String idCard) {
        return idCard.substring(6, 14);
    }

    /**
     * 根据身份编号获取生日
     *
     * @param idCard 身份编号
     * @return 生日(yyyy-MM-dd)
     */
    public static String getBirthdayByIdCard(String idCard) {
        if(StringUtil.isEmpty(idCard)){
            return "";
        }
        String idCardNumber = idCard.trim(); 
        int idCardLength = idCardNumber.length(); 
        String birthday = null; 
        if (idCardNumber == null || "".equals(idCardNumber)) { 
            return null; 
        } 
        if (idCardLength == 18) { 
            birthday = idCardNumber.substring(6, 10) + "-" 
                    + idCardNumber.substring(10, 12) + "-" 
                    + idCardNumber.substring(12, 14); 
        } 
        if (idCardLength == 15) { 
            birthday = "19" + idCardNumber.substring(6, 8)+ "-" 
                    + idCardNumber.substring(8, 10) + "-" 
                    + idCardNumber.substring(10, 12); 
        } 
        return birthday; 
    } 
    /**
     * 根据身份编号获取生日年
     *
     * @param idCard 身份编号
     * @return 生日(yyyy)
     */
    public static Short getYearByIdCard(String idCard) {
        return Short.valueOf(idCard.substring(6, 10));
    }

    /**
     * 根据身份编号获取生日月
     *
     * @param idCard
     *            身份编号
     * @return 生日(MM)
     */
    public static Short getMonthByIdCard(String idCard) {
        return Short.valueOf(idCard.substring(10, 12));
    }

    /**
     * 根据身份编号获取生日天
     *
     * @param idCard
     *            身份编号
     * @return 生日(dd)
     */
    public static Short getDateByIdCard(String idCard) {
        return Short.valueOf(idCard.substring(12, 14));
    }

    /**
     * 根据身份编号获取性别
     *
     * @param idCard 身份编号
     * @return 性别(M-男，F-女，N-未知)
     */
    public static String getGenderByIdCard(String idCard) {
        String sGender = "未知";

        String idCardNumber = idCard.trim();
        int idCardLength = idCardNumber.length();

        if (idCardLength == 18) {
            String sCardNum = idCard.substring(16, 17);
            if (Integer.parseInt(sCardNum) % 2 != 0) {
                sGender = "男";//男
            } else {
                sGender = "女";//女
            }
        }
        if (idCardLength == 15) {
            String sCardNum = idCard.substring(14, 15);
            if (Integer.parseInt(sCardNum) % 2 != 0) {
                sGender = "男";//男
            } else {
                sGender = "女";//女
            }
        }



        return sGender;
    }

    /**
     * 根据身份编号获取性别
     *
     * @param idCard 身份编号
     * @return 性别(1-男，2-女，N-未知)
     */
    public static String getSexByIdCard(String idCard) {
        String sex = "N";


        String idCardNumber = idCard.trim();
        int idCardLength = idCardNumber.length();

        if (idCardLength == 18) {
            String sCardNum = idCardNumber.substring(16, 17);
            if (Integer.parseInt(sCardNum) % 2 != 0) {
                sex = "1";//男
            } else {
                sex = "2";//女
            }
        }
        if (idCardLength == 15) {
            String sCardNum = idCardNumber.substring(14, 15);
            if (Integer.parseInt(sCardNum) % 2 != 0) {
                sex = "1";//男
            } else {
                sex = "2";//女
            }
        }

        return sex;
    }

    public static boolean isRealName(String realName){
        return realName.matches("^[a-z.A-Z\u4e00-\u9fa5]+$");
    }

    public static void main(String[] args) {
        System.out.println(IdNumUtil.isRealName("区.大"));
    }

}
