package com.bcxin.ars.util;

import com.bcxin.ars.dao.PersonImgDao;
import com.bcxin.ars.model.PersonImg;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

import java.io.*;
import java.util.Date;

@Service
public class GetPersonImgUtil {

    @Autowired
    PersonImgDao personImgDao;


    public String getPersonImg(String idNumber) {

        String pictureBase64 = "";
        try {
            PersonImg personImg = personImgDao.getPersonImage(idNumber);
            if(personImg!=null) {
                pictureBase64=getImageString(personImg.getIdImage());
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return pictureBase64;
    }

    /**
     * Base64字符串转 二进制流
     *
     * @param base64String Base64
     * @return base64String
     * @throws IOException 异常
     */
    public static byte[] getStringImage(String base64String) throws IOException {
        BASE64Decoder decoder = new sun.misc.BASE64Decoder();
        return base64String != null ? decoder.decodeBuffer(base64String) : null;
    }
    //图片转化成base64字符串
    public static String GetImageStr(String imgFile){
        //将图片文件转化为字节数组字符串，并对其进行Base64编码处理
        InputStream in = null;
        byte[] data = null;
        //读取图片字节数组
        try
        {
            in = new FileInputStream(imgFile);
            data = new byte[in.available()];
            in.read(data);
            in.close();
        }
        catch (IOException e)
        {
            e.printStackTrace();
        }
        //对字节数组Base64编码
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encode(data);//返回Base64编码过的字节数组字符串
    }

    public static  void main(String[] arg){

        System.out.println(GetImageStr("/media/subinghui/data/ars/personImg/2019-09-25/1569390600789.jpg"));


    }

    //base64字符串转化成图片
    public static boolean GenerateImage(String imgStr,String idNumber){
        //imgStr =    GetImageStr("d://1.png");
        //对字节数组字符串进行Base64解码并生成图片
        if (imgStr == null) //图像数据为空
            return false;
        BASE64Decoder decoder = new BASE64Decoder();
        try
        {
            //Base64解码
            byte[] b = decoder.decodeBuffer(imgStr);
            for(int i=0;i<b.length;++i)
            {
                if(b[i]<0)
                {//调整异常数据
                    b[i]+=256;
                }
            }
            //生成jpeg图片
            String imgFilePath = "d:/"+idNumber+".jpg";//新生成的图片
            OutputStream out = new FileOutputStream(imgFilePath);
            out.write(b);
            out.flush();
            out.close();
            return true;
        }
        catch (Exception e)
        {
            return false;
        }
    }

    /**
     * 二进制流转Base64字符串
     *
     * @param data 二进制流
     * @return data
     * @throws IOException 异常
     */
    public static String getImageString(byte[] data) throws IOException {
        BASE64Encoder encoder = new BASE64Encoder();
        return data != null ? encoder.encode(data) : "";
    }

}
