package com.bcxin.ars.util;

import com.bcxin.ars.util.text.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;

/**
 * 文件处理类
 *
 * @author Ethan_Huang
 */
public class FileUtil {
	Logger logger = LoggerFactory.getLogger(FileUtil.class);

	/**
	 * 将file转成byte[]
	 *
	 * @param file 待转换文件
	 * @return
	 */
	public static byte[] File2byte(File file) {
		byte[] buffer = null;
		try {
			// File file = new File(filePath);
			FileInputStream fis = new FileInputStream(file);
			ByteArrayOutputStream bos = new ByteArrayOutputStream();
			byte[] b = new byte[1024];
			int n;
			while ((n = fis.read(b)) != -1) {
				bos.write(b, 0, n);
			}
			fis.close();
			bos.close();
			buffer = bos.toByteArray();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return buffer;
	}

	/**
	 * @param buf      待转换byte
	 * @param filePath 输出文件路径
	 * @param fileName 输出文件名
	 */
	public static void byte2File(byte[] buf, String filePath, String fileName) {
		BufferedOutputStream bos = null;
		FileOutputStream fos = null;
		File file = null;
		try {
			File dir = new File(filePath);
			if (!dir.exists()) {
				dir.mkdirs();
			}
			file = new File(filePath + File.separator + fileName);
			fos = new FileOutputStream(file);
			bos = new BufferedOutputStream(fos);
			bos.write(buf);
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			if (bos != null) {
				try {
					bos.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
			if (fos != null) {
				try {
					fos.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
	}

	/**
	 * 根据日期生成文件名字符串
	 *
	 * @return
	 */
	public static String generatingFileNameByDate(String fileName) {
		Date date = new Date();
		SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
		String str = sdf.format(date);
		return fileName + "_" + str;
	}

	public static String createFileName(String fileType){
		StringBuffer fileName = new StringBuffer();
		Date now = new Date();
		int rannum =(int) (Math.random()*(99999-10000)+10000);// 获取5位随机数
		return fileName.append(now.getTime()).append(rannum).append(".").append(fileType).toString();
	}

	/**
	 * 获取文件名后缀名
	 *
	 * @param fileName
	 * @return
	 */
	public static String getFileExtension(String fileName) {
		if (!fileName.isEmpty()) {
			return fileName.substring(fileName.lastIndexOf(".") + 1);
		}
		return null;
	}

	/**
	 * 删除文件或文件夹
	 *
	 * @param filePath
	 */
	public static void deleteFolder(String filePath) {
		File file = new File(filePath);
		if (file.exists()) {
			if (file.isDirectory()) {
				for (File f : file.listFiles()) {
					deleteFolder(f.getAbsolutePath());
				}
				file.delete();
			} else {
				file.delete();
			}
		}
	}

	/**
	 * 递归删除文件
	 *
	 * @param folder
	 * @param d
	 */
	public static void deleteFile(File folder, Date d) {
		File[] files = folder.listFiles();
		for (File f : files) {
			if (f.isDirectory()) {
				deleteFile(f, d);
				if (f.list().length == 0) {
					f.delete();
				}
			} else {
				if (f.lastModified() < d.getTime()) {
					f.delete();
				}
			}
		}
	}

	/**
	 * 复制文件夹
	 *
	 * @param resFile
	 * @param objFolderFile
	 */
	public static void copyFolder(File resFile, File objFolderFile) throws IOException {
		if (!resFile.exists()) return;
		if (!objFolderFile.exists()) objFolderFile.mkdirs();
		if (resFile.isFile()) {
			File objFile = new File(objFolderFile.getPath() + File.separator + resFile.getName());
			//复制文件到目标地
			InputStream ins = new FileInputStream(resFile);
			FileOutputStream outs = new FileOutputStream(objFile);
			byte[] buffer = new byte[1024 * 512];
			int length;
			while ((length = ins.read(buffer)) != -1) {
				outs.write(buffer, 0, length);
			}
			ins.close();
			outs.flush();
			outs.close();
		} else {
			String objFolder = objFolderFile.getPath() + File.separator + resFile.getName();
			File _objFolderFile = new File(objFolder);
			_objFolderFile.mkdirs();
			for (File sf : resFile.listFiles()) {
				copyFolder(sf, new File(objFolder));
			}
		}
	}

	/**
	 * 根据文件获取byte数组
	 *
	 * @param filePath
	 * @return
	 */
	public static byte[] getBytes(String filePath) {
		byte[] buffer = null;
		try {
			File file = new File(filePath);
			FileInputStream fis = new FileInputStream(file);
			ByteArrayOutputStream bos = new ByteArrayOutputStream(1000);
			byte[] b = new byte[1000];
			int n;
			while ((n = fis.read(b)) != -1) {
				bos.write(b, 0, n);
			}
			fis.close();
			bos.close();
			buffer = bos.toByteArray();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return buffer;
	}

	/**
	 * 根据byte生成文件
	 *
	 * @param bytes
	 * @param filePath
	 * @param fileName
	 */
	public static void getFile(byte[] bytes, String filePath, String fileName) {
		BufferedOutputStream bos = null;
		FileOutputStream fos = null;
		File file = null;
		try {
			File dir = new File(filePath);
			if (!dir.exists() && dir.isDirectory()) {//判断文件目录是否存在
				dir.mkdirs();
			}
			file = new File(filePath + "\\" + fileName);
			fos = new FileOutputStream(file);
			bos = new BufferedOutputStream(fos);
			bos.write(bytes);
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			if (bos != null) {
				try {
					bos.close();
				} catch (IOException e1) {
					e1.printStackTrace();
				}
			}
			if (fos != null) {
				try {
					fos.close();
				} catch (IOException e1) {
					e1.printStackTrace();
				}
			}
		}
	}

	public static String writeTxtFile(String readStr, String type, String tempFolder, int num) {
		try {
			String basePath = tempFolder;    //路径
			String filePath = basePath + DateUtil.getCurrentDate() + File.separator;//保存路径

			String fileName = type;
			String fileType = ".data";
			File file = new File(filePath);
			if (!file.exists()) {
				file.mkdirs();
				System.out.println("文件夹已创建");
            }
            String fullFilePath = filePath + fileName + "_" + num + "_" + DateUtil.getCurrentDateTime(DateUtil.FORMAT8) + fileType;

			//文件处理：写入文件
			File newFile = new File(fullFilePath);
			Files.write(readStr.getBytes(), newFile);
			return fullFilePath;
		} catch (Exception e) {
			//System.out.println("导出失败！");
//            logger.error(e.getMessage(),e);
			return "";
		}
	}

	// TODO Auto-generated method stub
	public static String writeTxtFile(String readStr, String type, String tempFolder) {
		try {
			String basePath = tempFolder;    //路径
			String filePath = basePath + DateUtil.getCurrentDate() + File.separator;//保存路径

			String fileName = type;
			String fileType = ".data";
			File file = new File(filePath);
			if (!file.exists()) {
				file.mkdirs();
				System.out.println("文件夹已创建");
            }
			String fullFilePath = filePath + fileName + "_" + DateUtil.getCurrentDateTime(DateUtil.FORMAT8) + fileType;

            //文件处理：写入文件
			File newFile = new File(fullFilePath);
			Files.write(readStr.getBytes(), newFile);
			return fullFilePath;
		} catch (Exception e) {
			//System.out.println("导出失败！");
//            logger.error(e.getMessage(),e);
			return "";
		}
	}

	/***
	 * zip压缩方法
	 * @param filePaths
	 * @param strZipPath
	 * @return
	 */
	public static String zipFiles(List<String> filePaths, String strZipPath) {
		byte[] buffer = new byte[1024];
		try {
			ZipOutputStream out = new ZipOutputStream(new FileOutputStream(strZipPath));
			List<File> files = Lists.newArrayList();
			for (String filePath : filePaths) {
				if (StringUtil.isNotEmpty(filePath)) {
					File file = new File(filePath);
					if (file.exists()) {
						files.add(file);
					}
				}
			}

			for (File file : files) {
				FileInputStream fis = new FileInputStream(file);
				// 设置压缩文件内的字符编码，不然会变成乱码
				out.setEncoding("utf8");
				out.putNextEntry(new ZipEntry(file.getName()));
				int len;
				// 读入需要下载的文件的内容，打包到zip文件
				while ((len = fis.read(buffer)) > 0) {
					out.write(buffer, 0, len);
				}
				out.closeEntry();
				fis.close();
			}
			out.close();
		} catch (Exception e) {
			e.printStackTrace();
		}

		return strZipPath;
	}

	public static void copyDir(String oldPath, String newPath) throws IOException {
		File file = new File(oldPath);
		String[] filePath = file.list();

		if (!(new File(newPath)).exists()) {
			(new File(newPath)).mkdir();
		}

		if (filePath == null) {
			return;
		}
		for (int i = 0; i < filePath.length; i++) {
			if ((new File(oldPath + File.separator + filePath[i])).isDirectory()) {
				copyDir(oldPath + File.separator + filePath[i], newPath + File.separator + filePath[i]);
			}

			if (new File(oldPath + File.separator + filePath[i]).isFile()) {
				File from = new File(oldPath + File.separator + filePath[i]);
				File to = new File(newPath + File.separator + filePath[i]);
				if (!to.exists()) {
					Files.copy(from, to);
				}
			}
		}
	}


	/**
	 * 重命名文件
	 *
	 * @param oldPath String 原文件路径 如：原文件路径 如：c:/data/ars/temp/securityCertificateTemp.xls
	 * @param newPath String 复制后路径 如：复制后路径 如：c:/data/ars/temp/2018-08-09/保安员导入失败.xls
	 * @return boolean
	 * by llc 2018-08-09
	 **/
	public static void reNameFile(String oldPath, String newPath, String newFileName) {
		FileInputStream is = null;
		FileOutputStream out = null;
		try {
			int bytesum = 0;
			int byteread = 0;
			File oldfile = new File(oldPath);
			File newDir = new File(newPath);
			if (!newDir.exists()) {
				newDir.mkdirs();
			}
			if (oldfile.exists()) { // 文件存在时
				is = new FileInputStream(oldPath); // 读入原文件
				out = new FileOutputStream(newPath + File.separator + newFileName);
				byte[] buffer = new byte[1444];
				int length;
				while ((byteread = is.read(buffer)) != -1) {
					bytesum += byteread; // 字节数 文件大小
					out.write(buffer, 0, byteread);
				}
				is.close(); // 输入流关闭
				out.flush(); // 刷新输出流
				out.close(); // 输出流关闭
			}
		} catch (Exception e) {
			e.printStackTrace();
		} finally { // 无论程序怎么运行，最后都要关闭流；
			if (is != null || out != null) {
				try {
					is.close();// 输入流关闭
					out.close(); // 输出流关闭
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
	}

	/**
	 * 下载文件
	 *
	 * @param filePath     文件路径
	 * @param downLoadName 下载后的文件名
	 *                     by llc 2018-08-09
	 **/
	public static void downloadFile(String filePath, String downLoadName, HttpServletResponse response) {
		FileInputStream is = null;
		OutputStream out = null;
		try {
			File file = new File(filePath);
			if (file != null) {
				response.setContentType("octets/stream");
				response.addHeader("Content-Type", "text/html; charset=utf-8");
				downLoadName = new String(downLoadName.getBytes("gbk"), "iso8859-1");
				response.addHeader("Content-Disposition", "attachment;filename=" + downLoadName);
				is = new FileInputStream(file);
				out = response.getOutputStream();
				int i = 0;
				while ((i = is.read()) != -1) {
					out.write(i);
				}
				is.close(); // 输入流关闭
				out.flush(); // 刷新输出流
				out.close(); // 输出流关闭
			}
		} catch (Exception e) {
			e.printStackTrace();
		} finally { // 无论程序怎么运行，最后都要关闭流；
			if (is != null || out != null) {
				try {
					is.close();// 输入流关闭
					out.close(); // 输出流关闭
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
	}

	/**
	 * 下载文件
	 *
	 * @param filePath     文件路径
	 * @param downLoadName 下载后的文件名
	 *                     by llc 2018-08-09
	 **/
	public static void downloadFile(String filePath, String downLoadName, HttpServletRequest request, HttpServletResponse response) {
		InputStream is = null;
		OutputStream out = null;
		try {
			response.setContentType("octets/stream");
			response.addHeader("Content-Type", "text/html; charset=utf-8");
			downLoadName = new String(downLoadName.getBytes("gbk"), "iso8859-1");
			response.addHeader("Content-Disposition", "attachment;filename=" + downLoadName);
			is = request.getServletContext().getResourceAsStream(filePath);
			out = response.getOutputStream();
			int i = 0;
			while ((i = is.read()) != -1) {
				out.write(i);
			}
			is.close(); // 输入流关闭
			out.flush(); // 刷新输出流
			out.close(); // 输出流关闭
		} catch (Exception e) {
			e.printStackTrace();
		} finally { // 无论程序怎么运行，最后都要关闭流；
			if (is != null || out != null) {
				try {
					is.close();// 输入流关闭
					out.close(); // 输出流关闭
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
	}

	/**
	 * 批量删除文件
	 *
	 * @param fileList by llc 2018-09-07
	 */
	public static void deleteFileList(List<String> fileList) {
		for (String filePath : fileList) {
			File file = new File(filePath);
			if (file.exists() && file.isFile()) {
				file.delete();
			}
		}
	}

	/**
	 * 删除单个文件
	 *
	 * @param filePath by llc 2018-09-07
	 */
	public static void deleteFile(String filePath) {
		File file = new File(filePath);
		if (file.exists() && file.isFile()) {
			file.delete();
		}
	}

	public static String getFileNameByPath(String filePath) {
		File file = new File(filePath);
		return file.getName();
	}

	/**
	 * 生成一个时间区间的excel名,用于资格证导出
	 *
	 * @param start 开始时间
	 * @param end   结束时间
	 * @return 表名
	 */
	public static String getFileNameByDateInterregional(Date start, Date end) {
		String startTime = com.xiaoleilu.hutool.date.DateUtil.format(start, DateUtil.FORMAT11);
		String endTime = com.xiaoleilu.hutool.date.DateUtil.format(end, DateUtil.FORMAT11);
		if (StringUtils.isBlank(startTime)) {
			startTime = String.valueOf(LocalDate.now());
		}
		if (StringUtils.isBlank(endTime)) {
			endTime = String.valueOf(LocalDate.now());
		}
		return startTime + "-" + endTime + "补贴人员花名册";
	}


	/**
	 * 复制模板文件
	 *
	 * @param oldPath String 原文件路径 如：原文件路径
	 *                如：c:/data/ars/temp/securityCertificateTemp.xls
	 * @param newPath String 复制后路径 如：复制后路径 如：c:/data/ars/temp/2018-08-09/保安员导入失败.xls
	 * @return boolean by llc 2018-08-09
	 **/
	public static void copyTempFile(String oldPath, String newPath, HttpServletRequest request) {
		InputStream is = null;
		OutputStream out = null;
		try {
			is = request.getServletContext().getResourceAsStream(oldPath);
			int bytesum = 0;
			int byteread = 0;
			if (is != null) { // 文件存在时
				out = new FileOutputStream(newPath);
				byte[] buffer = new byte[1444];
				int length;
				while ((byteread = is.read(buffer)) != -1) {
					bytesum += byteread; // 字节数 文件大小
					out.write(buffer, 0, byteread);
				}
				is.close(); // 输入流关闭
				out.flush(); // 刷新输出流
				out.close(); // 输出流关闭
			}
		} catch (Exception e) {
			e.printStackTrace();
		} finally { // 无论程序怎么运行，最后都要关闭流；
			if (is != null || out != null) {
				try {
					is.close();// 输入流关闭
					out.close(); // 输出流关闭
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
	}

	/**
	 * 下载远程文件到本地
	 * @param remoteFilePath 文件路径
	 * @param localFilePath 保存本地路径
	 */
	public static void downloadFile(String remoteFilePath, String localFilePath) throws Exception{
		URL urlfile = null;
		HttpURLConnection httpUrl = null;
		BufferedInputStream bis = null;
		BufferedOutputStream bos = null;
		File f = new File(localFilePath);
		try{
			if(!f.getParentFile().exists()){
				f.getParentFile().mkdirs();
			}
			urlfile = new URL(remoteFilePath);
			httpUrl = (HttpURLConnection)urlfile.openConnection();
			httpUrl.connect();
			bis = new BufferedInputStream(httpUrl.getInputStream());
			bos = new BufferedOutputStream(new FileOutputStream(f));
			int len = 2048;
			byte[] b = new byte[len];
			while ((len = bis.read(b)) != -1){
				bos.write(b, 0, len);
			}
			bos.flush();
			bis.close();
			httpUrl.disconnect();
		}finally{
			try{
				bis.close();
				bos.close();
			}catch (IOException e){
				e.printStackTrace();
			}
		}
	}

}