package com.bcxin.ars.util;

/**
 * @author linqinglin
 * @date 2020/03/13 0013 9:08
 */
public class CerUtil {


    /**
     * 数字金额大写转换，思想先写个完整的然后将如零拾替换成零 要用到正则表达式
     */
    public static String digitUppercase(double v) {
        //默认传的是万元为单位 转成元
        v = v*10000;

        String UNIT = "万仟佰拾亿仟佰拾万仟佰拾元角分";
        String DIGIT = "零壹贰叁肆伍陆柒捌玖";
        double MAX_VALUE = 9999999999999.99D;

        if (v < 0 || v > MAX_VALUE){
            return "参数非法!";
        }
        long l = Math.round(v * 100);
        if (l == 0){
            return "零元";
        }
        String strValue = l + "";
        // i用来控制数
        int i = 0;
        // j用来控制单位
        int j = UNIT.length() - strValue.length();
        String rs = "";
        boolean isZero = false;
        for (; i < strValue.length(); i++, j++) {
            char ch = strValue.charAt(i);
            if (ch == '0') {
                isZero = true;
                if (UNIT.charAt(j) == '亿' || UNIT.charAt(j) == '万' || UNIT.charAt(j) == '元') {
                    rs = rs + UNIT.charAt(j);
                    isZero = false;
                }
            } else {
                if (isZero) {
                    rs = rs + "零";
                    isZero = false;
                }
                rs = rs + DIGIT.charAt(ch - '0') + UNIT.charAt(j);
            }
        }
        rs = rs.replaceAll("亿万", "亿");
        return rs;
    }


    public static String formatManagement(String fwfw, String otherSecScopeType) {
        if (StringUtil.isEmpty(fwfw)) {
            return "";
        }
        StringBuffer management = new StringBuffer();

        //服务范围打印顺序  /*门卫  巡逻 守护 押运 随身护卫 安全检查 安全技术防范 安全风险评估 区域秩序维护 */
        String[] orders= new String[]{"1","2","3","4","5","6","7","8","9"};
        String[] ss = fwfw.split(",");
        for(int j=0;j<orders.length;j++){
            for (int i = 0; i < ss.length; i++) {
                if(orders[j].equals(ss[i])) {
                    if ("1".equals(ss[i])) {
                        management.append("门卫、");
                    } else if ("2".equals(ss[i])) {
                        management.append("巡逻、");
                    } else if ("3".equals(ss[i])) {
                        management.append("守护、");
                    } else if ("4".equals(ss[i])) {
                        management.append("随身护卫、");
                    } else if ("5".equals(ss[i])) {
                        management.append("押运、");
                    } else if ("6".equals(ss[i])) {
                        management.append("武装押运、");
                    } else if ("7".equals(ss[i])) {
                        management.append("安全检查、");
                    } else if ("8".equals(ss[i])) {
                        management.append("安全风险评估、");
                    } else if ("9".equals(ss[i])) {
                        management.append("安全技术防范、");
                    } else if ("20".equals(ss[i])) {
                        management.append("其他" + (otherSecScopeType == null ? "" : "(" + otherSecScopeType + ")、"));
                    }
                }

            }
        }
        return management.toString().substring(0,management.toString().length()-1);
    }
}
