package com.bcxin.ars.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Date;

/**
 * Created by Hsenberg on 2017/7/20.
 */
public class BuildWebServiceEntity {
    private static final Logger logger = LoggerFactory.getLogger(BuildWebServiceEntity.class);
    /**
     * 通过源实体类给目标实体类赋值
     * @param srccol 源实体类的列名数组
     * @param desccol  目标实体类的列名数组
     * @param src   源实体对象
     * @param desc  目标实体对象
     * @param key   源特殊列名数组
     * @param value  源特殊列值数组
     * @return desc   返回赋值的目标实体对象
     */
    public static Object buildWebServiceEntity(String[] srccol, String[] desccol, Object src, Object desc,String[] key, String[] value) {
        Class srcClass = src.getClass();
        Class descClass = desc.getClass();
        Field[] fieldb = desc.getClass().getDeclaredFields();//获得目标属性
        Field[] fielda = src.getClass().getDeclaredFields();//获得源属性

        for(int i =0;i<srccol.length;i++){
            for (Field field : fielda) {
                try {
                    if(!field.getName().equals("serialVersionUID")){
                        PropertyDescriptor pd = new PropertyDescriptor(field.getName(),srcClass);
                        Method getMethod = pd.getReadMethod();//获得源对象的get方法
                        if(field.getName().equals(srccol[i])){
                            for (Field field1 : fieldb) {
                                try {
                                    if(!field1.getName().equals("serialVersionUID")){
                                        PropertyDescriptor pd1 = new PropertyDescriptor(field1.getName(),descClass);
                                        Method writeMethod = pd1.getWriteMethod();//获得目标对象的set方法
                                        //如果匹配，则将源对象属性的值赋值给目标对象属性
                                        if(field1.getName().equals(desccol[i])){
                                            writeMethod.invoke(desc,getMethod.invoke(src));
                                            continue;
                                            //如果不匹配，则是特殊列的赋值
                                        }else if(i<key.length&&field1.getName().equals(key[i])){
                                            //如果是int，则转为int
                                            if(field1.getType().toString().endsWith("int")){
                                                writeMethod.invoke(desc,Integer.parseInt(value[i]));
                                                continue;
                                                //如果是Date，则转为Date
                                            }else if(field1.getType().toString().endsWith("Date")){
                                                writeMethod.invoke(desc, DateUtil.convertStringToDate(value[i]));
                                                continue;
                                            }else{//默认是字符串
                                                writeMethod.invoke(desc,value[i]);
                                                continue;
                                            }

                                        }
                                    }

                                }catch (Exception e){
                                    logger.error(e.getMessage(), e);
                                    throw e;
                                }
                            }
                        }
                    }


                }catch (Exception e){
                    logger.error(e.getMessage(), e);
                }
            }
        }
        return desc;
    }
}
