package com.bcxin.ars.enums;

/**
 * @author linqinglin
 * @date 2019/01/07 0007 13:20
 */
public enum BusinessType {

    BAFWGS{
        @Override
        public String getCode(){return "001";}
        @Override
        public String getName(){return "保安服务公司许可证审批";}
    },
    PXDW{
        @Override
        public String getCode(){return "002";}
        @Override
        public String getName(){return "保安培训机构许可证申请";}
    },
    BAGSZGS{
        @Override
        public String getCode(){return "003";}
        @Override
        public String getName(){return "保安服务公司设立分公司备案";}
    },
    BAYZ{
        @Override
        public String getCode(){return "004";}
        @Override
        public String getName(){return "保安员资格证考试报名";}
    },
    KQYBAGS{
        @Override
        public String getCode(){return "005";}
        @Override
        public String getName(){return "保安服务公司派出保安员跨省、自治区、直辖市保安服务备案";}
    },
    ZXZY{
        @Override
        public String getCode(){return "006";}
        @Override
        public String getName(){return "自行招用保安员单位备案";}
    },
    FRBG{
        @Override
        public String getCode(){return "007";}
        @Override
        public String getName(){return "保安服务许可证项目变更";}
    },
    NDBG{
        @Override
        public String getCode(){return "008";}
        @Override
        public String getName(){return "保安公司年度报告备案";}
    },
    QZPX{
        @Override
        public String getCode(){return "009";}
        @Override
        public String getName(){return "从事武装守护押运服务的保安员的枪支培训机构备案";}
    },
    ZZBACX{
        @Override
        public String getCode(){return "010";}
        @Override
        public String getName(){return "自行招用保安员单位撤销备案";}
    },
    DJZBT{
        @Override
        public String getCode(){return "011";}
        @Override
        public String getName(){return "等级证补贴";}
    },
    ZGZBT{
        @Override
        public String getCode(){return "012";}
        @Override
        public String getName(){return "资格证补贴";}
    },
    PXDWXMBG{
        @Override
        public String getCode(){return "013";}
        @Override
        public String getName(){return "保安培训备案项目变更";}
    },PXDWBA{
        @Override
        public String getCode(){return "014";}
        @Override
        public String getName(){return "保安培训单位备案";}
    },BAYZHF{
        @Override
        public String getCode(){return "015";}
        @Override
        public String getName(){return "保安员证核发";}
    };


    public abstract String getCode();

    public abstract String getName();

    public static String convertName(String code) {
        String result = "";
        switch (code) {
            case "001":
                result = BAFWGS.getName();
                break;
            case "002":
                result = PXDW.getName();
                break;
            case "003":
                result = BAGSZGS.getName();
                break;
            case "004":
                result = BAYZ.getName();
                break;
            case "005":
                result = KQYBAGS.getName();
                break;
            case "006":
                result = ZXZY.getName();
                break;
            case "007":
                result = FRBG.getName();
                break;
            case "008":
                result = NDBG.getName();
                break;
            case "009":
                result = QZPX.getName();
                break;
            case "010":
                result = ZZBACX.getName();
                break;
            case "011":
                result = DJZBT.getName();
                break;
            case "012":
                result = ZGZBT.getName();
                break;
            case "013":
                result = PXDWXMBG.getName();
                break;
            case "014":
                result = PXDWBA.getName();
                break;
            case "015":
                result = BAYZHF.getName();
                break;
            default:
                break;
        }
        return result;
    }

}
