package com.bcxin.ars.timer.task.status;

import com.bcxin.ars.dao.sb.CrosscompanyDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.SAASMessageDto;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.SAASInterfaceUtil;
import com.bcxin.ars.util.Constants;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

/**
 * 外省保安跨区服务设立分公司备案到期提醒服务
 * 备案有效期到期前一周，给保安公司发送站内信，提示重新备案
 *
 * @author zhangyutong
 * Create by 2020/12/15
 */
@Service
public class CrossCompanyFilingExpiredNotifyService {

    private static final Logger logger = LoggerFactory.getLogger(CrossCompanyFilingExpiredNotifyService.class);

    @Resource
    private JobRunLogService jobRunLogService;

    @Resource
    private SAASInterfaceUtil saasInterfaceUtil;

    @Resource
    private CrosscompanyDao crosscompanyDao;

    @Resource
    private ConfigUtils configUtils;

    public void run() {
        if(!Constants.TIMEFLAG_VALUE.equals(configUtils.timeFlag)){
            return;
        }
        if(Constants.SHANGXI.equals(configUtils.getCurrentNative()) && !configUtils.isIntranet() ){
            //陕西外网
            logger.error("跨省备案过期提醒任务");
            // 设置日志记录
            JobRunLog log = new JobRunLog();
            log.setCreateTime(new Date());
            log.setJobName(this.getClass().getName());
            log.setActive(true);
            log.setUpdateBy("jobSystem");
            log.setRunTime(new Date());
            long startTime = System.currentTimeMillis();
            try {
                // 查询备案信息快过期的公司id们
                List<String> companyIds = crosscompanyDao.findFilingExpiredIds();
                logger.error("跨省备案快过期的公司:{}", companyIds);
                if(companyIds.size() > 0) {
                    StringBuilder ids = new StringBuilder();
                    companyIds.forEach(id -> {
                        if (StringUtils.isNotBlank(id)) {
                            ids.append(id).append(",");
                        }
                    });
                    // 删除最后一个`,`
                    ids.delete(ids.length() - 1, ids.length());
                    send(ids.toString(), Constants.MESSAGE_CROSS_COMPANY_EXPIRED_TITLE, Constants.MESSAGE_CROSS_COMPANY_EXPIRED_CONTENT);
                }
            }catch (Exception e){
                e.printStackTrace();
            }finally {
                long endTime = System.currentTimeMillis();
                log.setRunTimeLength((endTime - startTime) + "ms");
                log.setUpdateTime(new Date());
                // 保存日志
                jobRunLogService.insert(log);
            }
        }
    }

    /**
     * 发送消息的方法,调用对方接口发站内信
     *
     * @param companyIds 公司id集合
     * @param title      消息头
     * @param content    消息体
     * @return 返回结果
     */
    public AjaxResult send(String companyIds,
                           String title,
                           String content) {
        SAASMessageDto saasMessageDto = new SAASMessageDto();
        saasMessageDto.setComIds(companyIds);
        saasMessageDto.setTitle(title);
        saasMessageDto.setContent(content);
        saasMessageDto.setPoliceRegionId(configUtils.getCurrentProvince());
        saasMessageDto.setMessageType(Constants.MESSAGETYPE_050205);
        return saasInterfaceUtil.sendSaasMsg(saasMessageDto);

    }

}
