package com.bcxin.ars.timer.sequence;

import com.abcxin.smart.validator.annotation.JobLogAnnotation;
import com.bcxin.ars.dao.sys.SysSequenceDao;
import com.bcxin.ars.model.sys.SysSequence;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 *
 * 每年的1月1号重置证书编号
 * @author linqinglin
 * @date 2021/05/07 0007 9:00
 */

@Service
public class CerNoService {

    private Logger logger = LoggerFactory.getLogger(CerNoService.class);

    @Autowired
    private SysSequenceDao sysSequenceDao;

    @Autowired
    private ConfigUtils configUtils;

    @JobLogAnnotation(getJobClazz = CerNoService.class)
    public void resetYearCerNo(){
        //北京外网定时器才执行
        if(Constants.BEIJING.equals(configUtils.getCurrentNative())
                && !configUtils.isIntranet()
                && configUtils.timeFlag.equals("true")) {

            String year = DateUtil.getCurrentDate(DateUtil.FORMAT10);

            //结业证书编号
            SysSequence sysSequence = sysSequenceDao.findBySeqName("seq_Complete_Cer");
            if (sysSequence != null) {
                if (!sysSequence.getCurrentValue().startsWith(year)) {
                    sysSequence.setCurrentValue(year + "00000");
                    sysSequenceDao.updateBySeqName(sysSequence);
                }
            }
            //资格证书编号
            sysSequence = sysSequenceDao.findBySeqName("seq_zsbh");
            if (sysSequence != null) {
                if (!sysSequence.getCurrentValue().startsWith(year)) {
                    sysSequence.setCurrentValue(year + "000000");
                    sysSequenceDao.updateBySeqName(sysSequence);
                }
            }
        }
    }
}
