package com.bcxin.ars.timer.problemPerson;

import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * 问题人员重置
 * @author subh
 */
@Service
public class RefreshProblemPersonService {
    /***
     * 人员
     */
    @Autowired
    private SecurityPersonService securityPersonService;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private JobRunLogService jobRunLogService;
    @Value("${ZAFLAG}")
    private String ZAFLAG;



    public void run() {
        //判断是否为公安内网，只有内网才重置状态
        if(configUtils.isIntranet() && ZAFLAG!=null && Constants.ZAFLAG_YES.equals(ZAFLAG)) {
            if(!Constants.BEIJING.equals(configUtils.getCurrentNative())){
                return;
            }
            //查询所有人员
            List<SecurityPerson> personList = securityPersonService.findNoPassCensorStatus();
            //当背景筛查人数小于10的时候，重置状态
            if(personList!=null && personList.size()<10) {
                JobRunLog log = new JobRunLog();
                log.setCreateTime(new Date());
                log.setActive(true);
                log.setUpdateBy("jobSystem");
                //开始时间
                long startTime = System.currentTimeMillis();
                //重置状态
                securityPersonService.refreshPersonCensorCriminalStatus();
                //日志信息
                long endTime = System.currentTimeMillis();
                log.setUpdateTime(new Date());
                log.setJobName(RefreshProblemPersonService.class.getName());
                log.setRunTime(new Date());
                log.setRunTimeLength((endTime - startTime) + "ms");
                jobRunLogService.insert(log);
            }
        }

    }
}
