package com.bcxin.ars.timer.problemPerson;

import cn.hutool.core.thread.ThreadUtil;
import com.bcxin.ars.dto.sb.BackgroundApprovalDto;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.sb.BackgroundApproval;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.approval.ApprovalState;
import com.bcxin.ars.util.spring.util.SpringUtils;
import com.bcxin.ars.webservice.BackGroupCensorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;

/**
 * 问题人员定时器
 * @author subh
 */
@Service
public class ProblemPersonReScreenServiceJob {
    private Logger logger = LoggerFactory.getLogger(ProblemPersonReScreenServiceJob.class);
    /***
     * 人员
     */
    @Autowired
    private SecurityPersonService securityPersonService;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private JobRunLogService jobRunLogService;
    private static BackGroupCensorService backGroupCensorService;
    @Value("${ZAFLAG}")
    private String ZAFLAG;

    private boolean lock = false;
    private int backGroupFrequency=14;

    public void run() {
        if(lock){
            return;
        }
        lock = true;
        try{

            String bg_switch = configUtils.getValueByKey("bg_switch");
            if("0".equals(bg_switch)){
                return;
            }

            if (backGroupCensorService == null) {
                backGroupCensorService = SpringUtils.getBean("backGroupCensorService_"+configUtils.getCurrentProvince());
            }

            if(Constants.SHANGXI.equals(configUtils.getCurrentNative())){
                return;
            }
            //判断是否为公安内网，只有内网才背景筛查
            if (configUtils.isIntranet() && ZAFLAG != null && Constants.ZAFLAG_YES.equals(ZAFLAG)) {
                JobRunLog log = new JobRunLog();
                log.setCreateTime(new Date());
                log.setActive(true);
                log.setUpdateBy("jobSystem");
                //开始时间
                long startTime = System.currentTimeMillis();
                try {
                    //查询所有人员
                    List<SecurityPerson> personList = securityPersonService.findReCensor(backGroupFrequency);
                    if (personList.size() > 0) {
                        //根据数据数量情况，切分不同的大小
                        int limit = 100;
                        //计算拆分次数
                        int count = new Double(Math.ceil(personList.size() * 1.0 / limit)).intValue();
                        //存放拆分数据
                        List<SecurityPerson> subList = null;
                        //循环拆分次数 生成相应数据文件
                        for (int i = 0; i < count; i++) {
                            subList = personList.stream().skip(i * limit).limit(limit).collect(Collectors.toList());

                            CountDownLatch countDownLatch = ThreadUtil.newCountDownLatch(subList.size());
                            ThreadPoolExecutor threadPoolExecutor = ThreadUtil.newExecutor(15, 15);
                            //先背景筛查
                            for (SecurityPerson securityPerson : subList) {
                                threadPoolExecutor.execute(new Runnable() {
                                    @Override
                                    public void run() {
                                        try {
                                            BackgroundApprovalDto dto = new BackgroundApprovalDto();
                                            //身份证号
                                            dto.setIdNumber(securityPerson.getIdNumber());
                                            //姓名
                                            dto.setRealName(securityPerson.getRealName());
                                            //主键
                                            dto.setBusinessid(securityPerson.getId());
                                            //问题人员
                                            dto.setBusinesstype(Constants.BAY_FZR);
                                            dto.setAuthState(securityPerson.getIdentityAuthState());
                                            //背景筛查
                                            List<BackgroundApproval> backgroundApprovals = backGroupCensorService.censor(dto);
                                            securityPerson.setBackgroundApprovals(backgroundApprovals);
                                            //背景筛查无异常
                                            securityPerson.setCensorStatusError(false);
                                        } catch (Exception e) {
                                            //背景筛查异常
                                            securityPerson.setCensorStatusError(true);
                                            logger.error(e.getMessage(), e);
                                        } finally {
                                            countDownLatch.countDown();
                                        }
                                    }
                                });
                            }
                            try {
                                //线程等待全部完成
                                countDownLatch.await();
                            } catch (InterruptedException e) {
                                logger.error(e.getMessage(), e);
                                e.printStackTrace();
                                Thread.currentThread().interrupt();
                            }finally {
                                threadPoolExecutor.shutdown();
                            }
                            List<SecurityPerson> successPersonList = new CopyOnWriteArrayList<>();
                            CountDownLatch countDownLatch1 = ThreadUtil.newCountDownLatch(subList.size());
                            ThreadPoolExecutor threadPoolExecutor1 = ThreadUtil.newExecutor(30, 30);
                            for (SecurityPerson securityPerson : subList) {
                                threadPoolExecutor1.execute(new Runnable() {
                                    @Override
                                    public void run() {
                                        try {
                                            Boolean result = false;
                                            //循环背景筛查记录，检查是否有不通过
                                            if (securityPerson.getBackgroundApprovals() != null && securityPerson.getBackgroundApprovals().size() > 0) {
                                                for (BackgroundApproval backgroundApproval : securityPerson.getBackgroundApprovals()) {
                                                    if (ApprovalState.SHBTG.equals(backgroundApproval.getApprovalstate())) {
                                                        result = true;
                                                    }
                                                }
                                            }
                                            //判断是否人口库异常
                                            if (!securityPerson.getCensorStatusError()) {
                                                if (result) {
                                                    backGroupCensorService.censorSaveProblemPerson(securityPerson, securityPerson.getBackgroundApprovals());
                                                } else {
                                                    successPersonList.add(securityPerson);
                                                }
                                            }
                                        } catch (Exception e) {
                                            logger.error(e.getMessage(), e);
                                            e.printStackTrace();
                                        } finally {
                                            countDownLatch1.countDown();
                                        }
                                    }
                                });
                            }
                            try {
                                //线程等待全部完成
                                countDownLatch1.await();
                            } catch (InterruptedException e) {
                                logger.error(e.getMessage(), e);
                            }
                            threadPoolExecutor1.shutdown();
                            //批量更新人员背景筛查状态
                            if (successPersonList != null && successPersonList.size() > 0) {
                                securityPersonService.updateCensorStatusList(successPersonList);
                            }
                        }
                    }
                } catch (Exception e) {
                    logger.error(e.getMessage(), e);
                    log.setExceptionMsg(e.toString());
                    e.printStackTrace();
                }
                //日志信息
                long endTime = System.currentTimeMillis();
                log.setUpdateTime(new Date());
                log.setJobName(ProblemPersonServiceJob.class.getName());
                log.setRunTime(new Date());
                log.setRunTimeLength((endTime - startTime) + "ms");
                jobRunLogService.insert(log);
            }
        }finally {
            lock = false;
        }
    }

    public static void main(String[] args) {
        try {
            System.out.println(1/0);
        }catch (Exception e){
            System.out.println(1/0);
        }finally {
            System.out.println("1111");
        }

        System.out.println("222");
    }
}


