package com.bcxin.ars.timer.police;

import cn.hutool.core.thread.ThreadUtil;
import com.abcxin.smart.validator.annotation.JobLogAnnotation;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.service.bean.factory.BackGroupCensorServiceBeanFactory;
import com.bcxin.ars.service.sb.BackgroundApprovalService;
import com.bcxin.ars.service.sb.PersoncertificateService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.spring.util.SpringUtils;
import com.bcxin.ars.webservice.BackGroupCensorService;
import com.bcxin.ars.webservice.police.SecurityInterfaceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;

/**
 * 自动背景筛查
 */
@Service
public class PersonCensorJob {
	
	private Logger logger = LoggerFactory.getLogger(PersonCensorJob.class);

	@Autowired
	private PersoncertificateService personcertificateService;
	@Value("${timeFlag}")
	private String timeFlag = "";
    @Autowired
    private BackgroundApprovalService backgroundApprovalService;
    private static BackGroupCensorService backGroupCensorService;
    /***
     * 先获取背景筛查实现类对
     */
    private void getBackGroupCensorService(){
        if(backGroupCensorService == null){
            backGroupCensorService = BackGroupCensorServiceBeanFactory.getBackGroupCensorServiceBean();
        }
    }
	@Autowired
	private ConfigUtils configUtils;

    private boolean lock = false;

    @JobLogAnnotation(getJobClazz = PersonCensorJob.class)
	public void run() {
        if(lock){
            return;
        }
        lock = true;
        try{
            String bg_switch = configUtils.getValueByKey("bg_switch");
            if("0".equals(bg_switch)){
                return;
            }

            if(!Constants.SHANGXI.equals(configUtils.getCurrentNative())){
                return;
            }

            if (configUtils.isIntranet() && timeFlag.equals("true")) {
                try {
                    /*查询需要背景筛查人员*/
                    List<Personcertificate> personcertificateList = personcertificateService.findNoCensorStatus();
                    if (personcertificateList.size() > 0) {
                        SecurityInterfaceService securityInterfaceService = SpringUtils.getBean("securityInterfaceService_"+configUtils.getCurrentProvince());
                        //根据数据数量情况，切分不同的大小
                        int limit = 5;
                        //计算拆分次数
                        int count = new Double(Math.ceil(personcertificateList.size() * 1.0 / limit)).intValue();
                        //存放拆分数据
                        List<Personcertificate> subList = null;
                        //循环拆分次数 生成相应数据文件
                        for (int i = 0; i < count; i++) {
                            subList = personcertificateList.stream().skip(i * limit).limit(limit).collect(Collectors.toList());
                            //先背景筛查
                            securityInterfaceService.censorNewQualification(subList);
                            CountDownLatch countDownLatch1 = ThreadUtil.newCountDownLatch(subList.size());
                            ThreadPoolExecutor threadPoolExecutor1 = ThreadUtil.newExecutor(15, 15);
                            /*更新数据*/
                            for (Personcertificate personcertificate : subList) {
                                threadPoolExecutor1.execute(new Runnable() {
                                    @Override
                                    public void run() {
                                        try {
                                            if (!personcertificate.getCensorStatusError()) {
                                                personcertificateService.updateCensorStatusForAuto(personcertificate,personcertificate.getBackgroundApprovals());
                                            }
                                        } catch (Exception e) {
                                            logger.error(e.getMessage(), e);
                                        } finally {
                                            countDownLatch1.countDown();
                                        }
                                    }
                                });
                            }
                            try {
                                //线程等待全部完成
                                countDownLatch1.await();
                            } catch (InterruptedException e) {
                                logger.error(e.getMessage(), e);
                                Thread.currentThread().interrupt();
                            }finally {
                                threadPoolExecutor1.shutdown();
                            }
                        }
                    }
                }catch(Exception e){
                    logger.error(e.getMessage(), e);
                }finally{
                }
            }
        }finally {
            lock = false;
        }
	}

}
