package com.bcxin.ars.timer.police;


import com.abcxin.smart.validator.annotation.JobLogAnnotation;
import com.bcxin.ars.dao.certificate.SecurityCertificateDao;
import com.bcxin.ars.dao.sb.PersoncertificateDao;
import com.bcxin.ars.model.PersonBaseInfo;
import com.bcxin.ars.model.certificate.SecurityCertificate;
import com.bcxin.ars.service.PersonBaseInfoService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.PhotoUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.spring.util.SpringUtils;
import com.bcxin.ars.webservice.police.SecurityInterfaceService;
import com.bcxin.ars.webservice.police.enums.ResultType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


/***
 * 定时获取图片
 */
@Service
public class CerPhotoJob {
    private Logger logger = LoggerFactory.getLogger(CerPhotoJob.class);

    @Autowired
    SecurityCertificateDao securityCertificateDao;

    @Autowired
    PersoncertificateDao personcertificateDao;

    @Autowired
    private PersonBaseInfoService personBaseInfoService;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private PhotoUtil photoUtil;

    private boolean lock = false;

    @JobLogAnnotation(getJobClazz = CerPhotoJob.class)
    public void run() {
        if(lock){
            return;
        }
        lock = true;

        try {

            if(!Constants.SHANGXI.equals(configUtils.getCurrentNative())){
                return;
            }

            if (Constants.TIMEFLAG_VALUE.equals(configUtils.timeFlag) && configUtils.isIntranet()) {
                try{
                    //北京证书从报名信息获取，不需要从人口库图片和地址
                    if (!Constants.BEIJING.equals(configUtils.getCurrentNative())) {
                        SecurityInterfaceService securityInterfaceService = SpringUtils.getBean("securityInterfaceService_"+configUtils.getCurrentProvince());
                        //判断是否为公安内网，只有内网才可以调用八大库add 2018-05-12 subh start
                        if (configUtils.isIntranet()) {
                            //判断是否为公安内网，只有内网才可以调用八大库add 2018-05-12 subh end
                            List<String> list = securityCertificateDao.findNoPhotoList();
                            /***
                             * 获取省份信息，广西、宁夏需要自动同步，其它省份不需要 2019-03-22 subh eidt
                             */
                            if (list.size() > 0) {
                                //根据数据数量情况，切分不同的大小
                                int limit = 5;
                                //计算拆分次数
                                int count = new Double(Math.ceil(list.size() * 1.0 / limit)).intValue();
                                //存放拆分数据
                                List<String> subList = null;
                                //循环拆分次数 生成相应数据文件
                                for (int i = 0; i < count; i++) {
                                    subList = list.stream().skip(i * limit).limit(limit).collect(Collectors.toList());
                                    Map<String, PersonBaseInfo> personMap = securityInterfaceService.getNewPersonInfo(subList);
                                    for (String idnum : subList) {
                                        //更新security_certificate表中图片的状态
                                        SecurityCertificate securityCertificate = new SecurityCertificate();
                                        securityCertificate.setIdnum(idnum);
                                        securityCertificate.setHavephoto(false);
                                        PersonBaseInfo personBaseInfo = personMap.get(idnum);
                                        if (personBaseInfo != null) {
                                            personBaseInfo.setCreateTime(new Date());
                                            personBaseInfo.setActive(true);
                                            if (StringUtil.isNotEmpty(personBaseInfo.getPhoto())) {
                                                photoUtil.savePhoto(personBaseInfo);
                                                //更新security_certificate表中图片的状态
                                                securityCertificate.setHavephoto(true);
                                                securityCertificate.setHeadImg(personBaseInfo.getImgPath());
                                            }
                                            personBaseInfoService.save(personBaseInfo);
                                        }
                                        securityCertificateDao.updateHavePhotodByIdnum(securityCertificate);
                                    }
                                }
                            }
                        }
                    }
                } catch (Exception e) {
                    logger.error(e.getMessage(),e);
                }
            }
        } catch (Exception e) {
            logger.error(e.getMessage(),e);
        }finally {
            lock = false;
        }
    }

}
