package com.bcxin.ars.timer.person.train;

import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.OrderPerson;
import com.bcxin.ars.service.ConfigService;
import com.bcxin.ars.service.OrderPersonService;
import com.bcxin.ars.timer.task.status.AutoUpdateStatusService;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.ThirdPartyURL;
import com.bcxin.ars.util.message.messageUtils;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by Administrator on 2017/6/8.
 */
@Service
public class AutoUpdatePersonTrainInfo {
    private Logger logger = LoggerFactory.getLogger(AutoUpdateStatusService.class);
    @Autowired
    private OrderPersonService orderPersonService;

    @Autowired
    private ConfigService configService;
	@Value("${timeFlag}")
	private String timeFlag = "";
    public void updateTrainInfo() {
        Config config = configService.findByKey("police");
		// 外网
		if (config.getValue().equals("0")  && timeFlag.equals("true") ) {
			logger.info("begin to update stuty progress...");
			///TODO 查询orderperson
			List<OrderPerson> list =orderPersonService.findAll();
			//TODO 身份证更新学习进度
			Config coninsConfig = configService.findByKey(Constants.TRAIN);
			for(int i =0;i<list.size();i++){
				String url = coninsConfig.getValue() + ThirdPartyURL.test+"?identitynumber="+list.get(i).getIdentitynumber()+"&groupid="+list.get(i).getGroupid();
				String resultStr = messageUtils.getJsonByInternet(url);
				JsonParser parser=new JsonParser();  //创建JSON解析器
				if(null!=resultStr&&resultStr!=""){
					JsonObject object=(JsonObject) parser.parse(resultStr);  //创建JsonObject对象
					OrderPerson orderPerson = new OrderPerson();
					orderPerson.setIdentitynumber(list.get(i).getIdentitynumber());
					orderPerson.setGroupid(list.get(i).getGroupid());
					object.get("learnprogress").getAsString();
					orderPerson.setStudyprogress(object.get("learnprogress").getAsInt());
					orderPerson.setStudylong(object.get("learningtime").getAsInt());
					orderPerson.setVideonum(object.get("videonum").getAsInt());
					try{
						if(null!=object.get("endtime").getAsString()&&!"".equals(object.get("endtime").getAsString())){
							orderPerson.setEndtime(new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").parse(object.get("endtime").getAsString().substring(0,19)));
						}
					}catch (Exception e){
						logger.error(e.getMessage(), e);
					}
					orderPersonService.updateTrainInfo(orderPerson);
				}
				else{
					logger.info("update stuty progress error.");
				}
			}
			logger.info("update stuty progress done.");
		}
    }

}
