package com.bcxin.ars.timer.gradePerson;

import com.bcxin.ars.dto.sb.BackgroundApprovalDto;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.sb.BackgroundApproval;
import com.bcxin.ars.model.sb.GradePerson;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.bean.factory.BackGroupCensorServiceBeanFactory;
import com.bcxin.ars.service.sb.BackgroundApprovalService;
import com.bcxin.ars.service.sb.GradePersonService;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.timer.personcertificate.AutoUpdateCensorStatus;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.webservice.BackGroupCensorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * 自动背景筛查太等级证
 */
@Service
public class AutoGradePersonCensorStatus {
    /***
     * 日志
     */
    private static  final  Logger logger = LoggerFactory.getLogger(AutoGradePersonCensorStatus.class);

    @Autowired
    private GradePersonService gradePersonService;
    @Value("${timeFlag}")
    private String timeFlag = "";
    @Autowired
    private ConfigUtils configUtils;


    @Autowired
    private JobRunLogService jobRunLogService;
    @Autowired
    private BackgroundApprovalService backgroundApprovalService;
    private static BackGroupCensorService backGroupCensorService;
    /***
     * 先获取背景筛查实现类对
     */
    private void getBackGroupCensorService(){
        if(backGroupCensorService == null){
            backGroupCensorService = BackGroupCensorServiceBeanFactory.getBackGroupCensorServiceBean();
        }
    }


    public void run() {
        Config config = configUtils.getConfigByKey(Constants.POLICE);
        if (config.getValue().equals(Constants.POLICE_IN) && timeFlag.equals("true")) {
            JobRunLog log = new JobRunLog();
            log.setCreateTime(new Date());
            log.setActive(true);
            log.setUpdateBy("jobSystem");
            //开始时间
            long startTime = System.currentTimeMillis();
            try {
                getBackGroupCensorService();
                /****
                 * 未背景筛查列表
                 */
                List<GradePerson> gradePersonList = gradePersonService.findNoCensorStatus();
                if (gradePersonList != null && gradePersonList.size() > 0) {
                    for (GradePerson gradePerson : gradePersonList) {
                        //背景筛查开始
                        BackgroundApprovalDto backgroundApprovalDto = new BackgroundApprovalDto();
                        backgroundApprovalDto.setBusinessid(gradePerson.getId());
                        backgroundApprovalDto.setBusinesstype(Constants.GRADEPERSON_CENSORSTATUS);
                        backgroundApprovalDto.setIdNumber(gradePerson.getIdnum());
                        backgroundApprovalDto.setRealName(gradePerson.getName());
                        //背景筛查
                        List<BackgroundApproval> backgroundApprovals = backGroupCensorService.censor(backgroundApprovalDto);
                        gradePerson.setBackgroundApprovals(backgroundApprovals);

                    }
                    gradePersonService.updateCensorStatusForAuto(gradePersonList);
                }
            }catch (Exception e){
                logger.error(e.getMessage(),e);
                log.setExceptionMsg(e.toString());
            }
            //日志信息
            long endTime = System.currentTimeMillis();
            log.setUpdateTime(new Date());
            log.setJobName(AutoGradePersonCensorStatus.class.getName());
            log.setRunTime(new Date());
            log.setRunTimeLength((endTime - startTime) + "ms");
            jobRunLogService.insert(log);
        }
    }
}
