package com.bcxin.ars.timer.dataSync;

import com.abcxin.smart.validator.annotation.JobLogAnnotation;
import com.bcxin.ars.dao.FilerecordDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.Filerecord;
import com.bcxin.ars.model.datasync.FileRecordDetail;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.DataSyncUtil;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.HttpClientUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.File;
import java.util.Date;
import java.util.List;

/***
 * 数据同步北京内到外
 * @author  subh
 */
@Service
public class DataSyncInToOutService {
    /***
     * 日志
     */
    private static final Logger logger = LoggerFactory.getLogger(DataSyncInToOutService.class);
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private FilerecordDao fileRecordDao;
    @Autowired
    private DataSyncUtil dataSyncUtil;
    @Value("${uploadInToOutFolder}")
    private String uploadInToOutFolder;
    @Autowired
    private IdGeneratorUtil idGeneratorUtil;
    @Value("${timeFlag}")
    private String timeFlag = "";

    private boolean lock = false;

    /***
     * 北京外网地址
     */
    private String BJ_OUT_URL = "http://61.51.205.18:8804/ars-rest/uploadFileGxToBj.do";
    /***
     * 广西内网地址
     */
    private String GX_IN_URL = "http://10.148.77.214:8018/ars-rest/uploadFileBjToGx.do";

    @JobLogAnnotation(getJobClazz =DataSyncInToOutService.class)
    public void run() {

        if(lock){
            return;
        }
        lock = true;

        try {
            Config config = configUtils.getConfigByKey(Constants.POLICE);
            Config provinceConfig = configUtils.getConfigByKey(Constants.CURRENT_NATIVE);
            Config autoConfig = configUtils.getConfigByKey(Constants.AUTODATASYNC);
            if (Constants.TIMEFLAG_VALUE.equals(timeFlag)) {
                //判断是否自动同步
                if (autoConfig != null && Constants.AUTODATASYNC_YES.equals(autoConfig.getValue())) {
                    /****
                     * 判断是否为北京内网，如果是北京，则发送同步文件给广西，外网则读取同步文件即可
                     */
                    if (provinceConfig != null && Constants.BEIJING.equals(provinceConfig.getValue())) {
                        //内网生成同步文件
                        if (config != null && Constants.POLICE_IN.equals(config.getValue())) {
                            createDataFile();
                        }
                    }
                    /****
                     * 判断是否为广西外网，外网的话，发送文件给北京外网
                     */
                    if (provinceConfig != null && Constants.GUANGXI.equals(provinceConfig.getValue())) {
                        //内网生成同步文件
                        if (config != null && Constants.POLICE_OUT.equals(config.getValue())) {
                            //外网读取同步文件
                            this.readDSFileGX(uploadInToOutFolder);
                        }
                    }
                }
            }
        }finally {
            lock = false;
        }
    }
    /**
     * 内网生成数据同步文件
     */
    private void createDataFile(){
        if(Constants.DATASYNC_SWITCH_1.equals(configUtils.getValueByKey(Constants.DATASYNC_SWITCH))){
            logger.error("使用新同步摆渡");
            return;
        }
        logger.error("使用旧同步摆渡");

        //内到外生成
        /***
         * 最后同步日期
         */
        String startDate = DateUtil.getYesterday();
        Config lastDateConfig = configUtils.getConfigByKey(Constants.DATASYNC_LASTDATE);
        //配置为空或者等于当天日期
        if(lastDateConfig == null || DateUtil.convertDateToString(new Date(), DateUtil.FORMAT2).equals(lastDateConfig.getValue())){
        }else{
            startDate = lastDateConfig.getValue();
        }
        String dirDate = DateUtil.getCurrentDate();
        String filePath = uploadInToOutFolder + dirDate + File.separatorChar;
        String resultPath =  dataSyncUtil.createDSFile(startDate,filePath);
        //发送给广西
        try {
            AjaxResult ajaxResult = HttpClientUtils.FilePost(GX_IN_URL, new File(resultPath));
            if(ajaxResult.isSuccessful()){
                /**
                 * 更新"内到外最后同步日期" start
                 */
                Config updateConfig = new Config();
                updateConfig.setKey(Constants.DATASYNC_LASTDATE);
                updateConfig.setValue(DateUtil.getCurrentDate());
                configUtils.updateForKey(updateConfig);
                /**
                 * 更新"内到外最后同步日期" end
                 */
            }
        }catch (Exception e ){
            logger.error(e.getMessage(),e);
        }

    }
    /**
     * 外网读取同步数据文件
     */
    private void readDSFileGX(String filePath) {
        Date now = new Date();
        /***
         * 最后同步日期
         */
        Config lastDateConfig = configUtils.getConfigByKey(Constants.DATASYNC_LASTDATE_BJ);
        if (lastDateConfig != null) {
            //读取的时间为最后更新的时间
            String lastDate = lastDateConfig.getValue();
            List<Date> dates = DateUtil.getBetweenDates(DateUtil.convertStringToDate(lastDate), now);
            //加入当前日期
            dates.add(now);
            for (Date date : dates) {
                String dirFilePath = filePath + DateUtil.convertDateToString(date, DateUtil.FORMAT2);
                File dirFile = new File(dirFilePath);
                if (!dirFile.exists()) {
                    continue;
                }
                File[] files = dirFile.listFiles();
                //读取是否有错误
                boolean errorFlag = false;
                for (int i = 0; i < files.length; i++) {
                    File file = files[i];
                    if(file.getName().endsWith(Constants.ZIP)){
                        //判断文件是否发送过
                        List<Filerecord> fileRecordList = fileRecordDao.findByFileName(file.getName(),configUtils.isIntranet());
                        if(fileRecordList == null  || fileRecordList.size() == 0) {
                            try {
                                //发送给广西
                                AjaxResult result = HttpClientUtils.FilePost(BJ_OUT_URL, file);
                                if(result!=null && result.isSuccessful()){
                                    this.saveFileRecord(null,file.getName(),file.getAbsolutePath(),null);
                                }else{
                                    errorFlag = true;
                                }
                            } catch (Exception e) {
                                logger.error(e.getMessage(), e);
                                errorFlag = true;
                            }

                        }
                    }
                }
                //如果文件没有读取错误
                if (!errorFlag) {
                    Config updateConfig = new Config();
                    updateConfig.setKey(Constants.DATASYNC_LASTDATE_BJ);
                    updateConfig.setValue(DateUtil.getCurrentDate());
                    configUtils.updateForKey(updateConfig);
                }
            }
        }
    }

    /****
     * 保存记录文件
     * @param errorDetailList
     * @param fileName
     * @param filePath
     * @param recordSize
     */
    private void saveFileRecord(List<FileRecordDetail> errorDetailList, String fileName, String filePath, Integer recordSize){
        Filerecord fileRecord = new Filerecord();
        fileRecord.setId(idGeneratorUtil.createID());
        fileRecord.setFilename(fileName);
        fileRecord.setFilepath(filePath);
        fileRecord.setRecordsize(recordSize);
        fileRecord.setCreateTime(new Date());
        fileRecord.setUpdateflag(true);
        fileRecord.setUpdateTime(new Date());
        fileRecord.setSynchtype(Constants.DATASYNC);
        if(configUtils.isIntranet()){
            fileRecord.setUpdateflag(true);
        }
        fileRecord.setIntranet(configUtils.isIntranet());
        fileRecordDao.save(fileRecord);
    }
}
