package com.bcxin.ars.timer.dataSync;

import com.bcxin.ars.dao.datasync.DataSyncLogDao;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.datasync.DataSyncLog;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author linqinglin
 * @date 2020/12/07 0007 14:53
 */
@Service
public class DataSyncFileService {
    /***
     * 日志
     */
    private static final Logger logger = LoggerFactory.getLogger(DataSyncFileService.class);

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private DataSyncLogDao dataSyncLogDao;

    @Autowired
    private JobRunLogService jobRunLogService;

    @Autowired
    private IdGeneratorUtil idGeneratorUtil;

    private boolean lock = false;
    public void run() {
        if(lock){
            return;
        }
        lock = true;

        try {
            if (Constants.TIMEFLAG_VALUE.equals(configUtils.timeFlag)) {

                if(!Constants.DATASYNC_SWITCH_1.equals(configUtils.getValueByKey(Constants.DATASYNC_SWITCH))){
                    return;
                }

                if(!Constants.YES.equals(configUtils.getValueByKey(Constants.DATASYNC_INTERFACE_SWITCH))){
                    return;
                }

                JobRunLog log = new JobRunLog();
                log.setCreateTime(new Date());
                log.setActive(true);
                log.setUpdateBy("jobSystem");
                //开始时间
                long startTime = System.currentTimeMillis();
                try {
                    String paths = configUtils.getValueByKey(Constants.DATASYNC_FILEPATHS);
                    if(StringUtil.isNotEmpty(paths)) {
                        Config beginDateConfig = configUtils.getConfigByKey(Constants.DATASYNC_BEGINDATE);
                        Date beginDate = DateUtil.getBeginDayOfYesterday();
                        if(beginDateConfig !=null){
                            beginDate = DateUtil.convertStringToDate(beginDateConfig.getValue());
                        }
                        List<Date> dateList = DateUtil.getBetweenDates(DateUtil.getBeginDayOfYesterday(), new Date());

                        String[] pathList = paths.split("\\|\\|");
                        List<DataSyncLog> logList = new ArrayList<>();
                        DataSyncLog dataSyncLog = null;
                        for (String path : pathList) {
                            for (Date date : dateList) {
                                String dirFilePath = configUtils.baseFolder + path.split(",")[0] + DateUtil.convertDateToString(date, DateUtil.FORMAT2);
                                File dirFile = new File(dirFilePath);
                                if (!dirFile.exists()) {
                                    continue;
                                }
                                File[] files = dirFile.listFiles();
                                for (File file : files) {
                                    dataSyncLog = dataSyncLogDao.findByFilePath(file.getAbsolutePath().replaceAll("\\\\","/"));
                                    if(dataSyncLog == null){
                                        dataSyncLog = new DataSyncLog();
                                        dataSyncLog.setActive(true);
                                        dataSyncLog.setBasePath(configUtils.baseFolder);
                                        dataSyncLog.setFilePath(file.getAbsolutePath().replaceAll("\\\\","/"));
                                        dataSyncLog.setFileName(file.getName());
                                        dataSyncLog.setUrl("getResource.do?path="+dataSyncLog.getFilePath().replace(configUtils.baseFolder,""));
                                        dataSyncLog.setBusinessType(path.split(",")[1]);
                                        dataSyncLog.setDataSyncState(Constants.DATASYNCSTATE_0);
                                        dataSyncLog.setUpdateflag(true);
                                        dataSyncLog.setId(idGeneratorUtil.createID());
                                        dataSyncLog.setCreateTime(new Date());
                                        dataSyncLog.setUpdateTime(new Date());
                                        dataSyncLog.setIntranet(configUtils.isIntranet());
                                        logList.add(dataSyncLog);
                                    }
                                }
                            }
                        }
                        if(logList.size()>0){
                            int limit = 100;
                            //计算拆分次数
                            int count = new Double(Math.ceil(logList.size() * 1.0 / limit)).intValue();
                            //存放拆分数据
                            List<DataSyncLog> subList = null;
                            //循环拆分次数 生成相应数据文件
                            for (int i = 0; i < count; i++) {
                                subList = logList.stream().skip(i * limit).limit(limit).collect(Collectors.toList());
                                dataSyncLogDao.saveBatch(subList);
                            }
                        }

                        if(beginDateConfig !=null){
                            beginDateConfig.setValue(DateUtil.getYesterday());
                            beginDateConfig.setUpdateTime(new Date());
                            configUtils.updateForKey(beginDateConfig);
                        }

                    }

                }catch (Exception e){
                    logger.error(e.getMessage(),e);
                    log.setExceptionMsg(e.toString());
                }
                //日志信息
                long endTime = System.currentTimeMillis();
                log.setUpdateTime(new Date());
                log.setJobName(DataSyncFileService.class.getName());
                log.setRunTime(new Date());
                log.setRunTimeLength((endTime - startTime) + "ms");
                jobRunLogService.insert(log);
            }
        }finally {
            lock = false;
        }
    }
}
