package com.bcxin.ars.timer;

import com.bcxin.ars.dao.BJThreeCerDao;
import com.bcxin.ars.dao.PersonBaseInfoDao;
import com.bcxin.ars.model.PersonBaseInfo;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.impl.BaseService;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.GetPersonImgUtil;
import com.bcxin.ars.util.StringUtil;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 北京三证数据汇聚
 *
 * 北京市局要求
     保安员证，服务许可证，培训许可证
     3个数据结构表 ，需要您根据这个表对数据进行处理，使用网安数据交换平台，将公安网证照数据传送至政务局政务外网
     网安联系人，刘泽辰，13811670965
     建议在10月初完成
     网安是通道，政务局是最后的落地
     把需要传输的文件放在ftp上file文件夹下 网安摆渡数据到政务网
     单个文件大小最好2M以下
     ftp://10.8.6.98:21 用户名zazd 密码zazd@123
     之前保安这3证 市局给过存量数据，那给增量就行，比如数据更新，新增数据，如果有注销那也需要给下
 *
 * @author linqinglin
 * @date 2020/09/17 0017 16:41
 */
@Service
public class ThreeCerToGovService extends BaseService {

    /***
     * 日志
     */
    private static Logger logger = LoggerFactory.getLogger(ThreeCerToGovService.class);

    //private static final String hostname = "114.116.191.105" ;//FTP IP
    //
    //private static final int port = 21;//FTP 端口号
    //
    //private static final String username = "basc";//FTP 登录账号
    //
    //private static final String password = "zazd#32A13"; //FTP 登录密码
    //
    //private static final String pathname = "/data/ftptest/";//FTP 工作路径

    private static final String hostname = "14.16.176.2" ;//FTP IP

    private static final int port = 21;//FTP 端口号

    private static final String username = "basc";//FTP 登录账号

    private static final String password = "zazd#32A13"; //FTP 登录密码

    private static final String pathname = "/ars";//FTP 工作路径

    @Autowired
    PersonBaseInfoDao personBaseInfoDao;

    @Autowired
    BJThreeCerDao threeCerDao;

    @Autowired
    ConfigUtils configUtils;

    @Autowired
    IdWorker idWorker;

    @Autowired
    private JobRunLogService jobRunLogService;

    public void sendToGov() {
        if(Constants.BEIJING.equals(configUtils.getCurrentNative()) && configUtils.isIntranet() && configUtils.timeFlag.equals("true")){
            JobRunLog log = new JobRunLog();
            log.setCreateTime(new Date());
            log.setActive(true);
            log.setUpdateBy("jobSystem");
            //开始时间
            long startTime = System.currentTimeMillis();

            List<String> filePaths = new ArrayList<>();
            try{
                createBAFWGS(filePaths);
                threeCerDao.updateBAFWGSPush();
            }catch (Exception e){
                e.printStackTrace();
            }
            try{
                createBAPXDW(filePaths);
                threeCerDao.updateBAPXDWPush();
            }catch (Exception e){
                e.printStackTrace();
            }
            try{
                createBAYZGZ(filePaths);
                threeCerDao.updateBAYZGZPush();
            }catch (Exception e){
                e.printStackTrace();
            }

            //日志信息
            long endTime = System.currentTimeMillis();
            log.setUpdateTime(new Date());
            log.setJobName(ThreeCerToGovService.class.getName());
            log.setRunTime(new Date());
            log.setRunTimeLength((endTime - startTime) + "ms");
            jobRunLogService.insert(log);
        }

    }

    private void createBAFWGS(List<String> filePaths) {

        //String[] headers = {"证照名称", "许可证编号", "持有者名称", "持有者证件类型", "持有者证件号码", "颁发机关", "发证机构唯一标识", "发证机构所属行政区划代码", "颁发日期", "有效期结束日期", "许可证中间号", "住所", "法定代表人", "服务范围", "注册资本", "批准文号"};
        String[] headerClums = {"ZZMC", "ZZHM", "CYRMC", "CYRSFZJLX", "CYRSFZJHM", "FZJGMC", "FZJGZZJGDM", "FZJGSSXZQHDM", "FZRQ", "YXQJSRQ", "XKZZJH", "ZS", "FR", "FWFW", "ZCZB", "PZWH"};

        List<Map<Object, Object>> data = threeCerDao.createBAFWGS();

        //return createExcel(data, headers, headerClums, "保安服务许可证");
        writeTxt(data, filePaths, headerClums, "bafwxkz");
    }

    private void createBAPXDW(List<String> filePaths) {
        //String[] headers = {"证照名称", "许可证编号", "持有者名称", "持有者证件类型", "持有者证件号码", "颁发机关", "发证机构唯一标识", "发证机构所属行政区划代码", "颁发日期", "有效期结束日期", "许可证中间号", "法定代表人", "培训内容", "批准文号", "住所"};
        String[] headerClums = {"ZZMC", "ZZHM", "CYRMC", "CYRSFZJLX", "CYRSFZJHM", "FZJGMC", "FZJGZZJGDM", "FZJGSSXZQHDM", "FZRQ", "YXQJSRQ", "XKZZJH", "FR", "PXNR", "PZWH", "ZS"};
        List<Map<Object, Object>> data = threeCerDao.createBAPXDW();
        writeTxt(data, filePaths, headerClums, "bapxxkz");
    }

    private void createBAYZGZ(List<String> filePaths) {
        //String[] headers = {"证照名称", "许可证编号", "持有者名称", "持有者证件类型", "持有者证件号码", "颁发机关", "发证机构唯一标识", "发证机构所属行政区划代码", "颁发日期", "有效期结束日期", "民族", "出生日期", "住址", "照片"};
        String[] headerClums = {"ZZMC", "ZZHM", "CYRMC", "CYRSFZJLX", "CYRSFZJHM", "FZJGMC", "FZJGZZJGDM", "FZJGSSXZQHDM", "FZRQ", "YXQJSRQ", "MZ", "CSRQ", "ZZ", "ZP"};

        List<Map<Object, Object>> data = threeCerDao.createBAYZGZ();
        if(data.size() <1){
            logger.error("没有需要同步的保安员证");
            return;
        }
        String idnum = null;

        //根据数据数量情况，切分不同的大小
        int limit = 40;
        String threeCerLimit = configUtils.getValueByKey(Constants.THREECERLIMIT);
        try{
            limit = Integer.parseInt(threeCerLimit);
        }catch (Exception e){

        }
        //计算拆分次数
        int count = new Double(Math.ceil(data.size() * 1.0 / limit)).intValue();
        //存放拆分数据
        List<Map<Object, Object>> subList = null;
        //循环拆分次数 生成相应数据文件
        for (int i = 0; i < count; i++) {
            subList = data.stream().skip(i * limit).limit(limit).collect(Collectors.toList());
            for (Map<Object, Object> map : subList) {
                idnum = map.get("CYRSFZJHM").toString();
                PersonBaseInfo personBaseInfo = personBaseInfoDao.findByIdNum(idnum);
                if(personBaseInfo != null && StringUtil.isNotEmpty(personBaseInfo.getImgPath())){
                    try {
                        map.put("ZP", GetPersonImgUtil.GetImageStr(getResourcePath(personBaseInfo.getImgPath())).replaceAll("\n","").replaceAll("\r","").replaceAll("\r\n",""));
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            writeTxt(subList, filePaths, headerClums, "zhrmghgbayz");
        }
    }

    public boolean uploadFile(List<String> filePaths){
        boolean flag = false;
        FTPClient ftpClient = new FTPClient();
        //设置超时
        ftpClient.setConnectTimeout(60*60*1000);
        //设置编码
        ftpClient.setControlEncoding("UTF-8");
        try {
            //连接FTP服务器
            ftpClient.connect(hostname, port);
            //登录FTP服务器
            ftpClient.login(username, password);
            //是否成功登录FTP服务器
            int replyCode = ftpClient.getReplyCode();
            if(!FTPReply.isPositiveCompletion(replyCode)){
                logger.error(hostname + "ftp 连接失败");
                return flag;
            }
            logger.error("===========登录FTP成功了==========");
            ftpClient.setFileType(FTPClient.BINARY_FILE_TYPE);
            //切换路径 创建路径
            //ftpClient.makeDirectory(pathname);
            ftpClient.changeWorkingDirectory(pathname);
            //被动模式
            ftpClient.enterLocalPassiveMode();
            //设置缓冲
            ftpClient.setBufferSize(1024 * 1024 * 20);
            //保持连接
            ftpClient.setKeepAlive(true);
            File file = null;
            String fileName = null;
            FileInputStream inputStream = null;
            for (String filePath : filePaths) {
                try{
                    file = new File(filePath);
                    fileName = file.getName();
                    inputStream = new FileInputStream(file);
                    boolean result = ftpClient.storeFile(new String(fileName.getBytes("utf-8"),"iso-8859-1"), inputStream);
                    if(result){
                        logger.error(fileName+"===========创建文件成功==============");
                    }else{
                        logger.error(fileName+"===========创建文件失败==============");
                    }
                    file.delete();
                }catch (Exception e){
                    e.printStackTrace();
                }finally {
                    inputStream.close();
                }
            }

            ftpClient.logout();
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        } finally{
            if(ftpClient.isConnected()){
                try {
                    ftpClient.disconnect();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return flag;
    }

    private void writeTxt(List<Map<Object, Object>> data, List<String> filePaths, String[] headerClums, String fileName) {

        if(data == null || data.size() <1){
            return;
        }
        fileName = fileName + "_" + idWorker.nextId() + ".txt";
        String filePath = "";

        filePath = configUtils.tempfolder + "/" + DateUtil.getCurrentDate() + "/";
        File dir = new File(filePath);
        if (!dir.exists()) {
            dir.mkdirs();
        }

        filePath = filePath + fileName;

        try {
            //将写入转化为流的形式
            BufferedWriter bw = new BufferedWriter(new FileWriter(filePath));
            StringBuilder lineValue= null;
            for (int i = 0; i < data.size(); i++) {
                lineValue= new StringBuilder();

                if(i >0){
                    bw.newLine();  //换行用
                }
                for (int j = 0; j < headerClums.length; j++) {
                    if (data.get(i).get(headerClums[j]) != null) {
                        lineValue.append(String.valueOf(data.get(i).get(headerClums[j]))+"|");
                    } else {
                        lineValue.append("|");
                    }
                }
                bw.write(lineValue.toString().substring(0,lineValue.toString().length()-1));
            }

            bw.close();
            filePaths.add(filePath);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * 上传文件
     * @param fileName 上传到FTP服务器后的文件名称
     * @param inputStream 输入文件流
     * @return
     */
    public boolean uploadFile(String fileName,FileInputStream inputStream){

        boolean flag = false;
        FTPClient ftpClient = new FTPClient();
        //设置超时
        ftpClient.setConnectTimeout(60*60*1000);
        //设置编码
        ftpClient.setControlEncoding("UTF-8");
        try {
            //连接FTP服务器
            ftpClient.connect(hostname, port);
            //登录FTP服务器
            ftpClient.login(username, password);
            //是否成功登录FTP服务器
            int replyCode = ftpClient.getReplyCode();
            if(!FTPReply.isPositiveCompletion(replyCode)){
                logger.error(hostname + "ftp 连接失败");
                return flag;
            }
            logger.error("===========登录FTP成功了==========");
            ftpClient.setFileType(FTPClient.BINARY_FILE_TYPE);
            //切换路径 创建路径
            //ftpClient.makeDirectory(pathname);
            ftpClient.changeWorkingDirectory(pathname);
            //被动模式
            ftpClient.enterLocalPassiveMode();
            //设置缓冲
            ftpClient.setBufferSize(1024 * 1024 * 20);
            //保持连接
            ftpClient.setKeepAlive(true);
            boolean result = ftpClient.storeFile(new String(fileName.getBytes("utf-8"),"iso-8859-1"), inputStream);
            if(result){
                logger.error(fileName+"===========创建文件成功==============");
            }else{
                logger.error(fileName+"===========创建文件失败==============");
            }
            inputStream.close();
            ftpClient.logout();
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        } finally{
            if(ftpClient.isConnected()){
                try {
                    ftpClient.disconnect();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return flag;

    }

    private String createExcel(List<Map<Object, Object>> data, String[] headers, String[] headerClums, String fileName) {
        String filePath = "";
        try {
            //HSSF --> XSSF ，HSSFSheet -->Sheet, HSSFRow -->Row, HSSFCell --> Cell
            if (data.size() > 0) {
                XSSFWorkbook wb = new XSSFWorkbook();
                Sheet sheet = wb.createSheet(fileName);  //创建table工作薄
                Row row;
                Cell cell;

                row = sheet.createRow(0);//创建表格行
                for (int i = 0; i < headers.length; i++) {
                    cell = row.createCell(i);//根据表格行创建单元格
                    cell.setCellType(Cell.CELL_TYPE_STRING);
                    cell.setCellValue(headers[i]);
                }

                for (int i = 1; i <= data.size(); i++) {
                    row = sheet.createRow(i);//创建表格行
                    for (int j = 0; j < headerClums.length; j++) {
                        cell = row.createCell(j);//根据表格行创建单元格
                        cell.setCellType(Cell.CELL_TYPE_STRING);
                        if (data.get(i - 1).get(headerClums[j]) != null) {
                            cell.setCellValue(String.valueOf(data.get(i - 1).get(headerClums[j])));
                        } else {
                            cell.setCellValue("");
                        }
                    }
                }

                filePath = configUtils.tempfolder + "/" + DateUtil.getCurrentDate() + "/";

                File dir = new File(filePath);
                if (!dir.exists()) {
                    dir.mkdirs();
                }

                filePath = filePath + fileName + "_" + DateUtil.getCurrentDateTime(DateUtil.FORMAT8) + ".xlsx";
                wb.write(new FileOutputStream(filePath));
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        return filePath;
    }
}
