package com.bcxin.ars.timer;

import com.alibaba.fastjson.JSONArray;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.GradeCertificateToSAASDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.certificate.GradeCertificate;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.certificate.GradeCertificateService;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.SAASInterfaceUtil;
import com.bcxin.ars.timer.personcertificate.AutoUpdateCensorStatus;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 保安员等级证推送saas
 * @author linqinglin
 * @date 2019/11/21 0021 14:21
 */
@Service
public class GradeCertificateToSAASService {


    private Logger logger = LoggerFactory.getLogger(GradeCertificateToSAASService.class);

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private GradeCertificateService gradeCertificateService;
    @Value("${timeFlag}")
    private String timeFlag = "";
    @Autowired
    private SAASInterfaceUtil saasInterfaceUtil;

    @Autowired
    private JobRunLogService jobRunLogService;
    private boolean lock = false;
    public void sendToSAAS(){
        if(!configUtils.isIntranet() && timeFlag.equals("true")){
            if(lock){
                return;
            }
            lock = true;
                JobRunLog log = new JobRunLog();
                log.setCreateTime(new Date());
                log.setActive(true);
                log.setUpdateBy("jobSystem");
                //开始时间
                long startTime = System.currentTimeMillis();
            try {
                List<GradeCertificate> certificateList = gradeCertificateService.findUnPushToSAAS();
                if (certificateList != null && certificateList.size() > 0) {
                        List<GradeCertificateToSAASDto> dtoList = new ArrayList<>();
                        for (GradeCertificate gradeCertificate : certificateList) {
                            GradeCertificateToSAASDto certificateDto = new GradeCertificateToSAASDto();
                            certificateDto.setPerId(gradeCertificate.getPersonId());
                            certificateDto.setCerNo(gradeCertificate.getCertificateNo());
                            certificateDto.setPerCerLevel("0100010" + gradeCertificate.getAppraisalGrade());
                            certificateDto.setLicenceDate(gradeCertificate.getAppraisalTime() == null ? "" : DateUtil.convertDateToString(gradeCertificate.getAppraisalTime(), DateUtil.FORMAT2));
                            certificateDto.setTrainOrganName(gradeCertificate.getTrainOrgName());
                            dtoList.add(certificateDto);
                        }

                        Map<String, Object> paramMap = new HashMap();
                        paramMap.put("bayDJZListStr", JSONArray.toJSONString(dtoList));

                        AjaxResult result = saasInterfaceUtil.callInterface(Constants.SAAS_GRADECERTIFICATE_URL, paramMap);

                        if (!result.isSuccessful()) {
                            throw new ArsException("保安员等级证推送saas失败" + result.getMsg());
                        }

                        Map<Long, GradeCertificateToSAASDto> failMap = new HashMap();

                        if (result.getData() != null) {
                            List<GradeCertificateToSAASDto> failList = JSONArray.parseArray(JSONArray.toJSONString(result.getData()), GradeCertificateToSAASDto.class);
                            failMap = failList.stream().collect(Collectors.toMap(GradeCertificateToSAASDto::getPerId, Function.identity()));
                        }

                        List<GradeCertificate> successList = new ArrayList<>();
                        for (GradeCertificate gradeCertificate : certificateList) {
                            if (failMap.get(gradeCertificate.getPersonId()) == null) {
                                successList.add(gradeCertificate);
                            }
                        }
                        /*判断是否有更新*/
                        if (successList.size() > 0) {
                            //批量更新推送状态
                            gradeCertificateService.batchUpdatePushState(successList);
                            //批量更新人员等级证信息
                            gradeCertificateService.batchUpdatePersonGradeCertificate(successList);
                        }
                }
            }catch (Exception e ){
                //异常信息存储
                logger.error(e.getMessage(),e);
                log.setExceptionMsg(e.getMessage());
            }finally {
                lock = false;
            }
            //日志信息
            long endTime = System.currentTimeMillis();
            log.setUpdateTime(new Date());
            log.setJobName(GradeCertificateToSAASService.class.getName());
            log.setRunTime(new Date());
            log.setRunTimeLength((endTime - startTime) + "ms");
            jobRunLogService.insert(log);
        }
    }
}
