/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.timer.personAdapt;

import com.bcxin.ars.dao.sb.PersonAdaptDao;
import com.bcxin.ars.dto.sb.BackgroundApprovalDto;
import com.bcxin.ars.model.sb.BackgroundApproval;
import com.bcxin.ars.model.sb.PersonAdapt;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.bean.factory.BackGroupCensorServiceBeanFactory;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.webservice.BackGroupCensorService;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PersonAdaptCensorStatusService {
    private static final Logger logger = LoggerFactory.getLogger(PersonAdaptCensorStatusService.class);
    @Autowired
    private PersonAdaptDao personAdaptDao;
    @Value(value="${timeFlag}")
    private String timeFlag = "";
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private JobRunLogService jobRunLogService;
    private static BackGroupCensorService backGroupCensorService;

    private void getBackGroupCensorService() {
        if (backGroupCensorService == null) {
            backGroupCensorService = BackGroupCensorServiceBeanFactory.getBackGroupCensorServiceBean();
        }
    }

    public void run() {
        if (this.configUtils.isIntranet() && this.timeFlag.equals("true")) {
            JobRunLog log = new JobRunLog();
            log.setCreateTime(new Date());
            log.setActive(Boolean.valueOf(true));
            log.setUpdateBy("jobSystem");
            long startTime = System.currentTimeMillis();
            try {
                this.getBackGroupCensorService();
                List personList = this.personAdaptDao.findNoCensorStatus();
                if (personList != null && personList.size() > 0) {
                    for (PersonAdapt personAdapt : personList) {
                        this.getCensorStatus(personAdapt);
                    }
                    this.personAdaptDao.saveBatch(personList);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                log.setExceptionMsg(e.toString());
            }
            long endTime = System.currentTimeMillis();
            log.setUpdateTime(new Date());
            log.setJobName(PersonAdaptCensorStatusService.class.getName());
            log.setRunTime(new Date());
            log.setRunTimeLength(endTime - startTime + "ms");
            this.jobRunLogService.insert(log);
        }
    }

    private void getCensorStatus(PersonAdapt personAdapt) {
        try {
            Boolean pass = true;
            Date now = new Date();
            BackgroundApprovalDto backgroundApprovalDto = new BackgroundApprovalDto();
            backgroundApprovalDto.setBusinessid(personAdapt.getId());
            backgroundApprovalDto.setBusinesstype("25");
            backgroundApprovalDto.setIdNumber(personAdapt.getIdNum());
            backgroundApprovalDto.setRealName(personAdapt.getName());
            List list = backGroupCensorService.censor(backgroundApprovalDto);
            String approvalReason = null;
            if (list == null || list.size() == 0) {
                return;
            }
            for (BackgroundApproval backgroundApproval : list) {
                if (!"004".equals(backgroundApproval.getApprovalstate())) continue;
                approvalReason = "1".equals(backgroundApproval.getLibraryType()) ? "\u80cc\u666f\u7b5b\u67e5\u4e0d\u901a\u8fc7\uff0c\u539f\u56e0\uff1a" + backgroundApproval.getApprovalreason() : "\u80cc\u666f\u7b5b\u67e5\u4e0d\u901a\u8fc7";
                pass = false;
                break;
            }
            personAdapt.setApprovalReason(approvalReason);
            if (pass.booleanValue()) {
                personAdapt.setCensorStatus("1");
                personAdapt.setApprovalState("0");
            } else {
                personAdapt.setCensorStatus("2");
                personAdapt.setApprovalState("0");
            }
            personAdapt.setUpdateTime(now);
            personAdapt.setUpdateflag(Boolean.valueOf(true));
        }
        catch (Exception e) {
            logger.error("\u5f02\u5e38" + personAdapt.getIdNum());
        }
    }
}

