package com.bcxin.ars.timer.problemPerson;

import cn.hutool.core.thread.ThreadUtil;
import com.bcxin.ars.dto.sb.BackgroundApprovalDto;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.sb.BackgroundApproval;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.service.bean.factory.BackGroupCensorServiceBeanFactory;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.webservice.BackGroupCensorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;

/**
 * 前科问题人员定时器
 * @author subh
 */
@Service
public class ProblemPersonCriminalServiceJob {
    /***
     * 日志
     */
    private static final Logger logger = LoggerFactory.getLogger(ProblemPersonCriminalServiceJob.class);
    /***
     * 人员
     */
    @Autowired
    private SecurityPersonService securityPersonService;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private JobRunLogService jobRunLogService;
    private static BackGroupCensorService backGroupCensorService;
    @Value("${ZAFLAG}")
    private String ZAFLAG;
    private boolean lock = false;
    public void run() {
        if(lock){
            return;
        }
        lock = true;
        try{
            String bg_switch = configUtils.getValueByKey("bg_switch");
            if("0".equals(bg_switch)){
                return;
            }

            if(backGroupCensorService == null){
                backGroupCensorService = BackGroupCensorServiceBeanFactory.getBackGroupCensorServiceBean();
            }
            //判断是否为公安内网，只有内网才背景筛查
            if(configUtils.isIntranet() && ZAFLAG!=null && Constants.ZAFLAG_YES.equals(ZAFLAG)) {
                JobRunLog log = new JobRunLog();
                log.setCreateTime(new Date());
                log.setActive(true);
                log.setUpdateBy("jobSystem");
                //开始时间
                long startTime = System.currentTimeMillis();
                try {
                    //查询所有人员
                    List<SecurityPerson> personList = securityPersonService.findNoPassCensorStatus();
                    if (personList.size() > 0) {
                        //根据数据数量情况，切分不同的大小
                        int limit = 100;
                        //计算拆分次数
                        int count = new Double(Math.ceil(personList.size() * 1.0 / limit)).intValue();
                        //存放拆分数据
                        List<SecurityPerson> subList = null;
                        //循环拆分次数 生成相应数据文件
                        for (int i = 0; i < count; i++) {
                            subList = personList.stream().skip(i * limit).limit(limit).collect(Collectors.toList());

                            CountDownLatch countDownLatch = ThreadUtil.newCountDownLatch(subList.size());
                            ThreadPoolExecutor threadPoolExecutor = ThreadUtil.newExecutor(15, 15);
                            //先背景筛查
                            for (SecurityPerson securityPerson : subList) {
                                threadPoolExecutor.execute(new Runnable() {
                                    @Override
                                    public void run() {
                                        try {
                                            BackgroundApprovalDto dto = new BackgroundApprovalDto();
                                            //身份证号
                                            dto.setIdNumber(securityPerson.getIdNumber());
                                            //姓名
                                            dto.setRealName(securityPerson.getRealName());
                                            //主键
                                            dto.setBusinessid(securityPerson.getId());
                                            //问题人员
                                            dto.setBusinesstype(Constants.BAY_FZR);
                                            //背景筛查
                                            List<BackgroundApproval> backgroundApprovals = backGroupCensorService.censorFromBase(dto,false);
                                            securityPerson.setBackgroundApprovals(backgroundApprovals);
                                        } catch (Exception e) {
                                            logger.error(e.getMessage(), e);
                                        } finally {
                                            countDownLatch.countDown();
                                        }
                                    }
                                });
                            }
                            try {
                                //线程等待全部完成
                                countDownLatch.await();
                            } catch (InterruptedException e) {
                                logger.error(e.getMessage(), e);
                                Thread.currentThread().interrupt();
                            }finally {
                                threadPoolExecutor.shutdown();
                            }
                            CountDownLatch countDownLatch1 = ThreadUtil.newCountDownLatch(subList.size());
                            ThreadPoolExecutor threadPoolExecutor1 = ThreadUtil.newExecutor(30, 30);
                            for (SecurityPerson securityPerson : subList) {
                                threadPoolExecutor1.execute(new Runnable() {
                                    @Override
                                    public void run() {
                                        try {
                                            backGroupCensorService.censorSaveProblemPersonNoPassCensorStatus(securityPerson, securityPerson.getBackgroundApprovals());
                                        } catch (Exception e) {
                                            logger.error(e.getMessage(), e);
                                        } finally {
                                            countDownLatch1.countDown();
                                        }
                                    }
                                });
                            }
                            try {
                                //线程等待全部完成
                                countDownLatch1.await();
                            } catch (InterruptedException e) {
                                logger.error(e.getMessage(), e);
                                Thread.currentThread().interrupt();
                            }finally {
                                threadPoolExecutor1.shutdown();
                            }
                        }
                    }
                }catch (Exception e){
                    logger.error(e.getMessage(),e);
                    log.setExceptionMsg(e.toString());
                }
                //日志信息
                long endTime = System.currentTimeMillis();
                log.setUpdateTime(new Date());
                log.setJobName(ProblemPersonCriminalServiceJob.class.getName());
                log.setRunTime(new Date());
                log.setRunTimeLength((endTime - startTime) + "ms");
                jobRunLogService.insert(log);
            }
        }finally {
            lock = false;
        }
    }
}
