package com.bcxin.ars.timer.problemPerson;

import cn.hutool.core.thread.ThreadUtil;
import com.abcxin.smart.validator.annotation.JobLogAnnotation;
import com.bcxin.ars.dao.ProblemLogDao;
import com.bcxin.ars.dao.sb.InvestorDao;
import com.bcxin.ars.dao.sb.ManagementInfoDao;
import com.bcxin.ars.dto.sb.BackgroundApprovalDto;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.ProblemLog;
import com.bcxin.ars.model.sb.BackgroundApproval;
import com.bcxin.ars.service.bean.factory.BackGroupCensorServiceBeanFactory;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.approval.ApprovalState;
import com.bcxin.ars.webservice.BackGroupCensorService;
import com.bcxin.ars.webservice.util.BJProblemDetailUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;

/**
 * 管理层、股东 背景筛查定时器
 * @author subh
 */
@Service
public class ManageInfoProblemServiceJob {
    private Logger logger = LoggerFactory.getLogger(ManageInfoProblemServiceJob.class);

    @Autowired
    private ManagementInfoDao managementInfoDao;

    @Autowired
    private InvestorDao investorDao;

    @Autowired
    private ProblemLogDao problemLogDao;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private static BackGroupCensorService backGroupCensorService;

    @Autowired
    private BJProblemDetailUtil bjProblemDetailUtil;

    @Value("${ZAFLAG}")
    private String ZAFLAG;

    @JobLogAnnotation(getJobClazz = ManageInfoProblemServiceJob.class)
    public synchronized void run() {

        try{
            if (backGroupCensorService == null) {
                backGroupCensorService = BackGroupCensorServiceBeanFactory.getBackGroupCensorServiceBean();
            }
            //判断是否为公安内网，只有内网才背景筛查
            Config config = configUtils.getConfigByKey(Constants.POLICE);
            if (Constants.ISPOLICE_YES.equals(config.getValue()) && ZAFLAG != null && Constants.ZAFLAG_YES.equals(ZAFLAG)) {
                try {
                    //查询所有人员
                    List<ProblemLog> list = problemLogDao.findUnCensor();
                    CountDownLatch countDownLatch = ThreadUtil.newCountDownLatch(list.size());
                    ThreadPoolExecutor threadPoolExecutor = ThreadUtil.newExecutor(15, 15);
                    //先背景筛查
                    for (ProblemLog problemLog : list) {
                        threadPoolExecutor.execute(new Runnable() {
                            @Override
                            public void run() {
                                try {
                                    BackgroundApprovalDto dto = new BackgroundApprovalDto();
                                    //身份证号
                                    dto.setIdNumber(problemLog.getIdnum());
                                    //姓名
                                    dto.setRealName(problemLog.getName());
                                    //主键
                                    dto.setBusinessid(problemLog.getId());
                                    //问题人员
                                    dto.setBusinesstype(Constants.BAY_FZR);
                                    //背景筛查
                                    List<BackgroundApproval> backgroundApprovals = backGroupCensorService.censor(dto);
                                    problemLog.setBackgroundApprovals(backgroundApprovals);
                                    //背景筛查无异常
                                    problemLog.setCensorStatusError(false);
                                } catch (Exception e) {
                                    //背景筛查异常
                                    problemLog.setCensorStatusError(true);
                                    logger.error(e.getMessage(), e);
                                } finally {
                                    countDownLatch.countDown();
                                }
                            }
                        });
                    }
                    try {
                        //线程等待全部完成
                        countDownLatch.await();
                    } catch (InterruptedException e) {
                        logger.error(e.getMessage(), e);
						 e.printStackTrace();
                        Thread.currentThread().interrupt();
                    }finally {
                        threadPoolExecutor.shutdown();
                    }
                    List<ProblemLog> successList = new CopyOnWriteArrayList<>();
                    CountDownLatch countDownLatch1 = ThreadUtil.newCountDownLatch(list.size());
                    ThreadPoolExecutor threadPoolExecutor1 = ThreadUtil.newExecutor(15, 15);
                    for (ProblemLog problemLog : list) {
                        threadPoolExecutor1.execute(new Runnable() {
                            @Override
                            public void run() {
                                try {
                                    Boolean result = false;
                                    StringBuffer problemtype =  new StringBuffer();
                                    //循环背景筛查记录，检查是否有不通过
                                    if(problemLog.getBackgroundApprovals() !=null && problemLog.getBackgroundApprovals().size() > 0) {
                                        for (BackgroundApproval backgroundApproval : problemLog.getBackgroundApprovals()) {
                                            if (ApprovalState.SHBTG.equals(backgroundApproval.getApprovalstate())) {
                                                problemtype.append(backgroundApproval.getApprovalreason()).append(Constants.COMMA);
                                                result = true;
                                            }
                                        }
                                    }

                                    //判断是否人口库异常
                                    if(!problemLog.getCensorStatusError()) {
                                        if (result) {
                                            //去悼最后一位
                                            problemtype.deleteCharAt(problemtype.length() - 1);
                                            problemLog.setProblem(problemtype.toString());
                                            //信息有误
                                            if (Constants.LIBRARYTYPE_CZ_FAIL_MESSAGE.equals(problemtype.toString()) || Constants.LIBRARYTYPE_CZ_FAIL.equals(problemtype.toString())) {
                                                problemLog.setProblemType(Constants.PERSONTYPE_INFO);
                                                //在逃
                                            } else if (problemtype.toString().indexOf(Constants.LIBRARYTYPE_DT_QUERY) >= 0) {
                                                problemLog.setProblemType(Constants.PERSONTYPE_LARGE);
                                                //前科
                                            } else {
                                                problemLog.setProblemType(Constants.PERSONTYPE_CRIMINAL);
                                            }
                                        }
                                        if(!Constants.PERSONTYPE_INFO.equals(problemLog.getProblemType())) {
                                            problemLog.setContent(bjProblemDetailUtil.checkPersonInfo(problemLog.getIdnum()));
                                        }
                                        successList.add(problemLog);
                                    }
                                } catch (Exception e) {
                                    logger.error(e.getMessage(), e);
                                    e.printStackTrace();
                                } finally {
                                    countDownLatch1.countDown();
                                }
                            }
                        });
                    }
                    try {
                        //线程等待全部完成
                        countDownLatch1.await();
                    } catch (InterruptedException e) {
                        logger.error(e.getMessage(), e);
                    }
                    threadPoolExecutor1.shutdown();
                    //批量更新人员背景筛查状态
                    if (successList != null && successList.size() > 0) {
                        problemLogDao.saveBatch(successList);
                    }
                } catch (Exception e) {
                    logger.error(e.getMessage(), e);
                    e.printStackTrace();
                }
            }
        }finally {

        }
    }
}
