package com.bcxin.ars.timer.police;

import cn.hutool.core.thread.ThreadUtil;
import com.abcxin.smart.validator.annotation.JobLogAnnotation;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.sb.BackgroundApproval;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.service.bean.factory.BackGroupCensorServiceBeanFactory;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.approval.ApprovalState;
import com.bcxin.ars.util.spring.util.SpringUtils;
import com.bcxin.ars.webservice.BackGroupCensorService;
import com.bcxin.ars.webservice.police.SecurityInterfaceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;

/**
 * 问题人员定时器
 * @author subh
 */
@Service
public class ProblemPersonJob {
    private Logger logger = LoggerFactory.getLogger(ProblemPersonJob.class);
    /***
     * 人员
     */
    @Autowired
    private SecurityPersonService securityPersonService;
    @Autowired
    private ConfigUtils configUtils;
    private static BackGroupCensorService backGroupCensorService;
    @Value("${ZAFLAG}")
    private String ZAFLAG;

    private boolean lock = false;

    @JobLogAnnotation(getJobClazz = ProblemPersonJob.class)
    public void run() {
        if(lock){
            return;
        }
        lock = true;
        try{
            if(!Constants.SHANGXI.equals(configUtils.getCurrentNative())){
                return;
            }
            //判断是否为公安内网，只有内网才背景筛查
            if (configUtils.isIntranet() && ZAFLAG != null && Constants.ZAFLAG_YES.equals(ZAFLAG)) {
                try {
                    if (backGroupCensorService == null) {
                        backGroupCensorService = BackGroupCensorServiceBeanFactory.getBackGroupCensorServiceBean();
                    }
                    //查询所有人员
                    List<SecurityPerson> personList = securityPersonService.findUnCensor();
                    if (personList.size() > 0) {
                        SecurityInterfaceService securityInterfaceService = SpringUtils.getBean("securityInterfaceService_"+configUtils.getCurrentProvince());
                        //根据数据数量情况，切分不同的大小
                        int limit = 5;
                        //计算拆分次数
                        int count = new Double(Math.ceil(personList.size() * 1.0 / limit)).intValue();
                        //存放拆分数据
                        List<SecurityPerson> subList = null;
                        //循环拆分次数 生成相应数据文件
                        for (int i = 0; i < count; i++) {
                            subList = personList.stream().skip(i * limit).limit(limit).collect(Collectors.toList());
                            //先背景筛查
                            securityInterfaceService.censorNewPerson(subList);

                            List<SecurityPerson> successPersonList = new CopyOnWriteArrayList<>();
                            CountDownLatch countDownLatch1 = ThreadUtil.newCountDownLatch(subList.size());
                            ThreadPoolExecutor threadPoolExecutor1 = ThreadUtil.newExecutor(30, 30);
                            for (SecurityPerson securityPerson : subList) {
                                threadPoolExecutor1.execute(new Runnable() {
                                    @Override
                                    public void run() {
                                        try {
                                            Boolean result = false;
                                            //循环背景筛查记录，检查是否有不通过
                                            if (securityPerson.getBackgroundApprovals() != null && securityPerson.getBackgroundApprovals().size() > 0) {
                                                for (BackgroundApproval backgroundApproval : securityPerson.getBackgroundApprovals()) {
                                                    if (ApprovalState.SHBTG.equals(backgroundApproval.getApprovalstate())) {
                                                        result = true;
                                                    }
                                                }
                                            }
                                            //判断是否人口库异常
                                            if (!securityPerson.getCensorStatusError()) {
                                                if (result) {
                                                    backGroupCensorService.censorSaveProblemPerson(securityPerson, securityPerson.getBackgroundApprovals());
                                                } else {
                                                    successPersonList.add(securityPerson);
                                                }
                                            }
                                        } catch (Exception e) {
                                            logger.error(e.getMessage(), e);
                                            e.printStackTrace();
                                        } finally {
                                            countDownLatch1.countDown();
                                        }
                                    }
                                });
                            }
                            try {
                                //线程等待全部完成
                                countDownLatch1.await();
                            } catch (InterruptedException e) {
                                logger.error(e.getMessage(), e);
                            }
                            threadPoolExecutor1.shutdown();
                            //批量更新人员背景筛查状态
                            if (successPersonList != null && successPersonList.size() > 0) {
                                securityPersonService.updateCensorStatusList(successPersonList);
                            }
                        }
                    }
                } catch (Exception e) {
                    logger.error(e.getMessage(), e);
                    e.printStackTrace();
                }
            }
        }finally {
            lock = false;
        }
    }
}


