package com.bcxin.ars.timer.personcertificate;

import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.ConfigService;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.zw.PctinfoService;
import com.bcxin.ars.util.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/***
 * 自动获取指纹定时器
 * @author subh
 */
@Service
public class AutoUpdateFingerprint {
	/***
	 * 日志
	 */
	private Logger logger = LoggerFactory.getLogger(AutoUpdateFingerprint.class);

	@Autowired
	private PctinfoService pctinfoService;
	@Value("${timeFlag}")
	private String timeFlag = "";
	@Autowired
	private ConfigService configService;
    @Autowired
    private JobRunLogService jobRunLogService;
	private boolean lock = false;

	public void autoUpdateFingerprintMethod() {

        //开始时间
        long startTime = System.currentTimeMillis();
		Config config = configService.findByKey(Constants.POLICE);
		//是否需要指纹
		Config fingerConfig =  configService.findByKey(Constants.IS_SHOW_FINGERPRINT);
		if (config.getValue().equals(Constants.POLICE_IN) && timeFlag.equals(Constants.TIMEFLAG_VALUE) && Constants.IS_SHOW_FINGERPRINT_YES.equals(fingerConfig.getValue())) {
            JobRunLog log = new JobRunLog();
            log.setCreateTime(new Date());
            log.setActive(true);
            log.setUpdateBy("jobSystem");
            try {
                //获取没有指纹的人员列表
                List<Personcertificate> personcertificateList = pctinfoService.findNofinger();
                autoUpdateFinger(personcertificateList);
            }catch (Exception e){
                logger.error(e.getMessage(),e);
                log.setExceptionMsg(e.toString());
            }
            //日志信息
            long endTime = System.currentTimeMillis();
            log.setUpdateTime(new Date());
            log.setJobName(AutoUpdateFingerprint.class.getName());
            log.setRunTime(new Date());
            log.setRunTimeLength((endTime - startTime) + "ms");
            jobRunLogService.insert(log);
        }

	}

	private void autoUpdateFinger(List<Personcertificate> personcertificateList){
		if (personcertificateList != null && personcertificateList.size() > 0) {
		    for (Personcertificate personcertificate : personcertificateList) {
				try {
		        	pctinfoService.autoUpdateFingerprint(personcertificate);
				}catch (Exception e){
					logger.error(e.getMessage(),e);
				}
		    }
		}
	}
}
