package com.bcxin.ars.timer.person;

import cn.hutool.core.thread.ThreadUtil;
import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dao.UserDaoAop;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.impl.BaseService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;

/**
 * @author linqinglin
 * @date 2019/10/22 0022 15:29
 */
@Service
public class RepairErrorPhotoForUser extends BaseService {

    Logger logger = LoggerFactory.getLogger(RepairErrorPhotoForUser.class);

    @Autowired
    private UserDao userDao;

    @Autowired
    private UserDaoAop userDaoAop;


    public synchronized void repairErrorPhoto(){

        List<User> userList = userDao.findErrorPhoto();

        if(userList.size() > 0){

            CountDownLatch workCount = ThreadUtil.newCountDownLatch(userList.size());
            ThreadPoolExecutor threadPoolExecutor = ThreadUtil.newExecutor(15, 15);
            userList.forEach(user->{
                threadPoolExecutor.execute(new Runnable(){
                    @Override
                    public void run() {
                        try {
                            user.setPhoto(getPhotoPath(user.getPhoto()));
                            user.setUpdateTime(new Date());
                        } catch (Exception e) {
                            logger.error(e.getMessage(),e);
                            e.printStackTrace();
                        } finally {
                            workCount.countDown();
                        }
                    }
                });
            });

            try {
                //线程等待全部完成
                workCount.await();
            } catch (InterruptedException e) {
                logger.error(e.getMessage(),e);
                Thread.currentThread().interrupt();
            }finally {
                threadPoolExecutor.shutdown();
            }

            userDaoAop.saveBatch(userList);
        }



    }
}
