package com.bcxin.ars.timer.person;

import com.abcxin.smart.validator.annotation.JobLogAnnotation;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.PersonBaseInfo;
import com.bcxin.ars.service.PersonBaseInfoService;
import com.bcxin.ars.service.bean.factory.BackGroupCensorServiceBeanFactory;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.ImgUtils;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.webservice.BackGroupCensorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.File;
import java.util.Date;
import java.util.List;

/**
 * 自动获取照片信息
 * @author linqinglin
 * @date 2019/09/19 0019 13:46
 */
@Service
public class AutoGetPersonBaseInfo {

    private Logger logger = LoggerFactory.getLogger(AutoGetPersonBaseInfo.class);

    @Autowired
    private PersonBaseInfoService personBaseInfoService;

    private static BackGroupCensorService backGroupCensorService;

    @Autowired
    private ConfigUtils configUtils;

    @Value("${timeFlag}")
    private String timeFlag = "";

    @Value("${base-folder}")
    private String baseFolder;

    @Value("${personImg-folder}")
    private String personImgPath = "";

    /***
     * 先获取背景筛查实现类对
     */
    private void getBackGroupCensorService(){
        if(backGroupCensorService == null){
            backGroupCensorService = BackGroupCensorServiceBeanFactory.getBackGroupCensorServiceBean();
        }
    }
    private boolean lock = false;


    @JobLogAnnotation(getJobClazz = AutoGetPersonBaseInfo.class)
    public void run() {
        if(lock){
            return;
        }
        lock = true;
        try{
            logger.info("begin to AutoGetPersonBaseInfo...");
            getBackGroupCensorService();
            Config config = configUtils.getConfigByKey("police");
            if (config.getValue().equals("1") && timeFlag.equals("true")) {
                if (Constants.BEIJING.equals(configUtils.getCurrentNative())) {
                    List<String> baseInfoList = personBaseInfoService.findUnGetBaseInfoList();
                    for (String idNum : baseInfoList) {
                        try {
                            PersonBaseInfo personBaseInfo = backGroupCensorService.getPopulationInfo(idNum,true);
                            personBaseInfo.setCreateTime(new Date());
                            personBaseInfo.setActive(true);
                            savePhoto(personBaseInfo);
                            personBaseInfoService.save(personBaseInfo);
                        }catch (Exception e){
                            logger.error(e.getMessage(),e);
                        }

                    }
                    //SecurityPerson  person = new SecurityPerson();
                    //person.setId(593129071739666432L);
                    //person.setIdNumber("130526198905146431");
                    //PersonBaseInfo personBaseInfo = backGroupCensorService.getPopulationInfo(person.getIdNumber());
                    //personBaseInfo.setId(person.getId());
                    //personBaseInfo.setCreateTime(new Date());
                    //personBaseInfo.setActive(true);
                    //savePhoto(personBaseInfo);
                    //personBaseInfoService.save(personBaseInfo);
                }
            }
        logger.info("AutoGetPersonBaseInfo done.");
        }finally {
            lock = false;
        }
    }

    private void savePhoto(PersonBaseInfo personBaseInfo){
        personBaseInfo.setState(Constants.PHOTO_NO);
        if(StringUtil.isNotEmpty(personBaseInfo.getPhoto())){
            Date now = new Date();
            String fileName = now.getTime() +".jpg";
            String dirDate = DateUtil.systemDate.format(now);
            File dir = new File(baseFolder + personImgPath + dirDate);
            if(!dir.exists()) {
                dir.mkdirs();
            }
            String key = personImgPath + dirDate + "/" + fileName;
            String url = "getResource.do?path=" + key;
            String targetPath = baseFolder + key;

            if(ImgUtils.generateImage(personBaseInfo.getPhoto(),targetPath)) {
                personBaseInfo.setImgPath(url);
                personBaseInfo.setState(Constants.PHOTO_YES);
            }
            personBaseInfo.setPhoto(null);
        }
    }

    private void test(){
        Date now = new Date();
        String fileName = now.getTime() +".jpg";
        String dirDate = DateUtil.systemDate.format(now);
        File dir = new File(baseFolder + personImgPath + dirDate);
        if(!dir.exists()) {
            dir.mkdirs();
        }
        String key = personImgPath + dirDate + "/" + fileName;
        String url = "getResource.do?path=" + key;
        String targetPath = baseFolder + key;

        if(ImgUtils.generateImage(ImgUtils.getImageStr("C:\\Users\\Administrator\\Desktop\\test.png"),targetPath)) {
            System.out.println(url);
        }
    }
}
