package com.bcxin.ars.timer.dataSync;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.JobLogAnnotation;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.DataSyncContantsUtil;
import com.bcxin.ars.service.util.DataSyncUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.File;

/**
 * 内外网数据同步
 * 需要同步的表在service实现类加上DataSyncAnnotation注解
 * service实现类中
 *  读取同步数据文件实现saveOrUpdateForDS或updateFlagForOutToIn
 *  生成同步数据文件实现searchForDataSynchronization
 * @author linqinglin
 * @date 2019/04/03 14:15
 */
@Service
public class DataSyncDSServiceAll {

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private DataSyncUtil dataSyncUtil;

    @Autowired
    private DataSyncContantsUtil dataSyncContantsUtil;

    private boolean lock = false;
    /***
     *  近两天全量数据
     */
    @JobLogAnnotation(getJobClazz =DataSyncDSServiceAll.class)
    public void runAll() {
        if(lock){
            return;
        }
        lock = true;
        try {
            //同步
            if (Constants.DATASYNCHRONIZATION_YES.equals(configUtils.getValueByKey(Constants.DATASYNCHRONIZATION))
                    && Constants.TIMEFLAG_VALUE.equals(configUtils.timeFlag)) {
                if (!configUtils.isIntranet()) {
                    DataSynchronizationSearchDto searchDto = new DataSynchronizationSearchDto();
                    searchDto.setPaging(false);
                    /***
                     * 最后同步日期
                     */
                    searchDto.setStartDate(DateUtil.getYesterday());
                    searchDto.setEndDate(DateUtil.getTomorrow());
                    //外网生成同步文件
                    policeOutCreateFile(searchDto);
                    /**
                     * 更新"外到内最后同步日期" end
                     */
                }else{
                    policeInCreateFile();
                }
            }
        }finally {
            lock = false;
        }
    }

    private void policeOutCreateFile(DataSynchronizationSearchDto searchDto) {
       if(Constants.DATASYNC_SWITCH_1.equals(configUtils.getValueByKey(Constants.DATASYNC_SWITCH))){
           dataSyncUtil.createDSFile(DataSyncAnnotation.class,searchDto,dataSyncContantsUtil.ftpOutFolder + DateUtil.getCurrentDate()+File.separator);
       }else{
           dataSyncUtil.createDSFile(DataSyncAnnotation.class,searchDto,dataSyncContantsUtil.ftpFolder + DateUtil.getCurrentDate()+File.separator);
       }
    }

    private void policeInCreateFile() {
       if(Constants.DATASYNC_SWITCH_1.equals(configUtils.getValueByKey(Constants.DATASYNC_SWITCH))){
           String startDate = DateUtil.getYesterday();
           String dirDate = DateUtil.getCurrentDate();
           String filePath = dataSyncContantsUtil.ftpInFolder + dirDate + File.separatorChar;
           dataSyncUtil.createDSFile(startDate,filePath);

       }
    }

}
