package com.bcxin.ars.timer.dataSync;

import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.abcxin.smart.validator.annotation.JobLogAnnotation;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.DataSyncUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.File;
import java.util.Date;
import java.util.List;

/**
 * 同步公安内外网数据
 * Created by subh on 2017/6/3.
 */
@Service
public class ApprovalSynchronizationService {

    private Logger logger = LoggerFactory.getLogger(ApprovalSynchronizationService.class);

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private DataSyncUtil dataSyncUtil;

    @Value("${time-approval-download-folder}")
    private String intToOutFolder;


    @JobLogAnnotation(getJobClazz =ApprovalSynchronizationService.class)
    public void runApproval() {
        if (Constants.TIMEFLAG_VALUE.equals(configUtils.timeFlag)) {
            if(Constants.DATASYNC_SWITCH_1.equals(configUtils.getValueByKey(Constants.DATASYNC_SWITCH))){
                return;
            }
            Config config = configUtils.getConfigByKey(Constants.POLICE);
            //config.setValue(Constants.POLICE_OUT);
            /***
             * 获取省份信息，广西、宁夏、陕西需要自动同步，其它省份不需要 2019-03-22 subh eidt
             */
            Config provinceConfig = configUtils.getConfigByKey(Constants.CURRENT_PROVINCE);

            if (provinceConfig != null && (Constants.SHANGXIACODE.equals(provinceConfig.getValue()) || Constants.GUANGXICODE.equals(provinceConfig.getValue()) || Constants.NINGXIACODE.equals(provinceConfig.getValue()))) {
                //内网生成同步文件
                if (config != null && Constants.POLICE_IN.equals(config.getValue())) {
                    createDataFile();
                } else {
                    //外网读取同步文件
                    this.readDSFile(DataSyncOutAnnotation.class, intToOutFolder);
                }
            }
        }
    }


    /**
     * 内网生成数据同步文件
     */
    private void createDataFile(){
        //内到外生成
        /***
         * 最后同步日期
         */
        String startDate = DateUtil.getYesterday();
        Config lastDateConfig = configUtils.getConfigByKey(Constants.DATASYNC_LASTDATE);
        //配置为空或者等于当天日期
        if(lastDateConfig == null || DateUtil.convertDateToString(new Date(), DateUtil.FORMAT2).equals(lastDateConfig.getValue())){
        }else{
            startDate = lastDateConfig.getValue();
        }
        String dirDate = DateUtil.getCurrentDate();
        String filePath = intToOutFolder + dirDate + File.separatorChar;
        dataSyncUtil.createDSFile(startDate,filePath);

        /**
         * 更新"内到外最后同步日期" start
         */
        Config updateConfig = new Config();
        updateConfig.setKey(Constants.DATASYNC_LASTDATE);
        updateConfig.setValue(DateUtil.getCurrentDate());
        configUtils.updateForKey(updateConfig);

        /**
         * 更新"内到外最后同步日期" end
         */
    }

    /**
     * 外网读取同步数据文件
     */
    private void readDSFile(Class annotationClass, String filePath) {
        Date now = new Date();
        /***
         * 最后同步日期
         */
        Config lastDateConfig = configUtils.getConfigByKey(Constants.DATASYNC_LASTDATE);
        if (lastDateConfig != null) {
            //读取的时间为最后更新的时间
            String lastDate = lastDateConfig.getValue();
            List<Date> dates = DateUtil.getBetweenDates(DateUtil.convertStringToDate(lastDate), now);
            //加入当前日期
            dates.add(DateUtil.getBeginDayOfYesterday());
            dates.add(now);
            for (Date date : dates) {
                String dirFilePath = filePath + DateUtil.convertDateToString(date, DateUtil.FORMAT2);
                File dirFile = new File(dirFilePath);
                if (!dirFile.exists()) {
                    break;
                }
                File[] files = dirFile.listFiles();
                //读取是否有错误
                boolean errorFlag = false;
                for (int i = 0; i < files.length; i++) {
                    File file = files[i];
                    if(file.getName().endsWith(Constants.ZIP) && file.getName().startsWith(configUtils.getDataSyncStartFileName(DataSyncOutAnnotation.class))){
                        try {
                            dataSyncUtil.readDSFile(annotationClass,file);
                        } catch (Exception e) {
                            logger.error(e.getMessage(), e);
                            errorFlag = true;
                        }
                    }
                }

                //如果文件没有读取错误
                if (!errorFlag) {
                    Config updateConfig = new Config();
                    updateConfig.setKey(Constants.DATASYNC_LASTDATE);
                    updateConfig.setValue(DateUtil.convertDateToString(date,DateUtil.FORMAT2));
                    configUtils.updateForKey(updateConfig);
                }

            }
        }
    }


    public static void main(String[] args) {
        File file = new File("C:\\data\\upload\\ars\\download\\approval\\2019-06-13\\datasync_20190613134530.zip");
        System.out.println(file.getAbsolutePath());
    }
}




