package com.bcxin.ars.timer.conference;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.conference.CloudConferenceDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.conference.HuaWeiConference;
import com.bcxin.ars.dto.conference.PageConferenceInfo;
import com.bcxin.ars.model.conference.CloudConference;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.conference.CloudConferenceService;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.HuaweiMeetUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.huawei.HuaweiMeetConst;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author linqinglin
 * @date 2019/12/23 0023 9:29
 */
@Service
public class UpdateConferenceStateService {


    private Logger logger = LoggerFactory.getLogger(UpdateConferenceStateService.class);

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private HuaweiMeetUtil huaweiMeetUtil;

    @Autowired
    private CloudConferenceDao cloudConferenceDao;
    @Value("${timeFlag}")
    private String timeFlag = "";
    @Autowired
    private CloudConferenceService cloudConferenceService;

   @Autowired
    private JobRunLogService jobRunLogService;

    public synchronized void autoUpdateConferenceState(){
        if(!configUtils.isIntranet() && timeFlag.equals("true")) {
            List<CloudConference> list = cloudConferenceDao.findUnEnd();
            if(list != null && list.size() > 0) {
                JobRunLog log = new JobRunLog();
                log.setCreateTime(new Date());
                log.setActive(true);
                log.setUpdateBy("jobSystem");
                //开始时间
                long startTime = System.currentTimeMillis();
                try {
                    Map<String, HuaWeiConference> conferenceMap = new HashedMap();
                    Map<String, Object> paramMap = new HashedMap();
                    AjaxResult result = huaweiMeetUtil.callInterface(Constants.METHOD_GET, HuaweiMeetConst.ADD_CONFERENCES,null, paramMap, true);

                    if(result.isSuccessful()) {
                        PageConferenceInfo detail = JSONObject.parseObject(JSON.toJSONString(result.getData()), PageConferenceInfo.class);
                        List<HuaWeiConference> huaWeiConferenceList = detail.getData();
                        if (huaWeiConferenceList != null && huaWeiConferenceList.size() > 0) {
                            huaWeiConferenceList.stream();
                            conferenceMap = huaWeiConferenceList.stream().collect(Collectors.toMap(HuaWeiConference::getConferenceID, Function.identity()));
                        }
                    }
                    for (CloudConference conference : list) {
                        HuaWeiConference huaWeiConference = conferenceMap.get(conference.getMeetId());
                        if (huaWeiConference != null) {
                            conference.setEndTime(DateUtil.utcToLocal(huaWeiConference.getEndTime() + ":00",DateUtil.FORMAT15));
                            if(StringUtil.isEmpty(conference.getConfUUID())){
                                conference.setConfUUID(huaWeiConference.getConfUUID());
                            }
                            if (Constants.CONFERENCESTATE_SCHEDULE.equals(huaWeiConference.getConferenceState())) {
                                conference.setState(Constants.CONFERENCESTATE_SCHEDULE_CODE);
                            } else if (Constants.CONFERENCESTATE_CREATED.equals(huaWeiConference.getConferenceState())) {
                                conference.setState(Constants.CONFERENCESTATE_CREATED_CODE);
                            } else {
                                conference.setState(Constants.CONFERENCESTATE_END_CODE);
                            }
                            //更新时间
                            conference.setUpdateTime(new Date());
                            //执行数据库更新
                            cloudConferenceDao.updateState(conference);
                        } else {
                                //结束会议
                                cloudConferenceService.endConference(conference);
                        }

                    }
                }catch (Exception e){
                    logger.error(e.getMessage(),e);
                    log.setExceptionMsg(e.toString());
                }
                //日志信息
                long endTime = System.currentTimeMillis();
                log.setUpdateTime(new Date());
                log.setJobName(UpdateConferenceStateService.class.getName());
                log.setRunTime(new Date());
                log.setRunTimeLength((endTime - startTime) + "ms");
                jobRunLogService.insert(log);
            }
        }
    }
}
