package com.bcxin.ars.timer;

import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.model.BusinessCommon;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.sb.BusinessService;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ApprovalUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * 对接 北京好差评系统
 * 该接口用于实时接收办件服务数据，防止第三方调用我方接口时，我方数据库没有该服
 * 务而无法进行评价（如果办件是调用北京市政务服务网申报接口产生的，即办件服务数
 * 据已经存在，则不需要调用该接口）
 * 测试地址：http://43.254.24.244
 * 正式地址：http://banshi.beijing.gov.cn
 * 请求路径：/pubservice/appraise4OT/reShareApprInfo
 * @author linqinglin
 * @date 2020/09/15 0015 15:40
 */
@Service
public class PushToAppraiseService {

    /***
     * 日志
     */
    private static Logger logger = LoggerFactory.getLogger(PushToAppraiseService.class);

    @Autowired
    private JobRunLogService jobRunLogService;

    @Autowired
    private ApprovalDAO approvalDAO;

    @Autowired
    private UserDao userDao;

    @Autowired
    private BusinessService businessService;

    @Autowired
    ConfigUtils configUtils;

    @Autowired
    ApprovalUtil approvalUtil;

    private boolean lock = false;

    public void reShareApprInfo(){

        if(Constants.BEIJING.equals(configUtils.getCurrentNative()) && !configUtils.isIntranet() && configUtils.timeFlag.equals("true")) {
            String APPRAISE_SWITCH = configUtils.getValueByKey(Constants.APPRAISE_SWITCH);
            if (Constants.YES.equals(APPRAISE_SWITCH)) {
                //if(lock){
                //    return;
                //}
                JobRunLog log = new JobRunLog();
                log.setCreateTime(new Date());
                log.setActive(true);
                log.setUpdateBy("jobSystem");
                //开始时间
                long startTime = System.currentTimeMillis();
                try {
                    List<Approval> approvalList = approvalDAO.findUnPushToAppraise();
                    for (Approval approval : approvalList) {
                        try {
                            BusinessCommon businessCommon = businessService.findByBusinessTypeAndId(approval.getBusinesstype(), approval.getBusinessid());
                            User user = userDao.findById(approval.getUserid());
                            approvalUtil.pushToAppraise(businessCommon, approval,user);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }

                //日志信息
                long endTime = System.currentTimeMillis();
                log.setUpdateTime(new Date());
                log.setJobName(PushToAppraiseService.class.getName());
                log.setRunTime(new Date());
                log.setRunTimeLength((endTime - startTime) + "ms");
                jobRunLogService.insert(log);
            }
        }

    }

}



