package com.bcxin.ars.timer;

import com.bcxin.ars.dao.sys.InterfaceLogDao;
import com.bcxin.ars.model.sys.InterfaceLog;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.sys.impl.InterfaceLogServiceImpl;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * @author linqinglin
 * @date 2020/08/28 0028 10:47
 */
@Service
public class InterfaceFailReCallService {

    @Autowired
    private InterfaceLogDao interfaceLogDao;

    @Autowired
    private InterfaceLogServiceImpl interfaceLogServiceImpl;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private JobRunLogService jobRunLogService;

    @Value("${timeFlag}")
    private String timeFlag = "";

    private boolean lock = false;

    public void recall(){
        if(lock){
            return;
        }
        lock = true;
        try{
            if (Constants.BEIJING.equals(configUtils.getCurrentNative()) && timeFlag.equals("true") && !configUtils.isIntranet()) {
                JobRunLog log = new JobRunLog();
                log.setCreateTime(new Date());
                log.setActive(true);
                log.setUpdateBy("jobSystem");
                //开始时间
                long startTime = System.currentTimeMillis();
                //资格证背景筛查结果、等级证开班审批结果
                String[] urls = {Constants.BKT_PERSONQUALIFY_CENSOR_URL,Constants.BKT_GRADECLASS_CENSOR_URL};
                for (String url : urls) {
                    try{
                        List<InterfaceLog> failList = interfaceLogDao.findFail(url);

                        for (InterfaceLog interfaceLog : failList) {
                            try{
                                interfaceLogServiceImpl.reCall(interfaceLog);
                            }catch (Exception e){
                                e.printStackTrace();
                            }
                        }

                    }catch (Exception e){
                        e.printStackTrace();
                    }
                }

                //日志信息
                long endTime = System.currentTimeMillis();
                log.setUpdateTime(new Date());
                log.setJobName(InterfaceFailReCallService.class.getName());
                log.setRunTime(new Date());
                log.setRunTimeLength((endTime - startTime) + "ms");
                jobRunLogService.insert(log);
            }
        }finally {
            lock = false;
        }
    }
}
