package com.bcxin.ars;

import com.alibaba.fastjson.JSONArray;
import com.bcxin.ars.dao.FilerecordDao;
import com.bcxin.ars.dao.FilerecordOutDao;
import com.bcxin.ars.dao.FilerecordStatusDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.*;
import com.bcxin.ars.model.approve.ApproveAreaProcess;
import com.bcxin.ars.model.approve.ApproveLinkLevel;
import com.bcxin.ars.model.approve.ApproveTempLinkRela;
import com.bcxin.ars.model.certificate.SecurityCertificate;
import com.bcxin.ars.model.exam.TrainExamInfo;
import com.bcxin.ars.model.exam.TrainExamPerson;
import com.bcxin.ars.model.msg.*;
import com.bcxin.ars.model.sb.*;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.model.task.Task;
import com.bcxin.ars.model.task.TaskFeedback;
import com.bcxin.ars.service.*;
import com.bcxin.ars.service.approve.ApproveAreaProcessService;
import com.bcxin.ars.service.approve.ApproveLinkLevelService;
import com.bcxin.ars.service.approve.ApproveTempLinkService;
import com.bcxin.ars.service.certificate.SecurityCertificateService;
import com.bcxin.ars.service.exam.TrainExamInfoService;
import com.bcxin.ars.service.exam.TrainExamPersonService;
import com.bcxin.ars.service.msg.*;
import com.bcxin.ars.service.sb.*;
import com.bcxin.ars.service.sys.ApprovalService;
import com.bcxin.ars.service.task.*;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.*;
import com.bcxin.ars.webservice.ClientUtil;
import com.google.common.io.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.crypto.BadPaddingException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.*;

/**
 * 同步公安内外网数据
 * Created by subh on 2017/6/3.
 */
@Service
public class DataSynchronizationService {
    private Logger logger = LoggerFactory.getLogger(DataSynchronizationService.class);

    @Autowired
    private ConfigUtils configUtils;
    /**
     * 任务信息
     */
    @Autowired
    private TaskService taskService;
    /***
     * 人员
     */
    @Autowired
    private SecurityPersonService securityPersonService;

    @Autowired
    private SecurityCertificateService securityCertificateService;

    @Autowired
    private SecurityCompanyPersonService securityCompanyPersonService;
    /***
     * 用户
     */
    @Autowired
    private UserService userService;

    /**
     * 公安机构
     */
    @Autowired
    private PoliceService policeService;
    
    /**
     * 公安角色
     */
    @Autowired
    private PoliceRoleService policeRoleService;
    
    /***
     * 角色
     */
    @Autowired
    private RoleService roleService;
    /**
     * 公司
     */
    @Autowired
    private SecurityCompanyService securityCompanyService;

    /**
     * 公司班次
     */
    @Autowired
    private SecurityCompanyScheduleService securityCompanyScheduleService;
    /**
     * 组织架构
     */
    @Autowired
    private OrganizationService organizationService;
    /**
     * 审批信息
     */
    @Autowired
    private ApprovalService approvalService;
    /**
     * 自行招用
     */
    @Autowired
    private ConfesscompanyService confesscompanyService;
    /**
     * 跨区
     */
    @Autowired
    private CrosscompanyService crosscompanyService;
    /***
     * 法人
     */
    @Autowired
    private LegalchangeService legalchangeService;

    @Autowired
    private LegalchangeworkexperienceService legalchangeworkexperienceService;
    /***
     * 个人主要简历
     */
    @Autowired
    private WorkexperienceService workexperienceService;
    /***
     * 年度报告
     */
    @Autowired
//    private YearreportService yearreportService;
    private YearreportdataService yearreportDataService;

    @Autowired
    private SecurityCompanyInsuranceService securityCompanyInsuranceService;

    @Autowired
    private YearreportdataManagerService yearreportdataManagerService;
    
    @Autowired
    private YearReportInsuranceService yearReportInsuranceService;
    
    @Autowired
    private YearReportInvestorService yearReportInvestorService;
    
    /***
     * 保安员证
     */
    @Autowired
    private PersoncertificateService personcertificateService;
    /***
     * 家庭成员
     */
    @Autowired
    private FamilyService familyService;
    /***
     * 工作经历
     */
    @Autowired
    private PersonworkexperienceService personworkexperienceService;
    /***
     * 保安服务公司
     */
    @Autowired
    private SponsorlicenseService sponsorlicenseService;
    /***
     * 股东出资额及所占比例
     */
    @Autowired
    private ShareholderService shareholderService;
    /***
     * 子公司
     */
    @Autowired
    private SubsidiaryService subsidiaryService;
    /***
     * 子公司备案
     */
    @Autowired
    private SubsidiarypersonService subsidiarypersonService;
    /***
     * 培训单位
     */
    @Autowired
    private TraincompanyapplyService traincompanyapplyService;

    @Autowired
    private UrgentTeamService urgentTeamService;

    @Autowired
    private TeamPersonService teamPersonService;

    @Autowired
    private TaskPersonService taskPersonService;

    @Autowired
    private TaskPersonScheduleService taskPersonScheduleService;

    @Autowired
    private TaskPersonScheduleDetailService taskPersonScheduleDetailService;

    @Autowired
    private TaskScheduleService taskScheduleService;
    @Autowired
    private TaskFeedbackService taskFeedbackService;
    @Autowired
    private DatasyncService datasyncService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private OrderPersonService orderPersonService;
    @Autowired
    private OrderTransactionService orderTransactionService;
    @Autowired
    private SbSubsidiaryBaseService sbSubsidiaryBaseService;
    @Autowired
    private SbSubsidiaryManagerService sbSubsidiaryManagerService;
    @Autowired
    private SbBusinessManagementService sbBusinessManagementService;
    @Autowired
    private SbBusinessOutsideManagementService sbBusinessOutsideManagementService;
    @Autowired
    private SbRewardService sbRewardService;
    @Autowired
    private SbPunishService sbPunishService;
    @Autowired
    private SecurityGoodThingService securityGoodThingService;
    @Autowired
    private VehicleService vehicleService;
    @Autowired
    private VehicleLogService vehicleLogService;
    @Autowired
    private FirearmsService firearmsService;
    @Autowired
    private CyFirearmsLogService cyFirearmsLogService;
    @Autowired
    private SafetyService safetyService;
    @Autowired
    private InvestorService investorService;
    @Autowired
    private ManagementInfoService managementInfoService;
    @Autowired
    private CyServerhtService cyServerhtService;
    @Autowired
    private FilerecordDao filerecordDao;

    @Autowired
    private FilerecordOutDao filerecordOutDao;

    @Autowired
    private FilerecordStatusDao filerecordStatusDao;

    @Autowired
    private ClientUtil clientUtil;

    @Autowired
    private ArmtrainorgService armtrainorgService;

    @Autowired
    private ArmorgteachService armorgteachService;

    @Autowired
    private ArmorgchargeService armorgchargeService;

    @Autowired
    private ArmtrainchargeService armtrainchargeService;

    @Autowired
    private ConfesscompanyundoService confesscompanyundoService;
    @Autowired
    private NewsnoticeCompanyService newsnoticeCompanyService;
    @Autowired
    private NewsnoticePoliceService newsnoticePoliceService;

    @Autowired
    private NewsCompanyRelationshipService newsCompanyRelationshipService;

    @Autowired
    private NewsnoticeRecipientService newsnoticeRecipientService;

    @Autowired
    private SysAttachmentService sysAttachmentService;

    @Autowired
    private SbSponsorlicenseManagerService sbSponsorlicenseManagerService;

    @Autowired
    private SbSponsorlicenseVmanagerService sbSponsorlicenseVmanagerService;

    @Autowired
    private TrainExamInfoService trainExamInfoService;

    @Autowired
    private TrainExamPersonService trainExamPersonService;

    @Autowired
    private ApproveAreaProcessService approveAreaProcessService;

    @Autowired
    private ApproveLinkLevelService approveLinkLevelService;

    @Autowired
    private ApproveTempLinkService approveTempLinkService;

    @Autowired
    private SecurityGuardService securityGuardService;


    @Value("${ftp-folder}")
    private String ftpFolder;
    @Value("${ftp-temp-folder}")
    private String tempftpFolder;
    @Value("${timeFlag}")
    private String timeFlag = "";
    /**
     * 获取两个日期之间的日期
     * @param start 开始日期
     * @param end 结束日期
     * @return 日期集合
     */
    public List<Date> getBetweenDates(Date start, Date end) {
        List<Date> result = new ArrayList<Date>();
        Calendar tempStart = Calendar.getInstance();
        tempStart.setTime(start);
        tempStart.add(Calendar.DAY_OF_YEAR, 1);

        Calendar tempEnd = Calendar.getInstance();
        tempEnd.setTime(end);
        while (tempStart.before(tempEnd)) {
            result.add(tempStart.getTime());
            tempStart.add(Calendar.DAY_OF_YEAR, 1);
        }
        return result;
    }

    public void run() {
        //获取配置是否要同步
        Config datasynchronizationconfig = configUtils.getConfigByKey(Constants.DATASYNCHRONIZATION);
        //不同步
         if(datasynchronizationconfig!=null && Constants.DATASYNCHRONIZATION_YES.equals(datasynchronizationconfig.getValue()) && Constants.TIMEFLAG_VALUE.equals(timeFlag)) {
            Config config = configUtils.getConfigByKey(Constants.POLICE);
            //公安端
            String nowStr = DateUtil.getCurrentDate();
            if (config!=null &&  Constants.POLICE_IN.equals(config.getValue())) {
                /***
                 * 最后同步日期
                 */
                Config lastDateConfig = configUtils.getConfigByKey(Constants.LASTDATE);


                logger.info("同步时间:"+lastDateConfig.getValue());
                if(lastDateConfig!=null) {
                    String lastDate =lastDateConfig.getValue();
                    List<Date> dates= getBetweenDates( DateUtil.convertStringToDate(lastDate),DateUtil.convertStringToDate(nowStr));
                    //加入当前日期
                    dates.add(DateUtil.convertStringToDate(nowStr));
                    for (Date d: dates ) {
                        //任务信息
                        String filePath = ftpFolder + DateUtil.convertDateToString(d,DateUtil.FORMAT2);
                        // 获取文件夹
                        File f = new File(filePath);
                        if (!f.exists()) {
                            break;
                        }
                        //读取是否有错误
                        boolean errorFlag = false;
                        String[] filenames = {"police","policeRole","user", "company", "organization", "role", "person",
                                "securityCompanySchedule", "task", "taskFeedback", "crosscompany",
                                "confesscompany", "traincompanyapply", "workexperience", "legalchange", "legalchangeworkexperience",
                                "yearreport","securityCompanyInsurance","yearreportdataManager","yearReportInsurance","yearReportInvestor","armtrainorg","armorgteach","armorgcharge",
                                "armtraincharge", "personcertificate", "family", "personworkexperience",
                                "subsidiary", "subsidiaryperson", "sponsorlicense", "sbsponsorlicenseManager","sbsponsorlicenseVManager","sponsorlicense","confesscompanyundo","securitycertificate",
                                "shareholder", "approval", "datasync", "order", "orderPerson",
                                "orderTransaction", "sbSubsidiaryBase", "sbSubsidiaryManager", "sbBusinessManagement",
                                "sbBusinessOutsideManagement", "sbReward", "sbPunish", "securityGoodThing",
                                "vehicle", "vehicleLog", "firearms", "cyFirearmsLog", "safety", "investor", "managementInfo",
                                "cyServerht","newsnoticePolice", "newsnoticeCompany","newsCompanyRelationship","sysAttachment","newsnoticeRecipient",
                                "trainExamInfo","trainExamPerson","approveAreaProcess","approveLinkLevel","approveTempLinkRela"
                        };

                        Map<String, String> fileNameMap = new LinkedHashMap<String, String>();

                       /**** 文件名filename: personcertificate_20180730150010.data  ****/

                        for (String filename : filenames) {
                            File fa[] = f.listFiles();   // 文件列表
                            for (int i = 0; i < fa.length; i++) {
                                File fs = fa[i];
                                String[] splitFiles = fs.getName().replace(".data", "").split("_");
                                if (splitFiles.length == 2) {
                                    if (splitFiles[0].equals(filename)) {
                                        String createTime = fileNameMap.get(filename);
                                        /****  控制fileName 为时间最大的那一个  ****/
                                        if (StringUtil.isNotEmpty(createTime)) {
                                            if (Long.parseLong(splitFiles[1]) > Long.parseLong(createTime)) {
                                                fileNameMap.put(filename, splitFiles[1]);
                                            }
                                        } else {
                                            fileNameMap.put(filename, splitFiles[1]);
                                        }
                                    }
                                }
                            }
                        }




                        for (String filename : filenames) {
                            String createTime = fileNameMap.get(filename);
                            if (StringUtil.isEmpty(createTime)) {
                                continue;
                            }
                            File fs = new File(filePath + "/" + filename + "_" + createTime + ".data");
                            /** 文件存在且类型不为文件夹 by llc 2018-08-06  **/
                            if (fs.exists() && fs.isFile()) {
                                try {
                                    logger.info(filePath + "/" + filename + "_" + createTime + ".data");
                                    BufferedReader br = new BufferedReader(new FileReader(fs));
                                    StringBuffer content = new StringBuffer();
                                    // 获取文件内容
                                    String lineTxt = null;
                                    while ((lineTxt = br.readLine()) != null) {// 使用readLine方法，一次读一行
                                        content.append(lineTxt);
                                    }
                                    br.close();
                                    String jsonStr = new String(CipherDESUtil.decrypt(Encodes.decodeHex(content.toString()), Constants.APPROVAL_KEY));
                                    // 机构信息ID保持内外网一致
                                    if (fs.getName().equals("police" + "_" + createTime + ".data")) {
                                        //判断文件名是否已经记录,若已记录，则不在读
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<Police> policeList = JSONArray.parseArray(jsonStr, Police.class);
                                            if (policeList != null && policeList.size() > 0) {
                                                for (Police police : policeList) {
                                                    try {
                                                    	policeService.saveOrUpdateForDS(police);
                                                    }catch (Exception e) {
														logger.error(e.toString(),e);
													}
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),policeList.size());
                                            }
                                        }
                                        // 公安角色信息ID保持内外网一致
                                    } else if (fs.getName().equals("policeRole" + "_" + createTime + ".data")) {
                                        //判断文件名是否已经记录,若已记录，则不在读
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<PoliceRole> policeRoleList = JSONArray.parseArray(jsonStr, PoliceRole.class);
                                            if (policeRoleList != null && policeRoleList.size() > 0) {
                                                for (PoliceRole policeRole : policeRoleList) {
                                                    try {
                                                    	policeRoleService.saveOrUpdateForDS(policeRole);
                                                    }catch (Exception e) {
														logger.error(e.getMessage(),e);
													}
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),policeRoleList.size());
                                            }
                                        }
                                        //用户信息
                                    } else if (fs.getName().equals("user" + "_" + createTime + ".data")) {
                                        //判断文件名是否已经记录,若已记录，则不在读
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<User> userList = JSONArray.parseArray(jsonStr, User.class);
                                            if (userList != null && userList.size() > 0) {
                                                for (User user : userList) {
                                                    try {
                                                        userService.saveOrUpdateForDS(user);
                                                    }catch (Exception e) {
														logger.error(e.getMessage(),e);
													}
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),userList.size());
                                            }
                                        }
                                        //公司信息
                                    } else if (fs.getName().equals("company" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<SecurityCompany> companyList = JSONArray.parseArray(jsonStr, SecurityCompany.class);
                                            if (companyList != null && companyList.size() > 0) {
                                                for (SecurityCompany securityCompany : companyList) {
                                                    try {
                                                        //根据rawid的user用户信息
                                                        User dbUser = userService.findById(securityCompany.getUser().getId());
                                                        if (dbUser != null) {
                                                            securityCompany.setUser(dbUser);
                                                            securityCompany.setExported(true);
                                                            securityCompanyService.saveOrUpdateForDS(securityCompany);

                                                        }
                                                    } catch (Exception e) {
                                                        logger.error(e.getMessage(),e);
                                                    }
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),companyList.size());
                                            }
                                        }
                                        //公司、机构
                                    } else if (fs.getName().equals("organization" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<Organization> organizationList = JSONArray.parseArray(jsonStr, Organization.class);
                                            if (organizationList != null && organizationList.size() > 0) {
                                                for (Organization organization : organizationList) {
                                                	try {
                                                		organizationService.saveOrUpdateForDS(organization);
													} catch (Exception e) {
														logger.error(e.getMessage(),e);
													}
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),organizationList.size());
                                            }
                                        }
                                        //保安公司角色信息
                                    } else if (fs.getName().equals("role" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<Role> roleList = JSONArray.parseArray(jsonStr, Role.class);
                                            if (roleList != null && roleList.size() > 0) {
                                                for (Role role : roleList) {
                                                	try {
                                                		roleService.saveOrUpdateForDS(role);
													} catch (Exception e) {
														logger.error(e.getMessage(),e);
													}
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),roleList.size());
                                            }
                                        }
                                        //人员信息
                                    } else if (fs.getName().equals("person" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<SecurityPerson> personList = JSONArray.parseArray(jsonStr, SecurityPerson.class);
                                            if (personList != null && personList.size() > 0) {
                                                for (SecurityPerson securityPerson : personList) {
                                                    try {
                                                            securityPersonService.saveOrUpdateForDS(securityPerson);
                                                    } catch (Exception e) {
                                                        logger.error(e.getMessage(),e);
                                                    }
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),personList.size());
                                            }
                                        }
                                    } else if (fs.getName().equals("securityCompanySchedule" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<SecurityCompanySchedule> list = JSONArray.parseArray(jsonStr, SecurityCompanySchedule.class);
                                            if (list != null && list.size() > 0) {
                                                for (SecurityCompanySchedule securityCompanySchedule : list) {
                                                	try {
                                                		securityCompanyScheduleService.saveOrUpdateForDS(securityCompanySchedule);
													} catch (Exception e) {
														logger.error(e.getMessage(),e);
													}
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),list.size());
                                            }
                                        }
                                    } else if (fs.getName().equals("task" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<Task> taskList = JSONArray.parseArray(jsonStr, Task.class);
                                            if (taskList != null && taskList.size() > 0) {
                                                for (Task task : taskList) {
                                                    try {
                                                		taskService.saveOrUpdateForDS(task);
													} catch (Exception e) {
														logger.error(e.getMessage(),e);
													}
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),taskList.size());
                                            }
                                        }
                                    } else if (fs.getName().equals("taskFeedback" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<TaskFeedback> feedbackList = JSONArray.parseArray(jsonStr, TaskFeedback.class);

                                            if (feedbackList != null && feedbackList.size() > 0) {
                                                for (TaskFeedback feedback : feedbackList) {
                                                    try {
                                                		taskFeedbackService.saveOrUpdateForDS(feedback);
													} catch (Exception e) {
														logger.error(e.getMessage(),e);
													}
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),feedbackList.size());
                                            }
                                        }
                                    } else if (fs.getName().equals("crosscompany" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<Crosscompany> crossCompanyList = JSONArray.parseArray(jsonStr, Crosscompany.class);
                                            if (crossCompanyList != null && crossCompanyList.size() > 0) {
                                                for (Crosscompany crossCompany : crossCompanyList) {
                                                    try {
                                                		crosscompanyService.saveOrUpdateForDS(crossCompany);
													} catch (Exception e) {
														logger.error(e.getMessage(),e);
													}
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),crossCompanyList.size());
                                            }
                                        }
                                    } else if (fs.getName().equals("confesscompany" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<Confesscompany> confessCompanyList = JSONArray.parseArray(jsonStr, Confesscompany.class);
                                            if (confessCompanyList != null && confessCompanyList.size() > 0) {
                                                for (Confesscompany confesscompany : confessCompanyList) {
                                                    try {
                                                		confesscompanyService.saveOrUpdateForDS(confesscompany);
													} catch (Exception e) {
														logger.error(e.getMessage(),e);
													}

                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),confessCompanyList.size());
                                            }
                                        }
                                    } else if (fs.getName().equals("traincompanyapply" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<Traincompanyapply> traincompanyapplyList = JSONArray.parseArray(jsonStr, Traincompanyapply.class);
                                            if (traincompanyapplyList != null && traincompanyapplyList.size() > 0) {
                                                for (Traincompanyapply traincompanyapply : traincompanyapplyList) {
                                                    try {
                                                		traincompanyapplyService.saveOrUpdateForDS(traincompanyapply);
													} catch (Exception e) {
														logger.error(e.getMessage(),e);
													}
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),traincompanyapplyList.size());
                                            }
                                        }
                                    } else if (fs.getName().equals("newsnoticePolice" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<NewsnoticePolice> newsnoticePoliceList = JSONArray.parseArray(jsonStr, NewsnoticePolice.class);
                                            //	logger.info(traincompanyapplyList.size());
                                            if (newsnoticePoliceList != null && newsnoticePoliceList.size() > 0) {
                                                for (NewsnoticePolice newsnoticePolice : newsnoticePoliceList) {
                                                    try {
                                                        newsnoticePoliceService.saveOrUpdateForDS(newsnoticePolice);
                                                    } catch (Exception e) {
                                                        logger.error(e.getMessage(),e);
                                                    }
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),newsnoticePoliceList.size());
                                            }
                                        }
                                    }else if (fs.getName().equals("newsnoticeCompany" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<NewsnoticeCompany> newsnoticeCompanyList = JSONArray.parseArray(jsonStr, NewsnoticeCompany.class);
                                            //	logger.info(traincompanyapplyList.size());
                                            if (newsnoticeCompanyList != null && newsnoticeCompanyList.size() > 0) {
                                                for (NewsnoticeCompany newsnoticeCompany : newsnoticeCompanyList) {
                                                    try {
                                                        newsnoticeCompanyService.saveOrUpdateForDS(newsnoticeCompany);
                                                    } catch (Exception e) {
                                                        logger.error(e.getMessage(),e);
                                                    }
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),newsnoticeCompanyList.size());
                                            }
                                        }
                                        //同步公司与消息关系信息表
                                    }else if (fs.getName().equals("newsCompanyRelationship" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<NewsCompanyRelationship> newsCompanyRelationshipList = JSONArray.parseArray(jsonStr, NewsCompanyRelationship.class);
                                            //	logger.info(traincompanyapplyList.size());
                                            if (newsCompanyRelationshipList != null && newsCompanyRelationshipList.size() > 0) {
                                                for (NewsCompanyRelationship newsCompanyRelationship : newsCompanyRelationshipList) {
                                                    try {
                                                        newsCompanyRelationshipService.saveOrUpdateForDS(newsCompanyRelationship);
                                                    } catch (Exception e) {
                                                        logger.error(e.getMessage(),e);
                                                    }
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),newsCompanyRelationshipList.size());
                                            }
                                        }
                                        //同步消息附件
                                    }else if (fs.getName().equals("sysAttachment" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<SysAttachment> sysAttachmentList = JSONArray.parseArray(jsonStr, SysAttachment.class);
                                            //	logger.info(traincompanyapplyList.size());
                                            if (sysAttachmentList != null && sysAttachmentList.size() > 0) {
                                                for (SysAttachment sysAttachment : sysAttachmentList) {
                                                    try {

                                                        sysAttachmentService.saveOrUpdateForDS(sysAttachment);
                                                    } catch (Exception e) {
                                                        logger.error(e.getMessage(),e);
                                                    }
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),sysAttachmentList.size());
                                            }
                                        }
                                        //消息接收人
                                    }else if (fs.getName().equals("newsnoticeRecipient" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<NewsnoticeRecipient> newsnoticeRecipientList = JSONArray.parseArray(jsonStr, NewsnoticeRecipient.class);
                                            //	logger.info(traincompanyapplyList.size());
                                            if (newsnoticeRecipientList != null && newsnoticeRecipientList.size() > 0) {
                                                for (NewsnoticeRecipient newsnoticeRecipient : newsnoticeRecipientList) {
                                                    try {
                                                        newsnoticeRecipientService.saveOrUpdateForDS(newsnoticeRecipient);
                                                    } catch (Exception e) {
                                                        logger.error(e.getMessage(),e);
                                                    }
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),newsnoticeRecipientList.size());
                                            }
                                        }
                                        //同步消息附件
                                    }else if (fs.getName().equals("legalchange" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<Legalchange> legalchangeList = JSONArray.parseArray(jsonStr, Legalchange.class);
                                            if (legalchangeList != null && legalchangeList.size() > 0) {
                                                for (Legalchange legalchange : legalchangeList) {
                                                    try {
                                                		legalchangeService.saveOrUpdateForDS(legalchange);
													} catch (Exception e) {
														logger.error(e.getMessage(),e);
													}
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),legalchangeList.size());
                                            }
                                        }
                                    } else if (fs.getName().equals("legalchangeworkexperience" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<Legalchangeworkexperience> legalchangeworkexperienceList = JSONArray.parseArray(jsonStr, Legalchangeworkexperience.class);
                                            if (legalchangeworkexperienceList != null && legalchangeworkexperienceList.size() > 0) {
                                                for (Legalchangeworkexperience legalchangeworkexperience : legalchangeworkexperienceList) {
                                                	try {
                                                		legalchangeworkexperienceService.saveOrUpdateForDS(legalchangeworkexperience);
													} catch (Exception e) {
														logger.error(e.getMessage(),e);
													}
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),legalchangeworkexperienceList.size());
                                            }
                                        }
                                    } else if (fs.getName().equals("workexperience" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<Workexperience> workexperienceList = JSONArray.parseArray(jsonStr, Workexperience.class);
                                            if (workexperienceList != null && workexperienceList.size() > 0) {
                                                for (Workexperience workexperience : workexperienceList) {
                                                	try {
                                                		workexperienceService.saveOrUpdateForDS(workexperience);
													} catch (Exception e) {
														logger.error(e.getMessage(),e);
													}
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),workexperienceList.size());
                                            }
                                        }
                                    } else if (fs.getName().equals("yearreport" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<Yearreportdata> yearreportList = JSONArray.parseArray(jsonStr, Yearreportdata.class);
                                            if (yearreportList != null && yearreportList.size() > 0) {
                                                for (Yearreportdata yearreport : yearreportList) {
                                                    try {
                                                		yearreportDataService.saveOrUpdateForDS(yearreport);
													} catch (Exception e) {
														logger.error(e.getMessage(),e);
													}

                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),yearreportList.size());
                                            }
                                        }
                                    } else if (fs.getName().equals("securityCompanyInsurance" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<SecurityCompanyInsurance> securityCompanyInsuranceList = JSONArray.parseArray(jsonStr, SecurityCompanyInsurance.class);
                                            if (securityCompanyInsuranceList != null && securityCompanyInsuranceList.size() > 0) {
                                                for (SecurityCompanyInsurance securityCompanyInsurance : securityCompanyInsuranceList) {
                                                    try {
                                                    	securityCompanyInsuranceService.saveOrUpdateForDS(securityCompanyInsurance);
													} catch (Exception e) {
														logger.error(e.getMessage(),e);
													}

                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),securityCompanyInsuranceList.size());
                                            }
                                        }
                                    } else if (fs.getName().equals("yearreportdataManager" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<YearreportdataManager> yearreportdataManagerList = JSONArray.parseArray(jsonStr, YearreportdataManager.class);
                                            if (yearreportdataManagerList != null && yearreportdataManagerList.size() > 0) {
                                                for (YearreportdataManager yearreportdataManager : yearreportdataManagerList) {
                                                    try {
                                                    	yearreportdataManagerService.saveOrUpdateForDS(yearreportdataManager);
													} catch (Exception e) {
														logger.error(e.getMessage(),e);
													}

                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),yearreportdataManagerList.size());
                                            }
                                        }
                                    }  else if (fs.getName().equals("yearReportInvestor" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<YearReportInvestor> yearReportInvestorList = JSONArray.parseArray(jsonStr, YearReportInvestor.class);
                                            if (yearReportInvestorList != null && yearReportInvestorList.size() > 0) {
                                                for (YearReportInvestor yearReportInvestor : yearReportInvestorList) {
                                                    try {
                                                    	yearReportInvestorService.saveOrUpdateForDS(yearReportInvestor);
													} catch (Exception e) {
														logger.error(e.getMessage(),e);
													}

                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),yearReportInvestorList.size());
                                            }
                                        }
                                    }  else if (fs.getName().equals("yearReportInsurance" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<YearReportInsurance> yearReportInsuranceList = JSONArray.parseArray(jsonStr, YearReportInsurance.class);
                                            if (yearReportInsuranceList != null && yearReportInsuranceList.size() > 0) {
                                                for (YearReportInsurance yearReportInsurance : yearReportInsuranceList) {
                                                    try {
                                                    	yearReportInsuranceService.saveOrUpdateForDS(yearReportInsurance);
													} catch (Exception e) {
														logger.error(e.getMessage(),e);
													}
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(), yearReportInsuranceList.size());
                                            }
                                        }
                                    } else if (fs.getName().equals("armtrainorg" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<Armtrainorg> armtrainorgList = JSONArray.parseArray(jsonStr, Armtrainorg.class);
                                            if (armtrainorgList != null && armtrainorgList.size() > 0) {
                                                for (Armtrainorg armtrainorg : armtrainorgList) {
                                                    try {
                                                        armtrainorgService.saveOrUpdateForDS(armtrainorg);
                                                    }catch(Exception e ){
                                                        logger.error(e.getMessage(),e);
                                                    }
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),armtrainorgList.size());
                                            }
                                        }
                                    }else if (fs.getName().equals("armorgteach" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<Armorgteach> armorgteachList = JSONArray.parseArray(jsonStr, Armorgteach.class);
                                            if (armorgteachList != null && armorgteachList.size() > 0) {
                                                for (Armorgteach armorgteach : armorgteachList) {
                                                    try {
                                                        armorgteachService.saveOrUpdateForDS(armorgteach);
                                                    }catch(Exception e ){
                                                        logger.error(e.getMessage(),e);
                                                    }
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),armorgteachList.size());
                                            }
                                        }
                                    }else if (fs.getName().equals("armorgcharge" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<Armorgcharge> armorgchargeList = JSONArray.parseArray(jsonStr, Armorgcharge.class);
                                            if (armorgchargeList != null && armorgchargeList.size() > 0) {
                                                for (Armorgcharge armorgcharge : armorgchargeList) {
                                                    try {
                                                        armorgchargeService.saveOrUpdateForDS(armorgcharge);
                                                    }catch(Exception e ){
                                                        logger.error(e.getMessage(),e);
                                                    }
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),armorgchargeList.size());
                                            }
                                        }
                                    }else if (fs.getName().equals("armtraincharge" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<Armtraincharge> armtrainchargeList = JSONArray.parseArray(jsonStr, Armtraincharge.class);
                                            if (armtrainchargeList != null && armtrainchargeList.size() > 0) {
                                                for (Armtraincharge armtraincharge : armtrainchargeList) {
                                                    try {
                                                    armtrainchargeService.saveOrUpdateForDS(armtraincharge);
                                                    }catch(Exception e ){
                                                        logger.error(e.getMessage(),e);
                                                    }
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),armtrainchargeList.size());
                                            }
                                        }
                                    } else if (fs.getName().equals("personcertificate" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<Personcertificate> personcertificateList = JSONArray.parseArray(jsonStr, Personcertificate.class);
                                            if (personcertificateList != null && personcertificateList.size() > 0) {
                                                for (Personcertificate personcertificate : personcertificateList) {
                                                    try {
                                                		personcertificateService.saveOrUpdateForDS(personcertificate);
													} catch (Exception e) {
														logger.error(e.getMessage(),e);
														e.printStackTrace();
													}

                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),personcertificateList.size());
                                            }
                                        }
                                    } else if (fs.getName().equals("family" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<Family> familyList = JSONArray.parseArray(jsonStr, Family.class);
                                            if (familyList != null && familyList.size() > 0) {
                                                for (Family family : familyList) {
                                                	try {
                                                		familyService.saveOrUpdateForDS(family);
													} catch (Exception e) {
														logger.error(e.getMessage(),e);
													}

                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),familyList.size());
                                            }
                                        }
                                    } else if (fs.getName().equals("personworkexperience" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<Personworkexperience> personworkexperienceList = JSONArray.parseArray(jsonStr, Personworkexperience.class);
                                            if (personworkexperienceList != null && personworkexperienceList.size() > 0) {
                                                for (Personworkexperience personworkexperience : personworkexperienceList) {
                                                	try {
                                                		personworkexperienceService.saveOrUpdateForDS(personworkexperience);
													} catch (Exception e) {
														logger.error(e.getMessage(),e);
													}

                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),personworkexperienceList.size());
                                            }
                                        }
                                    } else if (fs.getName().equals("subsidiary" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<Subsidiary> subsidiaryList = JSONArray.parseArray(jsonStr, Subsidiary.class);
                                            if (subsidiaryList != null && subsidiaryList.size() > 0) {
                                                for (Subsidiary subsidiary : subsidiaryList) {
                                                    try {
                                                		subsidiaryService.saveOrUpdateForDS(subsidiary);
													} catch (Exception e) {
														logger.error(e.getMessage(),e);
													}

                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),subsidiaryList.size());
                                            }
                                        }
                                    } else if (fs.getName().equals("subsidiaryperson" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<Subsidiaryperson> subsidiarypersonList = JSONArray.parseArray(jsonStr, Subsidiaryperson.class);
                                            if (subsidiarypersonList != null && subsidiarypersonList.size() > 0) {
                                                for (Subsidiaryperson subsidiaryperson : subsidiarypersonList) {
                                                	try {
                                                		subsidiarypersonService.saveOrUpdateForDS(subsidiaryperson);
													} catch (Exception e) {
														logger.error(e.getMessage(),e);
													}
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),subsidiarypersonList.size());
                                            }
                                        }
                                    } else if (fs.getName().equals("sponsorlicense" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<Sponsorlicense> sponsorlicenseList = JSONArray.parseArray(jsonStr, Sponsorlicense.class);
                                            if (sponsorlicenseList != null && sponsorlicenseList.size() > 0) {
                                                for (Sponsorlicense sponsorlicense : sponsorlicenseList) {
                                                    try {

                                                		sponsorlicenseService.saveOrUpdateForDS(sponsorlicense);
													} catch (Exception e) {
														logger.error(e.getMessage(),e);
													}

                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),sponsorlicenseList.size());
                                            }
                                        }
                                    } else if (fs.getName().equals("sbsponsorlicenseManager" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<SbSponsorlicenseManager> sbSponsorlicenseManagerList = JSONArray.parseArray(jsonStr, SbSponsorlicenseManager.class);
                                            if (sbSponsorlicenseManagerList != null && sbSponsorlicenseManagerList.size() > 0) {
                                                for (SbSponsorlicenseManager sbSponsorlicenseManager : sbSponsorlicenseManagerList) {
                                                    try {
                                                        sbSponsorlicenseManagerService.saveOrUpdateForDS(sbSponsorlicenseManager);
                                                    }catch(Exception e ){
                                                        logger.error(e.getMessage(),e);
                                                    }
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),sbSponsorlicenseManagerList.size());
                                            }
                                        }
                                    }else if (fs.getName().equals("sbsponsorlicenseVManager" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<SbSponsorlicenseVmanager> sbSponsorlicenseVmanagerList = JSONArray.parseArray(jsonStr, SbSponsorlicenseVmanager.class);
                                            //	logger.info(sbSponsorlicenseVmanagerList.size());
                                            if (sbSponsorlicenseVmanagerList != null && sbSponsorlicenseVmanagerList.size() > 0) {
                                                for (SbSponsorlicenseVmanager sbSponsorlicenseVmanager : sbSponsorlicenseVmanagerList) {
                                                    try {
                                                        sbSponsorlicenseVmanagerService.saveOrUpdateForDS(sbSponsorlicenseVmanager);
                                                    }catch(Exception e ){
                                                        logger.error(e.getMessage(),e);
                                                    }
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),sbSponsorlicenseVmanagerList.size());
                                            }
                                        }
                                    }else if (fs.getName().equals("confesscompanyundo" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<Confesscompanyundo> confesscompanyundoList = JSONArray.parseArray(jsonStr, Confesscompanyundo.class);
                                            if (confesscompanyundoList != null && confesscompanyundoList.size() > 0) {
                                                for (Confesscompanyundo confesscompanyundo : confesscompanyundoList) {
                                                    try {
                                                        confesscompanyundoService.saveOrUpdateForDS(confesscompanyundo);
                                                    } catch (Exception e) {
                                                        logger.error(e.getMessage(),e);
                                                    }

                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),confesscompanyundoList.size());
                                            }
                                        }
                                    }

                                    //保安员资格证书
                                    else if (fs.getName().equals("securitycertificate" + "_" + createTime + ".data")) {   
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<SecurityCertificate> securityCertificateList = JSONArray.parseArray(jsonStr, SecurityCertificate.class);
                                            if (securityCertificateList != null && securityCertificateList.size() > 0) {
                                                for (SecurityCertificate certificate : securityCertificateList) {
                                                    try {
                                                        securityCertificateService.saveOrUpdateForDS(certificate);
                                                    } catch (Exception e) {
                                                        logger.error(e.getMessage(),e);
                                                    }

                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),securityCertificateList.size());
                                            }
                                        }
                                    }

                                    else if (fs.getName().equals("shareholder" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<Shareholder> shareholderList = JSONArray.parseArray(jsonStr, Shareholder.class);
                                            if (shareholderList != null && shareholderList.size() > 0) {
                                                for (Shareholder shareholder : shareholderList) {
                                                	try {
                                                		shareholderService.saveOrUpdateForDS(shareholder);
													} catch (Exception e) {
														logger.error(e.getMessage(),e);
													}

                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),shareholderList.size());
                                            }
                                        }
                                    } else if (fs.getName().equals("approval" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<Approval> approvalList = JSONArray.parseArray(jsonStr, Approval.class);
                                            if (approvalList != null && approvalList.size() > 0) {
                                                for (Approval approval : approvalList) {
                                                    try {
                                                        approvalService.saveOrUpdateForDS(approval);
													} catch (Exception e) {
														logger.error(e.getMessage(),e);
                                                        e.printStackTrace();
													}
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),approvalList.size());
                                            }
                                        }
                                    }/* else if (fs.getName().equals("datasync" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<Datasync> datasyncList = JSONArray.parseArray(jsonStr, Datasync.class);
                                            //	logger.info(approvalList.size());
                                            if (datasyncList != null && datasyncList.size() > 0) {
                                                for (Datasync datasync : datasyncList) {
                                                    datasyncService.saveOrUpdateForDS(datasync);

                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName());
                                            }
                                        }
                                    }*/ else if (fs.getName().equals("order" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<Order> orderList = JSONArray.parseArray(jsonStr, Order.class);
                                            if (orderList != null && orderList.size() > 0) {
                                                for (Order order : orderList) {
                                                    try {
                                                    	orderService.saveOrUpdateForDS(order);
													} catch (Exception e) {
														logger.error(e.getMessage(),e);
													}
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),orderList.size());
                                            }
                                        }
                                    } else if (fs.getName().equals("orderPerson" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<OrderPerson> orderPersonList = JSONArray.parseArray(jsonStr, OrderPerson.class);
                                            if (orderPersonList != null && orderPersonList.size() > 0) {
                                                for (OrderPerson orderPerson : orderPersonList) {
                                                    try {
                                                    	orderPersonService.saveOrUpdateForDS(orderPerson);
													} catch (Exception e) {
														logger.error(e.getMessage(),e);
													}

                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),orderPersonList.size());
                                            }
                                        }
                                    } else if (fs.getName().equals("orderTransaction" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<OrderTransaction> orderTransactionList = JSONArray.parseArray(jsonStr, OrderTransaction.class);
                                            if (orderTransactionList != null && orderTransactionList.size() > 0) {
                                                for (OrderTransaction orderTransaction : orderTransactionList) {
                                                    try {
                                                    	orderTransactionService.saveOrUpdateForDS(orderTransaction);
													} catch (Exception e) {
														logger.error(e.getMessage(),e);
													}
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),orderTransactionList.size());
                                            }
                                        }
                                    } else if (fs.getName().equals("sbSubsidiaryBase" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<SbSubsidiaryBase> sbSubsidiaryBaseList = JSONArray.parseArray(jsonStr, SbSubsidiaryBase.class);
                                            if (sbSubsidiaryBaseList != null && sbSubsidiaryBaseList.size() > 0) {
                                                for (SbSubsidiaryBase sbSubsidiaryBase : sbSubsidiaryBaseList) {
                                                    try {
                                                    	sbSubsidiaryBaseService.saveOrUpdateForDS(sbSubsidiaryBase);
													} catch (Exception e) {
														logger.error(e.getMessage(),e);
													}
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),sbSubsidiaryBaseList.size());
                                            }
                                        }
                                    } else if (fs.getName().equals("sbSubsidiaryManager" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<SbSubsidiaryManager> sbSubsidiaryManagerList = JSONArray.parseArray(jsonStr, SbSubsidiaryManager.class);
                                            if (sbSubsidiaryManagerList != null && sbSubsidiaryManagerList.size() > 0) {
                                                for (SbSubsidiaryManager sbSubsidiaryManager : sbSubsidiaryManagerList) {
                                                    try {
                                                    	sbSubsidiaryManagerService.saveOrUpdateForDS(sbSubsidiaryManager);
													} catch (Exception e) {
														logger.error(e.getMessage(),e);
													}
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),sbSubsidiaryManagerList.size());
                                            }
                                        }
                                    } else if (fs.getName().equals("sbBusinessManagement" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<SbBusinessManagement> sbBusinessManagementList = JSONArray.parseArray(jsonStr, SbBusinessManagement.class);
                                            if (sbBusinessManagementList != null && sbBusinessManagementList.size() > 0) {
                                                for (SbBusinessManagement sbBusinessManagement : sbBusinessManagementList) {
                                                    try {
                                                    	sbBusinessManagementService.saveOrUpdateForDS(sbBusinessManagement);
													} catch (Exception e) {
														logger.error(e.getMessage(),e);
													}
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),sbBusinessManagementList.size());
                                            }
                                        }
                                    } else if (fs.getName().equals("sbBusinessOutsideManagement" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<SbBusinessOutsideManagement> sbBusinessOutsideManagementList = JSONArray.parseArray(jsonStr, SbBusinessOutsideManagement.class);
                                            if (sbBusinessOutsideManagementList != null && sbBusinessOutsideManagementList.size() > 0) {
                                                for (SbBusinessOutsideManagement sbBusinessOutsideManagement : sbBusinessOutsideManagementList) {
                                                    try {
                                                    	sbBusinessOutsideManagementService.saveOrUpdateForDS(sbBusinessOutsideManagement);
													} catch (Exception e) {
														logger.error(e.getMessage(),e);
													}
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),sbBusinessOutsideManagementList.size());
                                            }
                                        }
                                    } else if (fs.getName().equals("sbReward" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<SbReward> sbRewardList = JSONArray.parseArray(jsonStr, SbReward.class);
                                            if (sbRewardList != null && sbRewardList.size() > 0) {
                                                for (SbReward sbReward : sbRewardList) {
                                                    try {
                                                    	sbRewardService.saveOrUpdateForDS(sbReward);
													} catch (Exception e) {
														logger.error(e.getMessage(),e);
													}
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),sbRewardList.size());
                                            }
                                        }
                                    } else if (fs.getName().equals("sbPunish" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<SbPunish> sbPunishList = JSONArray.parseArray(jsonStr, SbPunish.class);
                                            if (sbPunishList != null && sbPunishList.size() > 0) {
                                                for (SbPunish sbPunish : sbPunishList) {
                                                    try {
                                                    	sbPunishService.saveOrUpdateForDS(sbPunish);
													} catch (Exception e) {
														logger.error(e.getMessage(),e);
													}
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),sbPunishList.size());
                                            }
                                        }
                                    } else if (fs.getName().equals("sponsorlicense" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<Sponsorlicense> sponsorlicenseList = JSONArray.parseArray(jsonStr, Sponsorlicense.class);
                                            if (sponsorlicenseList != null && sponsorlicenseList.size() > 0) {
                                                for (Sponsorlicense sponsorlicense : sponsorlicenseList) {
                                                    try {
                                                    	sponsorlicenseService.saveOrUpdateForDS(sponsorlicense);
													} catch (Exception e) {
														logger.error(e.getMessage(),e);
													}
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),sponsorlicenseList.size());
                                            }
                                        }
                                    } else if (fs.getName().equals("securityGoodThing" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<SecurityGoodThing> securityGoodThingList = JSONArray.parseArray(jsonStr, SecurityGoodThing.class);
                                            if (securityGoodThingList != null && securityGoodThingList.size() > 0) {
                                                for (SecurityGoodThing securityGoodThing : securityGoodThingList) {
                                                    try {
                                                    	securityGoodThingService.saveOrUpdateForDS(securityGoodThing);
													} catch (Exception e) {
														logger.error(e.getMessage(),e);
													}
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),securityGoodThingList.size());
                                            }
                                        }
                                    } else if (fs.getName().equals("vehicle" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<Vehicle> vehicleList = JSONArray.parseArray(jsonStr, Vehicle.class);
                                            if (vehicleList != null && vehicleList.size() > 0) {
                                                for (Vehicle vehicle : vehicleList) {
                                                    try {
                                                    	vehicleService.saveOrUpdateForDS(vehicle);
													} catch (Exception e) {
														logger.error(e.getMessage(),e);
													}
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),vehicleList.size());
                                            }
                                        }
                                    } else if (fs.getName().equals("vehicleLog" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<VehicleLog> vehicleLogList = JSONArray.parseArray(jsonStr, VehicleLog.class);
                                            if (vehicleLogList != null && vehicleLogList.size() > 0) {
                                                for (VehicleLog vehicleLog : vehicleLogList) {
                                                    try {
                                                    	vehicleLogService.saveOrUpdateForDS(vehicleLog);
													} catch (Exception e) {
														logger.error(e.getMessage(),e);
													}
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),vehicleLogList.size());
                                            }
                                        }
                                    } else if (fs.getName().equals("firearms" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<Firearms> firearmsList = JSONArray.parseArray(jsonStr, Firearms.class);
                                            if (firearmsList != null && firearmsList.size() > 0) {
                                                for (Firearms firearms : firearmsList) {
                                                    try {
                                                    	firearmsService.saveOrUpdateForDS(firearms);
													} catch (Exception e) {
														logger.error(e.getMessage(),e);
													}
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),firearmsList.size());
                                            }
                                        }
                                    } else if (fs.getName().equals("cyFirearmsLog" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<CyFirearmsLog> cyFirearmsLogList = JSONArray.parseArray(jsonStr, CyFirearmsLog.class);
                                            if (cyFirearmsLogList != null && cyFirearmsLogList.size() > 0) {
                                                for (CyFirearmsLog cyFirearmsLog : cyFirearmsLogList) {
                                                    try {
                                                    	cyFirearmsLogService.saveOrUpdateForDS(cyFirearmsLog);
													} catch (Exception e) {
														logger.error(e.getMessage(),e);
													}
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),cyFirearmsLogList.size());
                                            }
                                        }
                                    } else if (fs.getName().equals("safety" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<Safety> safetyList = JSONArray.parseArray(jsonStr, Safety.class);
                                            if (safetyList != null && safetyList.size() > 0) {
                                                for (Safety safety : safetyList) {
                                                    try {

                                                    	safetyService.saveOrUpdateForDS(safety);
													} catch (Exception e) {
														logger.error(e.getMessage(),e);
														e.printStackTrace();
													}
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),safetyList.size());
                                            }
                                        }
                                    } else if (fs.getName().equals("investor" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<Investor> investorList = JSONArray.parseArray(jsonStr, Investor.class);
                                            if (investorList != null && investorList.size() > 0) {
                                                for (Investor investor : investorList) {
                                                    try {
                                                    	investorService.saveOrUpdateForDS(investor);
													} catch (Exception e) {
														logger.error(e.getMessage(),e);
													}
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),investorList.size());
                                            }
                                        }
                                    } else if (fs.getName().equals("managementInfo" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<ManagementInfo> managementInfoList = JSONArray.parseArray(jsonStr, ManagementInfo.class);
                                            if (managementInfoList != null && managementInfoList.size() > 0) {
                                                for (ManagementInfo managementInfo : managementInfoList) {
                                                    try {
                                                    	managementInfoService.saveOrUpdateForDS(managementInfo);
													} catch (Exception e) {
														logger.error(e.getMessage(),e);
													}
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),managementInfoList.size());
                                            }
                                        }
                                    } else if (fs.getName().equals("cyServerht" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<CyServerht> cyServerhtList = JSONArray.parseArray(jsonStr, CyServerht.class);
                                            if (cyServerhtList != null && cyServerhtList.size() > 0) {
                                                for (CyServerht cyServerht : cyServerhtList) {
                                                    try {
                                                    	cyServerhtService.saveOrUpdateForDS(cyServerht);
													} catch (Exception e) {
														logger.error(e.getMessage(),e);
													}
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),cyServerhtList.size());
                                            }
                                        }
                                    }else if (fs.getName().equals("trainExamInfo" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<TrainExamInfo> trainExamInfoList = JSONArray.parseArray(jsonStr, TrainExamInfo.class);
                                            if (trainExamInfoList != null && trainExamInfoList.size() > 0) {
                                                for (TrainExamInfo trainExamInfo : trainExamInfoList) {
                                                    try {
                                                        trainExamInfoService.saveOrUpdateForDS(trainExamInfo);
                                                    } catch (Exception e) {
                                                        logger.error(e.getMessage(),e);
                                                    }
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),trainExamInfoList.size());
                                            }
                                        }
                                    }else if (fs.getName().equals("trainExamPerson" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<TrainExamPerson> trainExamPersonList = JSONArray.parseArray(jsonStr, TrainExamPerson.class);
                                            if (trainExamPersonList != null && trainExamPersonList.size() > 0) {
                                                for (TrainExamPerson trainExamPerson : trainExamPersonList) {
                                                    try {
                                                        trainExamPersonService.saveOrUpdateForDS(trainExamPerson);
                                                    } catch (Exception e) {
                                                        logger.error(e.getMessage(),e);
                                                    }
                                                }
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),trainExamPersonList.size());
                                            }
                                        }
                                    }else if (fs.getName().equals("approveAreaProcess" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<ApproveAreaProcess> areaProcessList = JSONArray.parseArray(jsonStr, ApproveAreaProcess.class);
                                            if (areaProcessList != null && areaProcessList.size() > 0) {
                                                approveAreaProcessService.updateFlagForOutToIn(areaProcessList);
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),areaProcessList.size());
                                            }
                                        }
                                    }else if (fs.getName().equals("approveLinkLevel" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<ApproveLinkLevel> linkLevelList = JSONArray.parseArray(jsonStr, ApproveLinkLevel.class);
                                            if (linkLevelList != null && linkLevelList.size() > 0) {
                                                approveLinkLevelService.updateFlagForOutToIn(linkLevelList);
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),linkLevelList.size());
                                            }
                                        }
                                    }else if (fs.getName().equals("approveTempLinkRela" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<ApproveTempLinkRela> linkRelaList = JSONArray.parseArray(jsonStr, ApproveTempLinkRela.class);
                                            if (linkRelaList != null && linkRelaList.size() > 0) {
                                                approveTempLinkService.updateFlagForOutToIn(linkRelaList);
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),linkRelaList.size());
                                            }
                                        }
                                    }else if (fs.getName().equals("securityGuard" + "_" + createTime + ".data")) {
                                        Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                        if (dbfilerecord == null) {
                                            List<SecurityGuard> list = JSONArray.parseArray(jsonStr, SecurityGuard.class);
                                            if (list != null && list.size() > 0) {
                                                securityGuardService.updateFlagForOutToIn(list);
                                                //将已读过的文件名记录
                                                saveFielrecord(fs.getAbsolutePath(),fs.getName(),list.size());
                                            }
                                        }
                                    }
                                } catch (BadPaddingException badPaddingException){
                                    logger.error("读取(" + fs.getName() + ")文件内容出错,非该区域文件");
                                    logger.error(fs.getName());
                                    badPaddingException.printStackTrace();
                                    logger.error(badPaddingException.getMessage());
                                    errorFlag = true;
                                    continue;
                                }
                                  catch (Exception e) {
                                    logger.error("读取(" + fs.getName() + ")文件内容出错");
                                    logger.error(fs.getName());
                                    e.printStackTrace();
                                    logger.error(e.getMessage(),e);
                                    errorFlag = true;
                                    continue;
                                }
                            } else {
                                logger.error("找不到指定的（" + fs.getName() + "）文件");
                            }
                        }
                        //如果文件没有读取错误
                        if(!errorFlag){
                            Config updateConfig = new Config();
                            updateConfig.setKey(Constants.LASTDATE);
                            updateConfig.setValue(DateUtil.convertDateToString(d,DateUtil.FORMAT2));
                            configUtils.updateForKey(updateConfig);
                        }
                    }
                }
            } else {
                //申报信息
                //生成文件，从外网生成需要同步的数据

                DataSynchronizationSearchDto searchDto = new DataSynchronizationSearchDto();
                searchDto.setPaging(false);
                searchDto.setStartDate(DateUtil.getYesterday());
                searchDto.setEndDate(DateUtil.getTomorrow());

                //TODO 公安机构
                List<Police> policeList = policeService.searchForDataSynchronization(searchDto);
                //TODO 公安角色
                List<PoliceRole> policeRoleList = policeRoleService.searchForDataSynchronization(searchDto);
                //TODO 用户txt
                List<User> userList = userService.searchForDataSynchronization(searchDto);
                //TODO 公司txt
                List<SecurityCompany> companyList = securityCompanyService.searchForDataSynchronization(searchDto);
                //TODO 角色txt
                List<Role> roleList = roleService.searchForDataSynchronization(searchDto);
                //TODO 组织架构txt
                List<Organization> organizationList = organizationService.searchForDataSynchronization(searchDto);
                //TODO 人员txt
                List<SecurityPerson> peopleList = securityPersonService.searchForDataSynchronization(searchDto);
                //公司班次信息
                List<SecurityCompanySchedule> securityCompanyScheduleList = securityCompanyScheduleService.searchForDataSynchronization(searchDto);
                //TODO 任务写入txt
                List<Task> taskList = taskService.searchForDataSynchronization(searchDto);
                //子任务
                List<TaskFeedback> taskFeedbackList = taskFeedbackService.searchForDataSynchronization(searchDto);
                //申报
                List<Approval> approvalList = approvalService.searchForDataSynchronization(searchDto);
                //TODO 自行招用txt
                List<Confesscompany> confesscompanyList = confesscompanyService.searchForDataSynchronization(searchDto);
                //TODO 跨区txt
                List<Crosscompany> crosscompanyList = crosscompanyService.searchForDataSynchronization(searchDto);
                //TODO 法人txt
                List<Legalchange> legalchangeList = legalchangeService.searchForDataSynchronization(searchDto);
                //TODO 法人工作简历txt
                List<Legalchangeworkexperience> legalchangeworkexperienceList = legalchangeworkexperienceService.searchForDataSynchronization(searchDto);
                //TODO 保安员txt
                List<Personcertificate> personcertificateList = personcertificateService.searchForDataSynchronization(searchDto);
                //TODO 子公司txt
                List<Subsidiary> subsidiaryList = subsidiaryService.searchForDataSynchronization(searchDto);
                //TODO 子公司备案txt
                List<Subsidiaryperson> subsidiarypersonList = subsidiarypersonService.searchForDataSynchronization(searchDto);
                //TODO 保安服务公司txt
                List<Sponsorlicense> sponsorlicenseList = sponsorlicenseService.searchForDataSynchronization(searchDto);
                //TODO 培训单位txt
                List<Traincompanyapply> traincompanyapplyList = traincompanyapplyService.searchForDataSynchronization(searchDto);
                //TODO 个人主要简历txt
                List<Workexperience> workexperienceList = workexperienceService.searchForDataSynchronization(searchDto);
                //TODO 家庭成员txt
                List<Family> familyList = familyService.searchForDataSynchronization(searchDto);
                //TODO 工作经历txt
                List<Personworkexperience> personworkexperienceList = personworkexperienceService.searchForDataSynchronization(searchDto);
                //TODO  股东出资额及所占比例txt
                List<Shareholder> shareholderList = shareholderService.searchForDataSynchronization(searchDto);
                //TODO  数据记录同步txt
                List<Datasync> datasyncsList = datasyncService.searchForDataSynchronization(searchDto);
                //TODO  培训订单人员txt
                List<OrderPerson> orderPersonList = orderPersonService.searchForDataSynchronization(searchDto);
                //TODO  培训订单交易txt
                List<OrderTransaction> orderTransactionList = orderTransactionService.searchForDataSynchronization(searchDto);
                //分公司信息SbSubsidiaryBase\SbSubsidiaryManager
                List<SbSubsidiaryBase> sbSubsidiaryBaseList = sbSubsidiaryBaseService.searchForDataSynchronization(searchDto);
                List<SbSubsidiaryManager> sbSubsidiaryManagerList = sbSubsidiaryManagerService.searchForDataSynchronization(searchDto);
                //跨区经营情况SbBusinessManagement、
                List<SbBusinessManagement> sbBusinessManagementList = sbBusinessManagementService.searchForDataSynchronization(searchDto);
                //海外经营信息SbBusinessOutsideManagement、
                List<SbBusinessOutsideManagement> sbBusinessOutsideManagementList = sbBusinessOutsideManagementService.searchForDataSynchronization(searchDto);
                //保安员奖励SbReward、
                List<SbReward> sbRewardList = sbRewardService.searchForDataSynchronization(searchDto);
                //保安员处罚SbPunish、
                List<SbPunish> sbPunishList = sbPunishService.searchForDataSynchronization(searchDto);
                //好人好事SecurityGoodThing、
                List<SecurityGoodThing> securityGoodThingList = securityGoodThingService.searchForDataSynchronization(searchDto);
                //车辆管理Vehicle、
                List<Vehicle> vehicleList = vehicleService.searchForDataSynchronization(searchDto);
                //车辆管理日志VehicleLog、
                List<VehicleLog> vehicleLogList = vehicleLogService.searchForDataSynchronization(searchDto);
                //枪支信息Firearms、
                List<Firearms> firearmsList = firearmsService.searchForDataSynchronization(searchDto);
                //枪支日志信息cyFirearmsLog、
                List<CyFirearmsLog> cyFirearmsLogList = cyFirearmsLogService.searchForDataSynchronization(searchDto);
                //技防设备Safety、
                List<Safety> safetyList = safetyService.searchForDataSynchronization(searchDto);
                //出资人信息Investor、
                List<Investor> investorList = investorService.searchForDataSynchronization(searchDto);
                //管理层信息ManagementInfo、
                List<ManagementInfo> managementInfoList = managementInfoService.searchForDataSynchronization(searchDto);
                //劳动合同 同person、
                //服务合同 CyServerht
                List<CyServerht> cyServerhtList = cyServerhtService.searchForDataSynchronization(searchDto);
                //公司消息同步
                List<NewsnoticeCompany> newsnoticeCompanyList = newsnoticeCompanyService.searchForDataSynchronization(searchDto);
                //消息通知同步
                List<NewsnoticePolice> newsnoticePoliceList = newsnoticePoliceService.
                        searchForDataSynchronization(searchDto);

                //公司与消息关系信息表同步
                List<NewsCompanyRelationship> newsCompanyRelationshipList = newsCompanyRelationshipService.searchForDataSynchronization(searchDto);
                //存放系统附件信息表同步
                List<SysAttachment> sysAttachmentList = sysAttachmentService.searchForDataSynchronization(searchDto);
                //消息接收人表同步
                List<NewsnoticeRecipient> newsnoticeRecipientList = newsnoticeRecipientService.searchForDataSynchronization(searchDto);

                //自招撤销备案 txt
                List<Confesscompanyundo> confesscompanyundoList = confesscompanyundoService.searchForDataSynchronization(searchDto);
                //保安员资格证书 txt
                List<SecurityCertificate> securityCertificateList = securityCertificateService.searchForDataSynchronization(searchDto);

                List<SbSponsorlicenseManager> sbSponsorlicenseManagerList = sbSponsorlicenseManagerService.searchForDataSynchronization(searchDto);
                List<SbSponsorlicenseVmanager> sbSponsorlicenseVmanagerList = sbSponsorlicenseVmanagerService.searchForDataSynchronization(searchDto);

                //考试信息
                List<TrainExamInfo>  trainExamInfoList = trainExamInfoService.searchForDataSynchronization(searchDto);
                //考试人员信息
                List<TrainExamPerson>  trainExamPersonList = trainExamPersonService.searchForDataSynchronization(searchDto);

                List<ApproveAreaProcess> areaProcessList = approveAreaProcessService.searchForDataSynchronization(searchDto);

                List<ApproveLinkLevel> linkLevelList = approveLinkLevelService.searchForDataSynchronization(searchDto);

                List<ApproveTempLinkRela> linkRelaList = approveTempLinkService.searchForDataSynchronization(searchDto);
                //保安师
                List<SecurityGuard> securityGuardList = securityGuardService.searchForDataSynchronization(searchDto);


                if (trainExamInfoList != null && trainExamInfoList.size() > 0) {
                    try {
                        String trainExamInfoListStr = JSONArray.toJSONString(trainExamInfoList);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(trainExamInfoListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "trainExamInfo");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                if (trainExamPersonList != null && trainExamPersonList.size() > 0) {
                    try {
                        String trainExamPersonListStr = JSONArray.toJSONString(trainExamPersonList);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(trainExamPersonListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "trainExamPerson");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                if (sbSponsorlicenseManagerList != null && sbSponsorlicenseManagerList.size() > 0) {
                    try {
                        String sbSponsorlicenseManagerListStr = JSONArray.toJSONString(sbSponsorlicenseManagerList);
                        //      logger.info(sbSponsorlicenseManagerListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(sbSponsorlicenseManagerListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "sbsponsorlicenseManager");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                if (sbSponsorlicenseVmanagerList != null && sbSponsorlicenseVmanagerList.size() > 0) {
                    try {
                        String sbSponsorlicenseVmanagerListStr = JSONArray.toJSONString(sbSponsorlicenseVmanagerList);
                        //      logger.info(sbSponsorlicenseManagerListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(sbSponsorlicenseVmanagerListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "sbsponsorlicenseVManager");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                if (policeList != null && policeList.size() > 0) {
                    try {
                        String policeListStr = JSONArray.toJSONString(policeList);
                        //      logger.info(userListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(policeListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "police");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                if (policeRoleList != null && policeRoleList.size() > 0) {
                	try {
                		String policeRoleListStr = JSONArray.toJSONString(policeRoleList);
                		//      logger.info(userListStr);
                		String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(policeRoleListStr.getBytes(), Constants.APPROVAL_KEY));
                		writeTxtFile(content, "policeRole");
                	} catch (Exception e) {
                		logger.error(e.getMessage(),e);
                	}
                }

                if (userList != null && userList.size() > 0) {
                	try {
                		String userListStr = JSONArray.toJSONString(userList);
                		//      logger.info(userListStr);
                		String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(userListStr.getBytes(), Constants.APPROVAL_KEY));
                		writeTxtFile(content, "user");
                	} catch (Exception e) {
                		logger.error(e.getMessage(),e);
                	}
                }

                if (companyList != null && companyList.size() > 0) {
                    try {
                        String companyListStr = JSONArray.toJSONString(companyList);
                        //   logger.info(companyListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(companyListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "company");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }
                if (roleList != null && roleList.size() > 0) {
                    try {
                        String roleListStr = JSONArray.toJSONString(roleList);
                        //    logger.info(roleListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(roleListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "role");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                if (organizationList != null && organizationList.size() > 0) {
                    try {
                        String organizationListStr = JSONArray.toJSONString(organizationList);
                        //     logger.info(organizationListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(organizationListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "organization");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                if (peopleList != null && peopleList.size() > 0) {
                    try {
                        String securityPeopleListStr = JSONArray.toJSONString(peopleList);
                        //        logger.info(securityPeopleListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(securityPeopleListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "person");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                if (securityCompanyScheduleList != null && securityCompanyScheduleList.size() > 0) {
                    try {
                        String securityCompanyScheduleListStr = JSONArray.toJSONString(securityCompanyScheduleList);
                        //	logger.info(securityCompanyScheduleListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(securityCompanyScheduleListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "securityCompanySchedule");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                if (taskList != null && taskList.size() > 0) {
                    try {
                        String taskListStr = JSONArray.toJSONString(taskList);
                        //	logger.info(taskListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(taskListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "task");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                if (taskFeedbackList != null && taskFeedbackList.size() > 0) {
                    try {
                        String taskFeedbackListStr = JSONArray.toJSONString(taskFeedbackList);
                        //	logger.info(taskFeedbackListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(taskFeedbackListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "taskFeedback");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                if (approvalList != null && approvalList.size() > 0) {
                    try {
                        String approvalListStr = JSONArray.toJSONString(approvalList);
                        //	logger.info(approvalListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(approvalListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "approval");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                if (confesscompanyList != null && confesscompanyList.size() > 0) {
                    try {
                        String confesscompanyListStr = JSONArray.toJSONString(confesscompanyList);
                        //      logger.info(confesscompanyListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(confesscompanyListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "confesscompany");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }
                if (crosscompanyList != null && crosscompanyList.size() > 0) {
                    try {
                        String crosscompanyListStr = JSONArray.toJSONString(crosscompanyList);
                        //     logger.info(crosscompanyListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(crosscompanyListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "crosscompany");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                if (legalchangeList != null && legalchangeList.size() > 0) {
                    try {
                        String legalchangeListStr = JSONArray.toJSONString(legalchangeList);
                        //      logger.info(legalchangeListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(legalchangeListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "legalchange");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                if (legalchangeworkexperienceList != null && legalchangeworkexperienceList.size() > 0) {
                    try {
                        String legalchangeworkexperienceListStr = JSONArray.toJSONString(legalchangeworkexperienceList);
                        //      logger.info(legalchangeListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(legalchangeworkexperienceListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "legalchangeworkexperience");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                if (personcertificateList != null && personcertificateList.size() > 0) {
                    try {
                        String personcertificateListStr = JSONArray.toJSONString(personcertificateList);
                        //        logger.info(personcertificateListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(personcertificateListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "personcertificate");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                if (sponsorlicenseList != null && sponsorlicenseList.size() > 0) {
                    try {
                        String sponsorlicenseListStr = JSONArray.toJSONString(sponsorlicenseList);
                        //     logger.info(sponsorlicenseListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(sponsorlicenseListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "sponsorlicense");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                if (subsidiaryList != null && subsidiaryList.size() > 0) {
                    try {
                        String subsidiaryListStr = JSONArray.toJSONString(subsidiaryList);
                        //     logger.info(subsidiaryListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(subsidiaryListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "subsidiary");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                if (subsidiarypersonList != null && subsidiarypersonList.size() > 0) {
                    try {
                        String subsidiarypersonListStr = JSONArray.toJSONString(subsidiarypersonList);
                        //  logger.info(subsidiarypersonListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(subsidiarypersonListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "subsidiaryperson");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                if (traincompanyapplyList != null && traincompanyapplyList.size() > 0) {
                    try {
                        String traincompanyapplyListStr = JSONArray.toJSONString(traincompanyapplyList);
                        //    logger.info(traincompanyapplyListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(traincompanyapplyListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "traincompanyapply");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                if (workexperienceList != null && workexperienceList.size() > 0) {
                    try {
                        String workexperienceListStr = JSONArray.toJSONString(workexperienceList);
                        // logger.info(workexperienceListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(workexperienceListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "workexperience");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                //TODO 年度报告txt
                List<Yearreportdata> yearreportList = yearreportDataService.searchForDataSynchronization(searchDto);
                if (yearreportList != null && yearreportList.size() > 0) {
                    try {
                        String yearreportListStr = JSONArray.toJSONString(yearreportList);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(yearreportListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "yearreport");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                List<SecurityCompanyInsurance> securityCompanyInsuranceList = securityCompanyInsuranceService.searchForDataSynchronization(searchDto);
                if (securityCompanyInsuranceList != null && securityCompanyInsuranceList.size() > 0) {
                    try {
                        String securityCompanyInsuranceListStr = JSONArray.toJSONString(securityCompanyInsuranceList);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(securityCompanyInsuranceListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "securityCompanyInsurance");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                List<YearreportdataManager> yearreportdataManagerList = yearreportdataManagerService.searchForDataSynchronization(searchDto);
                if (yearreportdataManagerList != null && yearreportdataManagerList.size() > 0) {
                    try {
                        String yearreportdataManagerListStr = JSONArray.toJSONString(yearreportdataManagerList);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(yearreportdataManagerListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "yearreportdataManager");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                List<YearReportInvestor> yearReportInvestorList = yearReportInvestorService.searchForDataSynchronization(searchDto);
                if (yearReportInvestorList != null && yearReportInvestorList.size() > 0) {
                	try {
                		String yearReportInvestorListStr = JSONArray.toJSONString(yearReportInvestorList);
                		String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(yearReportInvestorListStr.getBytes(), Constants.APPROVAL_KEY));
                		writeTxtFile(content, "yearReportInvestor");
                	} catch (Exception e) {
                		logger.error(e.getMessage(),e);
                	}
                }

                List<YearReportInsurance> yearReportInsuranceList = yearReportInsuranceService.searchForDataSynchronization(searchDto);
                if (yearReportInsuranceList != null && yearReportInsuranceList.size() > 0) {
                	try {
                		String yearReportInsuranceListStr = JSONArray.toJSONString(yearReportInsuranceList);
                		String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(yearReportInsuranceListStr.getBytes(), Constants.APPROVAL_KEY));
                		writeTxtFile(content, "yearReportInsurance");
                	} catch (Exception e) {
                		logger.error(e.getMessage(),e);
                	}
                }

                //TODO 枪支培训txt
                List<Armtrainorg> armtrainorgList = armtrainorgService.searchForDataSynchronization(searchDto);
                if (armtrainorgList != null && armtrainorgList.size() > 0) {
                    try {
                        String armtrainorgListStr = JSONArray.toJSONString(armtrainorgList);
                        //   logger.info(armtrainorgListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(armtrainorgListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "armtrainorg");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                List<Armorgteach> armorgteachList = armorgteachService.searchForDataSynchronization(searchDto);
                if (armorgteachList != null && armorgteachList.size() > 0) {
                    try {
                        String armorgteachListStr = JSONArray.toJSONString(armorgteachList);
                        //   logger.info(armtrainorgListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(armorgteachListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "armorgteach");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                List<Armtraincharge> armtrainchargeList = armtrainchargeService.searchForDataSynchronization(searchDto);
                if (armtrainchargeList != null && armtrainchargeList.size() > 0) {
                    try {
                        String armtrainchargeListStr = JSONArray.toJSONString(armtrainchargeList);
                        //   logger.info(armtrainorgListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(armtrainchargeListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "armtraincharge");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                List<Armorgcharge> armorgchargeList = armorgchargeService.searchForDataSynchronization(searchDto);
                if (armorgchargeList != null && armorgchargeList.size() > 0) {
                    try {
                        String armorgchargeListStr = JSONArray.toJSONString(armorgchargeList);
                        //   logger.info(armtrainorgListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(armorgchargeListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "armorgcharge");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                if (familyList != null && familyList.size() > 0) {
                    try {
                        String familyListStr = JSONArray.toJSONString(familyList);
                        //   logger.info(familyListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(familyListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "family");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                if (personworkexperienceList != null && personworkexperienceList.size() > 0) {
                    try {
                        String personworkexperienceListStr = JSONArray.toJSONString(personworkexperienceList);
//                    logger.info(personworkexperienceListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(personworkexperienceListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "personworkexperience");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                if (shareholderList != null && shareholderList.size() > 0) {
                    try {
                        String shareholderListStr = JSONArray.toJSONString(shareholderList);
                        //      logger.info(shareholderListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(shareholderListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "shareholder");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                if (datasyncsList != null && datasyncsList.size() > 0) {
                    try {
                        String datasyncsListStr = JSONArray.toJSONString(datasyncsList);
                        //      logger.info(shareholderListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(datasyncsListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "datasync");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                //TODO  培训订单txt
                List<Order> orderList = orderService.searchForDataSynchronization(searchDto);
                if (orderList != null && orderList.size() > 0) {
                    try {
                        String orderListStr = JSONArray.toJSONString(orderList);
                        //      logger.info(shareholderListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(orderListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "order");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                if (orderPersonList != null && orderPersonList.size() > 0) {
                    try {
                        String orderPersonListStr = JSONArray.toJSONString(orderPersonList);
                        //      logger.info(shareholderListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(orderPersonListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "orderPerson");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                if (orderPersonList != null && orderPersonList.size() > 0) {
                    try {
                        String orderTransactionListStr = JSONArray.toJSONString(orderTransactionList);
                        //      logger.info(shareholderListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(orderTransactionListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "orderTransaction");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                if (orderPersonList != null && orderPersonList.size() > 0) {
                    try {
                        String sbSubsidiaryBaseListStr = JSONArray.toJSONString(sbSubsidiaryBaseList);
                        //      logger.info(shareholderListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(sbSubsidiaryBaseListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "sbSubsidiaryBase");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                if (sbSubsidiaryManagerList != null && sbSubsidiaryManagerList.size() > 0) {
                    try {
                        String sbSubsidiaryManagerListStr = JSONArray.toJSONString(sbSubsidiaryManagerList);
                        //      logger.info(shareholderListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(sbSubsidiaryManagerListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "sbSubsidiaryManager");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                //投诉建议 TODO
                //公司信息，分公司信息、
                if (sbBusinessManagementList != null && sbBusinessManagementList.size() > 0) {
                    try {
                        String sbBusinessManagementListStr = JSONArray.toJSONString(sbBusinessManagementList);
                        //      logger.info(shareholderListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(sbBusinessManagementListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "sbBusinessManagement");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }
                if (sbBusinessOutsideManagementList != null && sbBusinessOutsideManagementList.size() > 0) {
                    try {
                        String sbBusinessOutsideManagementListStr = JSONArray.toJSONString(sbBusinessOutsideManagementList);
                        //      logger.info(shareholderListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(sbBusinessOutsideManagementListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "sbBusinessOutsideManagement");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                if (sbRewardList != null && sbRewardList.size() > 0) {
                    try {
                        String sbRewardListStr = JSONArray.toJSONString(sbRewardList);
                        //      logger.info(shareholderListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(sbRewardListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "sbReward");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }
                if (sbPunishList != null && sbPunishList.size() > 0) {
                    try {
                        String sbPunishListStr = JSONArray.toJSONString(sbPunishList);
                        //      logger.info(shareholderListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(sbPunishListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "sbPunish");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }
                if (securityGoodThingList != null && securityGoodThingList.size() > 0) {
                    try {
                        String securityGoodThingListStr = JSONArray.toJSONString(securityGoodThingList);
                        //      logger.info(shareholderListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(securityGoodThingListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "securityGoodThing");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }
                if (vehicleList != null && vehicleList.size() > 0) {
                    try {
                        String vehicleListStr = JSONArray.toJSONString(vehicleList);
                        //      logger.info(shareholderListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(vehicleListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "vehicle");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }
                if (vehicleLogList != null && vehicleLogList.size() > 0) {
                    try {
                        String vehicleLogListStr = JSONArray.toJSONString(vehicleLogList);
                        //      logger.info(shareholderListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(vehicleLogListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "vehicleLog");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }
                if (firearmsList != null && firearmsList.size() > 0) {
                    try {
                        String firearmsListStr = JSONArray.toJSONString(firearmsList);
                        //      logger.info(shareholderListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(firearmsListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "firearms");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }
                if (cyFirearmsLogList != null && cyFirearmsLogList.size() > 0) {
                    try {
                        String cyFirearmsLogListStr = JSONArray.toJSONString(cyFirearmsLogList);
                        //      logger.info(shareholderListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(cyFirearmsLogListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "cyFirearmsLog");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }
                if (safetyList != null && safetyList.size() > 0) {
                    try {
                        String safetyListStr = JSONArray.toJSONString(safetyList);
                        //      logger.info(shareholderListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(safetyListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "safety");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }
                if (investorList != null && investorList.size() > 0) {
                    try {
                        String investorListStr = JSONArray.toJSONString(investorList);
                        //      logger.info(shareholderListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(investorListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "investor");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }
                if (managementInfoList != null && managementInfoList.size() > 0) {
                    try {
                        String managementInfoListStr = JSONArray.toJSONString(managementInfoList);
                        //      logger.info(shareholderListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(managementInfoListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "managementInfo");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }
                if (cyServerhtList != null && cyServerhtList.size() > 0) {
                    try {
                        String cyServerhtListStr = JSONArray.toJSONString(cyServerhtList);
                        //      logger.info(shareholderListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(cyServerhtListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "cyServerht");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                if (newsnoticeCompanyList != null && newsnoticeCompanyList.size() > 0) {
                    try {
                        String newsnoticeCompanyListStr = JSONArray.toJSONString(newsnoticeCompanyList);
                        //      logger.info(userListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(newsnoticeCompanyListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "newsnoticeCompany");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                if (newsnoticePoliceList != null && newsnoticePoliceList.size() > 0) {
                    try {
                        String newsnoticePoliceListStr = JSONArray.toJSONString(newsnoticePoliceList);
                        //      logger.info(userListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(newsnoticePoliceListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "newsnoticePolice");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                if (newsCompanyRelationshipList != null && newsCompanyRelationshipList.size() > 0) {
                    try {
                        String newsCompanyRelationshipListStr = JSONArray.toJSONString(newsCompanyRelationshipList);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(newsCompanyRelationshipListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "newsCompanyRelationship");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                if (sysAttachmentList != null && sysAttachmentList.size() > 0) {
                    try {
                        String sysAttachmentListStr = JSONArray.toJSONString(sysAttachmentList);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(sysAttachmentListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "sysAttachment");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                if (newsnoticeRecipientList != null && newsnoticeRecipientList.size() > 0) {
                    try {
                        String newsnoticeRecipientListStr = JSONArray.toJSONString(newsnoticeRecipientList);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(newsnoticeRecipientListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "newsnoticeRecipient");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }
                if (confesscompanyundoList != null && confesscompanyundoList.size() > 0) {
                    try {
                        String confesscompanyundoListStr = JSONArray.toJSONString(confesscompanyundoList);
                        //     logger.info(confesscompanyundoListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(confesscompanyundoListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "confesscompanyundo");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                //保安员资格证文件生成
                if (securityCertificateList != null && securityCertificateList.size() > 0) {
                    try {
                        String securityCertificateListStr = JSONArray.toJSONString(securityCertificateList);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(securityCertificateListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "securitycertificate");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                if (areaProcessList != null && areaProcessList.size() > 0) {
                    try {
                        String areaProcessListStr = JSONArray.toJSONString(areaProcessList);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(areaProcessListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "approveAreaProcess");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                if (linkLevelList != null && linkLevelList.size() > 0) {
                    try {
                        String linkLevelListStr = JSONArray.toJSONString(linkLevelList);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(linkLevelListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "approveLinkLevel");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }

                if (linkRelaList != null && linkRelaList.size() > 0) {
                    try {
                        String linkRelaListStr = JSONArray.toJSONString(linkRelaList);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(linkRelaListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "approveTempLinkRela");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }
                if (securityGuardList != null && securityGuardList.size() > 0) {
                    try {
                        String securityGuardListStr = JSONArray.toJSONString(securityGuardList);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(securityGuardListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "securityGuard");
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }
                //全部生成完，复制到正式目录 ftpFolder
                try {
                    copyDir(tempftpFolder + nowStr, ftpFolder + nowStr);
                } catch (IOException e) {
                    logger.error(e.getMessage(),e);
                }
            }
        }
    }

    private void writeTxtFile(String readStr, String type) {
//    	logger.info(type);
        try {
            String basePath = tempftpFolder;    //路径
            String filePath = basePath + DateUtil.getCurrentDate() + File.separator;//保存路径

            String fileName = type;
            String fileType = ".data";
            File file = new File(filePath);
            if (!file.exists()) {
                file.mkdirs();
                logger.info("文件夹已创建");
            }
            String fullFilePath = filePath + fileName + "_"+ DateUtil.getCurrentDateTime(DateUtil.FORMAT8) + fileType;

            saveFielrecordOut(fullFilePath,fileName + "_"+ DateUtil.getCurrentDateTime(DateUtil.FORMAT8) + fileType);
            //文件处理：写入文件
            File newFile = new File(fullFilePath);
            Files.write(readStr.getBytes(), newFile);
        } catch (Exception e) {
            //logger.info("导出失败！");
            logger.error(e.getMessage(),e);
        }
    }

    public static void copyDir(String oldPath, String newPath) throws IOException {
        File file = new File(oldPath);
        String[] filePath = file.list();

        if (!(new File(newPath)).exists()) {
            (new File(newPath)).mkdir();
        }

        if(filePath == null) {
            return;
        }
        for (int i = 0; i < filePath.length; i++) {
            if ((new File(oldPath + File.separator + filePath[i])).isDirectory()) {
                copyDir(oldPath  + File.separator  + filePath[i], newPath  + File.separator + filePath[i]);
            }

            if (new File(oldPath  + File.separator + filePath[i]).isFile()) {
                File from = new File(oldPath + File.separator + filePath[i]);
                File to = new File(newPath + File.separator + filePath[i]);
                if(!to.exists()){
                    Files.copy(from, to);
                }
            }
        }
    }

    /*
    判断是否已经读过
     */
    public Filerecord isFilerecord(String filename){
        Filerecord dbfilerecord = filerecordDao.findByFilepath(filename);
        if(dbfilerecord==null){
            logger.info("开始读取文件："+filename);
        }
        return dbfilerecord;
    }

    public  void saveFielrecord(String filepath,String filename,Integer recordsize){
        //将已读过的文件名记录
        Filerecord filerecord = new Filerecord();
        filerecord.setFilepath(filepath);
        filerecord.setFilename(filename);
        filerecord.setCreateTime(new Date());
        filerecord.setSynchtype(filename.substring(0,filename.indexOf("_")));
        filerecord.setUpdateTime(filerecord.getCreateTime());
        filerecord.setRecordsize(recordsize);
        filerecordDao.save(filerecord);
        logger.info("读取文件完成："+filename);
    }

    public  void saveFielrecordOut(String filepath,String filename){
        //将已写过的文件名记录
        FilerecordOut filerecordOut = new FilerecordOut();
        filerecordOut.setFilepath(filepath);
        filerecordOut.setFilename(filename);
        filerecordOut.setSynchtype(filename.substring(0,filename.indexOf("_")));
        filerecordOut.setCreateTime(new Date());
        filerecordOut.setUpdateTime(filerecordOut.getCreateTime());
        filerecordOutDao.save(filerecordOut);

        logger.info("写入文件完成："+filename);
    }
}
