/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.timer.problemPerson;

import cn.hutool.core.thread.ThreadUtil;
import com.bcxin.ars.dto.sb.BackgroundApprovalDto;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.service.bean.factory.BackGroupCensorServiceBeanFactory;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.webservice.BackGroupCensorService;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ProblemPersonCriminalServiceJob {
    private static final Logger logger = LoggerFactory.getLogger(ProblemPersonCriminalServiceJob.class);
    @Autowired
    private SecurityPersonService securityPersonService;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private JobRunLogService jobRunLogService;
    private static BackGroupCensorService backGroupCensorService;
    @Value(value="${ZAFLAG}")
    private String ZAFLAG;
    private boolean lock = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block22: {
            if (this.lock) {
                return;
            }
            this.lock = true;
            try {
                long startTime;
                JobRunLog log;
                block23: {
                    String bg_switch = this.configUtils.getValueByKey("bg_switch");
                    if ("0".equals(bg_switch)) {
                        return;
                    }
                    if (backGroupCensorService == null) {
                        backGroupCensorService = BackGroupCensorServiceBeanFactory.getBackGroupCensorServiceBean();
                    }
                    if (!this.configUtils.isIntranet() || this.ZAFLAG == null || !"1".equals(this.ZAFLAG)) break block22;
                    log = new JobRunLog();
                    log.setCreateTime(new Date());
                    log.setActive(Boolean.valueOf(true));
                    log.setUpdateBy("jobSystem");
                    startTime = System.currentTimeMillis();
                    try {
                        List personList = this.securityPersonService.findNoPassCensorStatus();
                        if (personList.size() <= 0) break block23;
                        int limit = 100;
                        int count = new Double(Math.ceil((double)personList.size() * 1.0 / (double)limit)).intValue();
                        List subList = null;
                        for (int i = 0; i < count; ++i) {
                            subList = personList.stream().skip(i * limit).limit(limit).collect(Collectors.toList());
                            final CountDownLatch countDownLatch = ThreadUtil.newCountDownLatch((int)subList.size());
                            ThreadPoolExecutor threadPoolExecutor = ThreadUtil.newExecutor((int)15, (int)15);
                            for (final SecurityPerson securityPerson : subList) {
                                threadPoolExecutor.execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            BackgroundApprovalDto dto = new BackgroundApprovalDto();
                                            dto.setIdNumber(securityPerson.getIdNumber());
                                            dto.setRealName(securityPerson.getRealName());
                                            dto.setBusinessid(securityPerson.getId());
                                            dto.setBusinesstype("15");
                                            List backgroundApprovals = backGroupCensorService.censorFromBase(dto, false);
                                            securityPerson.setBackgroundApprovals(backgroundApprovals);
                                        }
                                        catch (Exception e) {
                                            logger.error(e.getMessage(), (Throwable)e);
                                        }
                                        finally {
                                            countDownLatch.countDown();
                                        }
                                    }
                                });
                            }
                            try {
                                countDownLatch.await();
                            }
                            catch (InterruptedException e) {
                                logger.error(e.getMessage(), (Throwable)e);
                                Thread.currentThread().interrupt();
                            }
                            finally {
                                threadPoolExecutor.shutdown();
                            }
                            final CountDownLatch countDownLatch1 = ThreadUtil.newCountDownLatch((int)subList.size());
                            ThreadPoolExecutor threadPoolExecutor1 = ThreadUtil.newExecutor((int)30, (int)30);
                            for (final SecurityPerson securityPerson : subList) {
                                threadPoolExecutor1.execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            backGroupCensorService.censorSaveProblemPersonNoPassCensorStatus(securityPerson, securityPerson.getBackgroundApprovals());
                                        }
                                        catch (Exception e) {
                                            logger.error(e.getMessage(), (Throwable)e);
                                        }
                                        finally {
                                            countDownLatch1.countDown();
                                        }
                                    }
                                });
                            }
                            try {
                                countDownLatch1.await();
                                continue;
                            }
                            catch (InterruptedException e) {
                                logger.error(e.getMessage(), (Throwable)e);
                                Thread.currentThread().interrupt();
                                continue;
                            }
                            finally {
                                threadPoolExecutor1.shutdown();
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        log.setExceptionMsg(e.toString());
                    }
                }
                long endTime = System.currentTimeMillis();
                log.setUpdateTime(new Date());
                log.setJobName(ProblemPersonCriminalServiceJob.class.getName());
                log.setRunTime(new Date());
                log.setRunTimeLength(endTime - startTime + "ms");
                this.jobRunLogService.insert(log);
            }
            finally {
                this.lock = false;
            }
        }
    }
}

