/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.timer.personcertificate;

import com.bcxin.ars.dao.PersonBaseInfoDao;
import com.bcxin.ars.dao.PersonImgDao;
import com.bcxin.ars.model.PersonBaseInfo;
import com.bcxin.ars.model.PersonImg;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.PhotoUtil;
import com.bcxin.ars.util.GetPersonImgUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PersonImgToPersonBaseInfoService {
    private Logger logger = LoggerFactory.getLogger(PersonImgToPersonBaseInfoService.class);
    @Autowired
    GetPersonImgUtil getPersonImgUtil;
    @Autowired
    PersonImgDao personImgDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private JobRunLogService jobRunLogService;
    @Autowired
    private PhotoUtil photoUtil;
    @Autowired
    private PersonBaseInfoDao personBaseInfoDao;
    private boolean lock = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block18: {
            if (this.lock) {
                return;
            }
            this.lock = true;
            try {
                if (!"true".equals(this.configUtils.timeFlag) || !this.configUtils.isIntranet()) break block18;
                if ("11".equals(this.configUtils.getCurrentNative())) {
                    return;
                }
                JobRunLog log = new JobRunLog();
                log.setCreateTime(new Date());
                log.setActive(Boolean.valueOf(true));
                log.setUpdateBy("jobSystem");
                long startTime = System.currentTimeMillis();
                try {
                    List list = this.personImgDao.findUnChageList();
                    ArrayList<PersonBaseInfo> saveList = new ArrayList<PersonBaseInfo>();
                    if (list.size() > 0) {
                        PersonBaseInfo personBaseInfo = null;
                        for (PersonImg personImg : list) {
                            try {
                                personBaseInfo = new PersonBaseInfo();
                                personBaseInfo.setIdnum(personImg.getIdNumber());
                                personBaseInfo.setPhoto(GetPersonImgUtil.getImageString((byte[])personImg.getIdImage()));
                                personBaseInfo.setUpdateflag(Boolean.valueOf(true));
                                personBaseInfo.setActive(Boolean.valueOf(true));
                                personBaseInfo.setCreateTime(new Date());
                                personBaseInfo.setUpdateTime(new Date());
                                if (list.size() == 500) {
                                    this.photoUtil.saveRandomPhoto(personBaseInfo);
                                } else {
                                    this.photoUtil.savePhoto(personBaseInfo);
                                }
                                saveList.add(personBaseInfo);
                            }
                            catch (Exception e) {
                                this.logger.error(e.getMessage(), (Throwable)e);
                            }
                        }
                        if (saveList.size() > 0) {
                            int limit = 100;
                            int count = new Double(Math.ceil((double)saveList.size() * 1.0 / (double)limit)).intValue();
                            List subList = null;
                            for (int i = 0; i < count; ++i) {
                                subList = saveList.stream().skip(i * limit).limit(limit).collect(Collectors.toList());
                                this.personBaseInfoDao.saveBatch(subList);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                    log.setExceptionMsg(e.toString());
                }
                long endTime = System.currentTimeMillis();
                log.setUpdateTime(new Date());
                log.setJobName(PersonImgToPersonBaseInfoService.class.getName());
                log.setRunTime(new Date());
                log.setRunTimeLength(endTime - startTime + "ms");
                this.jobRunLogService.insert(log);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                this.lock = false;
            }
        }
    }
}

