/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.timer.person;

import com.abcxin.smart.validator.annotation.JobLogAnnotation;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.PersonBaseInfo;
import com.bcxin.ars.service.PersonBaseInfoService;
import com.bcxin.ars.service.bean.factory.BackGroupCensorServiceBeanFactory;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.ImgUtils;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.webservice.BackGroupCensorService;
import java.io.File;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AutoGetPersonBaseInfo {
    private Logger logger = LoggerFactory.getLogger(AutoGetPersonBaseInfo.class);
    @Autowired
    private PersonBaseInfoService personBaseInfoService;
    private static BackGroupCensorService backGroupCensorService;
    @Autowired
    private ConfigUtils configUtils;
    @Value(value="${timeFlag}")
    private String timeFlag = "";
    @Value(value="${base-folder}")
    private String baseFolder;
    @Value(value="${personImg-folder}")
    private String personImgPath = "";
    private boolean lock = false;

    private void getBackGroupCensorService() {
        if (backGroupCensorService == null) {
            backGroupCensorService = BackGroupCensorServiceBeanFactory.getBackGroupCensorServiceBean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JobLogAnnotation(getJobClazz=AutoGetPersonBaseInfo.class)
    public void run() {
        if (this.lock) {
            return;
        }
        this.lock = true;
        try {
            this.logger.info("begin to AutoGetPersonBaseInfo...");
            this.getBackGroupCensorService();
            Config config = this.configUtils.getConfigByKey("police");
            if (config.getValue().equals("1") && this.timeFlag.equals("true") && "11".equals(this.configUtils.getCurrentNative())) {
                List baseInfoList = this.personBaseInfoService.findUnGetBaseInfoList();
                for (String idNum : baseInfoList) {
                    try {
                        PersonBaseInfo personBaseInfo = backGroupCensorService.getPopulationInfo(idNum, true);
                        personBaseInfo.setCreateTime(new Date());
                        personBaseInfo.setActive(Boolean.valueOf(true));
                        this.savePhoto(personBaseInfo);
                        this.personBaseInfoService.save(personBaseInfo);
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
            this.logger.info("AutoGetPersonBaseInfo done.");
        }
        finally {
            this.lock = false;
        }
    }

    private void savePhoto(PersonBaseInfo personBaseInfo) {
        personBaseInfo.setState("0");
        if (StringUtil.isNotEmpty((String)personBaseInfo.getPhoto())) {
            Date now = new Date();
            String fileName = now.getTime() + ".jpg";
            String dirDate = DateUtil.systemDate.format(now);
            File dir = new File(this.baseFolder + this.personImgPath + dirDate);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String key = this.personImgPath + dirDate + "/" + fileName;
            String url = "getResource.do?path=" + key;
            String targetPath = this.baseFolder + key;
            if (ImgUtils.generateImage((String)personBaseInfo.getPhoto(), (String)targetPath)) {
                personBaseInfo.setImgPath(url);
                personBaseInfo.setState("1");
            }
            personBaseInfo.setPhoto(null);
        }
    }

    private void test() {
        Date now = new Date();
        String fileName = now.getTime() + ".jpg";
        String dirDate = DateUtil.systemDate.format(now);
        File dir = new File(this.baseFolder + this.personImgPath + dirDate);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String key = this.personImgPath + dirDate + "/" + fileName;
        String url = "getResource.do?path=" + key;
        String targetPath = this.baseFolder + key;
        if (ImgUtils.generateImage((String)ImgUtils.getImageStr((String)"C:\\Users\\Administrator\\Desktop\\test.png"), (String)targetPath)) {
            System.out.println(url);
        }
    }
}

