/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.timer.ministerial;

import com.abcxin.smart.validator.annotation.JobLogAnnotation;
import com.alibaba.fastjson.JSONArray;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.enums.MinisterialDataType;
import com.bcxin.ars.model.sys.MinisterialLog;
import com.bcxin.ars.service.sys.MinisterialLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.MinisterialUtil;
import com.bcxin.ars.webservice.XxbaBaseDto;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MinisterialAutoService {
    private Logger logger = LoggerFactory.getLogger(MinisterialAutoService.class);
    @Autowired
    private MinisterialLogService ministerialLogService;
    @Autowired
    private MinisterialUtil ministerialUtil;
    @Autowired
    private ConfigUtils configUtils;
    private boolean lock = false;

    @JobLogAnnotation(getJobClazz=MinisterialAutoService.class)
    public void run() {
        if (this.lock) {
            return;
        }
        this.lock = true;
        try {
            if (this.configUtils.isIntranet() && this.configUtils.timeFlag.equals("true")) {
                this.syncRun();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.lock = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncRun() {
        String ministerial_limit = this.configUtils.getValueByKey("MINISTERIAL_LIMIT");
        int limit = 3;
        try {
            limit = Integer.parseInt(ministerial_limit);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (MinisterialDataType dataType : MinisterialDataType.values()) {
            try {
                List list = this.ministerialLogService.getBusinessDatas(dataType, limit);
                if (list == null || list.size() < 1) continue;
                List dataList = JSONArray.parseArray((String)JSONArray.toJSONString((Object)list), (Class)dataType.getDataClazz());
                for (Object o : dataList) {
                    try {
                        AjaxResult result = this.ministerialUtil.send(dataType, o);
                        if (result.isSuccessful()) {
                            MinisterialLog log = new MinisterialLog();
                            log.setBusinessType(dataType.getCode());
                            if (result.getData() != null) {
                                log.setSerialNo(result.getData().toString());
                                log.setState("0");
                            }
                            log.setActive(Boolean.valueOf(true));
                            log.setCreateTime(new Date());
                            log.setUpdateTime(new Date());
                            log.setBusinessId(((XxbaBaseDto)o).getId());
                            this.ministerialLogService.save(log);
                        }
                        Thread.sleep(1000L);
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                        e.printStackTrace();
                    }
                }
                Thread.sleep(5000L);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
        }
    }
}

