/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.timer.dataSync;

import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.DataSyncContantsUtil;
import com.bcxin.ars.service.util.DataSyncUtil;
import com.bcxin.ars.util.DateUtil;
import java.io.File;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataSyncI2OService {
    private Logger logger = LoggerFactory.getLogger(DataSyncI2OService.class);
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private DataSyncUtil dataSyncUtil;
    @Autowired
    private DataSyncContantsUtil dataSyncContantsUtil;
    @Autowired
    private JobRunLogService jobRunLogService;
    private boolean lock = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block10: {
            if (this.lock) {
                return;
            }
            this.lock = true;
            try {
                if (!"true".equals(this.configUtils.timeFlag)) break block10;
                if (!"1".equals(this.configUtils.getValueByKey("DATASYNC_SWITCH"))) {
                    return;
                }
                JobRunLog log = new JobRunLog();
                log.setCreateTime(new Date());
                log.setActive(Boolean.valueOf(true));
                log.setUpdateBy("jobSystem");
                long startTime = System.currentTimeMillis();
                try {
                    if (this.configUtils.isIntranet()) {
                        this.createDataFile();
                    } else {
                        this.readDSFile(DataSyncOutAnnotation.class, this.dataSyncContantsUtil.ftpInFolder);
                    }
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                    log.setExceptionMsg(e.toString());
                }
                long endTime = System.currentTimeMillis();
                log.setUpdateTime(new Date());
                log.setJobName(DataSyncI2OService.class.getName());
                log.setRunTime(new Date());
                log.setRunTimeLength(endTime - startTime + "ms");
                this.jobRunLogService.insert(log);
            }
            finally {
                this.lock = false;
            }
        }
    }

    private void createDataFile() {
        String startDate = DateUtil.getYesterday();
        Config lastDateConfig = this.configUtils.getConfigByKey("lastDateTime");
        if (lastDateConfig != null && !DateUtil.convertDateToString((Date)new Date(), (String)"yyyy-MM-dd").equals(lastDateConfig.getValue())) {
            startDate = lastDateConfig.getValue();
        }
        String dirDate = DateUtil.getCurrentDate();
        String filePath = this.dataSyncContantsUtil.ftpInFolder + dirDate + File.separatorChar;
        this.dataSyncUtil.createDSFile(startDate, filePath);
        Config updateConfig = new Config();
        updateConfig.setKey("lastDateTime");
        updateConfig.setValue(DateUtil.getDateStrAfterMinute((int)-5));
        updateConfig.setUpdateTime(new Date());
        this.configUtils.updateForKey(updateConfig);
    }

    private void readDSFile(Class annotationClass, String filePath) {
        Date now = new Date();
        Config lastDateConfig = this.configUtils.getConfigByKey("dataSyncLastDate");
        if (lastDateConfig != null) {
            String lastDate = lastDateConfig.getValue();
            List dates = DateUtil.getBetweenDates((Date)DateUtil.convertStringToDate((String)lastDate), (Date)now);
            dates.add(DateUtil.getBeginDayOfYesterday());
            dates.add(now);
            for (Date date : dates) {
                String dirFilePath = filePath + DateUtil.convertDateToString((Date)date, (String)"yyyy-MM-dd");
                File dirFile = new File(dirFilePath);
                if (!dirFile.exists()) break;
                File[] files = dirFile.listFiles();
                boolean errorFlag = false;
                for (int i = 0; i < files.length; ++i) {
                    File file = files[i];
                    if (!file.getName().endsWith(".zip") || !file.getName().startsWith(this.configUtils.getDataSyncStartFileName(DataSyncOutAnnotation.class))) continue;
                    try {
                        this.dataSyncUtil.readDSFile(annotationClass, file);
                        continue;
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                        errorFlag = true;
                    }
                }
                if (errorFlag) continue;
                Config updateConfig = new Config();
                updateConfig.setKey("dataSyncLastDate");
                updateConfig.setValue(DateUtil.convertDateToString((Date)date, (String)"yyyy-MM-dd"));
                this.configUtils.updateForKey(updateConfig);
            }
        }
    }
}

