/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.timer.company;

import com.bcxin.ars.dao.sb.InvestorDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.SAASMessageDto;
import com.bcxin.ars.dto.sb.InvestorDto;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.SAASInterfaceUtil;
import com.bcxin.ars.util.text.StringUtils;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class InvestorInfoIncompleteNotifyService {
    private static final Logger logger = LoggerFactory.getLogger(InvestorInfoIncompleteNotifyService.class);
    @Resource
    private JobRunLogService jobRunLogService;
    @Resource
    private SAASInterfaceUtil saasInterfaceUtil;
    @Resource
    private ConfigUtils configUtils;
    @Resource
    private InvestorDao investorDao;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (!"true".equals(this.configUtils.timeFlag) || !"11".equals(this.configUtils.getCurrentNative()) || this.configUtils.isIntranet()) {
            return;
        }
        JobRunLog log = this.getJobRunLog();
        long startTime = System.currentTimeMillis();
        try {
            this.handleInfoIncomplete();
        }
        catch (RuntimeException e) {
            logger.error("\u80a1\u4e1c\u4fe1\u606f\u7ad9\u5185\u4fe1\u63d0\u9192\u5f02\u5e38:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        finally {
            long endTime = System.currentTimeMillis();
            log.setRunTimeLength(endTime - startTime + "ms");
            log.setUpdateTime(new Date());
            this.jobRunLogService.insert(log);
        }
    }

    public void handleInfoIncomplete() {
        List investors = this.investorDao.listWithComId();
        HashMap incompleteInfoMap = Maps.newHashMap();
        for (InvestorDto investor : investors) {
            boolean isIncomplete;
            if ("2".equals(investor.getInvestorsType()) || (isIncomplete = this.isInfoIncomplete(investor))) continue;
            String comId = investor.getComId();
            StringBuilder stringBuilder = (StringBuilder)incompleteInfoMap.get(comId);
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(investor.getName()).append("\uff0c");
            incompleteInfoMap.put(comId, stringBuilder);
        }
        logger.info("\u9700\u8981\u53d1\u9001\u7ad9\u5185\u4fe1\u7684\u516c\u53f8\u53ca\u80a1\u4e1c===>{}", (Object)incompleteInfoMap);
        if (incompleteInfoMap.isEmpty()) {
            return;
        }
        incompleteInfoMap.forEach((key, val) -> this.send((String)key, "\u5173\u4e8e\u80a1\u4e1c\u4fe1\u606f\u4e0d\u5b8c\u6574\u7684\u901a\u77e5", "\u8d35\u516c\u53f8\u80a1\u4e1c\u4fe1\u606f\u4e2d\u5b58\u5728\u4fe1\u606f\u4e0d\u5b8c\u6574\u7684\u4eba\u5458:{investors}\\n\u8bf7\u53ca\u65f6\u8865\u5145\u5b8c\u5584(\u9700\u5b8c\u6574\u586b\u5199\u6240\u6709\u4fe1\u606f)\u3002\\n\u5b8c\u5584\u8def\u5f84: [\u4f01\u4e1a\u7ba1\u7406] - [\u4f01\u4e1a\u62a5\u5907] - [\u80a1\u4e1c\u4fe1\u606f] - [\u4fee\u6539]".replace("{investors}", (CharSequence)val)));
    }

    public boolean isInfoIncomplete(Object object) {
        Field[] fields;
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            try {
                String value = (String)field.get(object);
                if (!StringUtils.isBlank((CharSequence)value)) continue;
                return false;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public JobRunLog getJobRunLog() {
        JobRunLog log = new JobRunLog();
        log.setCreateTime(new Date());
        log.setJobName(this.getClass().getName());
        log.setActive(Boolean.valueOf(true));
        log.setUpdateBy("jobSystem");
        log.setRunTime(new Date());
        return log;
    }

    public AjaxResult send(String companyIds, String title, String content) {
        SAASMessageDto saasMessageDto = new SAASMessageDto();
        saasMessageDto.setComIds(companyIds);
        saasMessageDto.setTitle(title);
        saasMessageDto.setContent(content);
        saasMessageDto.setPoliceRegionId(this.configUtils.getCurrentProvince());
        saasMessageDto.setMessageType("050303");
        return this.saasInterfaceUtil.sendSaasMsg(saasMessageDto);
    }
}

