package com.bcxin.ars.model.task;

import java.util.Date;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.model.BaseModel;
import com.bcxin.ars.model.SecurityPerson;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

/**
 * 任务反馈
 * @author Ethan
 */
public class TaskFeedback extends BaseModel {

	private static final long serialVersionUID = 238419627952432L;
	
	/**
	 * 区域编号
	 */
	@ModelAnnotation(getName="区域编号",column = "native_code")
	private Long nativeCode;
	
	/**
	 * 所属任务
	 */
	private Task task;
	
	/**
	 * 任务状态
	 */
	@JsonIgnoreProperties(value={"handler"})
	@ModelAnnotation(getName="任务状态",column = "task_status")
	private TaskStatus taskStatus;
	
	/**
	 * 签到状态
	 */
	@ModelAnnotation(getName="签到状态",column = "sign_status")
	private String signStatus;//1正常，2不正常 迟到

	/**
	 * 反馈状态
	 */
	@ModelAnnotation(getName="反馈状态",column = "feedback_status")
	private String feedbackStatus;//1正常，2不正常 早退，3漏打卡

	/**
	 * 保安员
	 */
	@JsonBackReference
	@JsonIgnoreProperties(value={"handler"})
	private SecurityPerson person;
	
	/**
	 * 任务日期
	 */
	@ModelAnnotation(getName="任务日期",column = "task_date")
	private String taskDate;
	
	/**
	 * 班次id
	 */
	@ModelAnnotation(getName="班次id",column = "schedule_id")
	private Long scheduleId;
	
	/**
	 * 班次名
	 */
	@ModelAnnotation(getName="班次名",column = "schedule_name")
	private String scheduleName;
	/**
	 * 任务开始时间
	 */
	@ModelAnnotation(getName="任务开始时间",column = "task_start")
	private String taskStart;
	
	/**
	 * 任务结束时间
	 */
	@ModelAnnotation(getName="任务结束时间",column = "task_end")
	private String taskEnd;
	
	/**
	 * 照片
	 */
	@ModelAnnotation(getName="照片",column = "photos")
	private String photos;
	
	/**
	 * 反馈
	 */
	@ModelAnnotation(getName="反馈",column = "comment")
	private String comment;
	
	/**
	 * 开始执行时间
	 */
	@ModelAnnotation(getName="开始执行时间",column = "start_time")
	private Date startTime;
	
	/**
	 * 结束执行时间
	 */
	@ModelAnnotation(getName="结束执行时间",column = "end_time")
	private Date endTime;

	/**数据迁移关联的外网id **/
	private Long rawid;
	
	/**数据迁移关联的内网id **/
	private Long inrawid;

	public Long getNativeCode() {
		return nativeCode;
	}

	public void setNativeCode(Long nativeCode) {
		this.nativeCode = nativeCode;
	}

	public Task getTask() {
		return task;
	}

	public void setTask(Task task) {
		this.task = task;
	}

	public TaskStatus getTaskStatus() {
		return taskStatus;
	}

	public void setTaskStatus(TaskStatus taskStatus) {
		this.taskStatus = taskStatus;
	}

	public SecurityPerson getPerson() {
		return person;
	}

	public void setPerson(SecurityPerson person) {
		this.person = person;
	}

	public String getTaskDate() {
		return taskDate;
	}

	public void setTaskDate(String taskDate) {
		this.taskDate = taskDate;
	}

	public String getTaskStart() {
		return taskStart;
	}

	public void setTaskStart(String taskStart) {
		this.taskStart = taskStart;
	}

	public String getTaskEnd() {
		return taskEnd;
	}

	public void setTaskEnd(String taskEnd) {
		this.taskEnd = taskEnd;
	}
	
	public String getPhotos() {
		return photos;
	}

	public void setPhotos(String photos) {
		this.photos = photos;
	}

	public String getComment() {
		return comment;
	}

	public void setComment(String comment) {
		this.comment = comment;
	}

	public Date getStartTime() {
		return startTime;
	}

	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}

	public Date getEndTime() {
		return endTime;
	}

	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

	public Long getScheduleId() {
		return scheduleId;
	}

	public void setScheduleId(Long scheduleId) {
		this.scheduleId = scheduleId;
	}

	public String getScheduleName() {
		return scheduleName;
	}

	public void setScheduleName(String scheduleName) {
		this.scheduleName = scheduleName;
	}
	
	public String getSignStatus() {
		return signStatus;
	}

	public void setSignStatus(String signStatus) {
		this.signStatus = signStatus;
	}

	public String getFeedbackStatus() {
		return feedbackStatus;
	}

	public void setFeedbackStatus(String feedbackStatus) {
		this.feedbackStatus = feedbackStatus;
	}

	public Long getRawid() {
		return rawid;
	}

	public void setRawid(Long rawid) {
		this.rawid = rawid;
	}

	public Long getInrawid() {
		return inrawid;
	}

	public void setInrawid(Long inrawid) {
		this.inrawid = inrawid;
	}
}
