package com.bcxin.ars.model.task;

import com.bcxin.ars.model.BaseModel;
import com.bcxin.ars.serializer.LongJsonDeserializer;
import com.bcxin.ars.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;
import java.util.Date;

@Data
public class PersonClockIn  extends BaseModel {
    private static final long serialVersionUID = 1L;
    /**
     * 人员id
     */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long personId;
    /**
     * 上班日期
     *
     */
    private Date workDate;
    /**
     * 上班时间
     *
     */
    private Date startWorkTime;
    /**
     * 下班时间
     *
     */
    private Date endWorkTime;
    /**
     * 班次规则ID
     *
     */
    private Long shiftRuleId;
    /**
     * 第几轮打卡
     *
     */
    private Integer clockInRound;

}
