package com.bcxin.ars.model.subsidy;


import com.bcxin.ars.model.BaseModel;
import lombok.Data;

/**
 * 培训单位补贴简称批次配置
 *
 * @author linqinglin
 * @Date 2020-05-27 10:30:45
 */
@Data
public class TrainSubsidyConfig extends BaseModel {

    private static final long serialVersionUID = 1L;
    /**
    * 培训机构id
    * 
    */
    private Long trainId;
    /**
    * 培训机构名称
    * 
    */
    private String trainName;

    /**
     * 简称
     */
    private String shortName;
    /**
    * 批次号
    * 
    */
    private Long batchNo;

    /**
     * 补贴证书类型 01等级证 or 02资格证
     */
    private String subsidyCerType;
 	
    @Override
    public boolean equals (Object o){
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}