package com.bcxin.ars.model.msg;


import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.model.BaseModel;
import lombok.Data;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/***
 * 公安消息信息表
 * @author subh
 */
@Data
public class NewsnoticePolice extends BaseModel{

    /**  */
	private static final long serialVersionUID = 1L;

	/** 标题 */
    @ModelAnnotation(getName="标题",column = "newsTitle")
    private String newsTitle;

    /** 发送人ID */
    @ModelAnnotation(getName="发送人ID",column = "sendId")
    private Long sendId;

    /** 发送人员姓名 */
    @ModelAnnotation(getName="发送人员姓名",column = "sendName")
    private String sendName;

    /** 发送机构名称 */
    @ModelAnnotation(getName="发送机构名称",column = "sendOrgName")
    private String sendOrgName;

    /** 发送机构Id */
    @ModelAnnotation(getName="发送机构Id",column = "sendOrgId")
    private Long sendOrgId;

    /** 是否撤消 0未撤消1已撤消 */
    @ModelAnnotation(getName="是否撤消",column = "undoState")
    private String undoState;

    /** 已读数 */
    @ModelAnnotation(getName="已读数",column = "readnum")
    private Integer readnum;

    /** 未读数 */
    @ModelAnnotation(getName="未读数",column = "unreadnum")
    private Integer unreadnum;

    /** 暂存状态 0暂存1保存 */
    @ModelAnnotation(getName="暂存状态",column = "temporaryState")
    private String temporaryState;

    /** 是否通知保安人员 0不通知1通知 */
    @ModelAnnotation(getName="是否通知保安人员",column = "noticeperson")
    private String noticeperson;

    /** 发送人机构编码 */
    @ModelAnnotation(getName="发送人机构编码",column = "areaCode")
    private String areaCode;

    /** 消息内容 */
    @ModelAnnotation(getName="消息内容",column = "newsContext")
    private String newsContext;
    /** 公共服务安全平台消息ID */
    @ModelAnnotation(getName="公共服务安全平台消息ID",column = "messageIdSaaS")
    private String messageIdSaaS;

    /** 发送时间 */
    @ModelAnnotation(getName="发送时间",column = "sendTime")
    private Date sendTime;
    /***
     * 消息类型1为公安2为企业
     */
    @ModelAnnotation(getName="消息类型",column = "newsType")
    private String newsType;

    /***
     * 回复附件是否为必填
     */
    @ModelAnnotation(getName="回复附件是否为必填",column = "replyAtt")
    private String replyAtt;

    private Long[] sysAttachmentIds;
    
    private List<SysAttachment> sysAttachments = new ArrayList<SysAttachment>();
    
    private Long[] ueditorImageIds;

	private String[] companyIds;
    
    private String[] companyNames;

    private String[] relationIds;
    
    private String[] types;

    private List<NewsCompanyRelationship> recipients;

    private List<NewsnoticeRecipient> originalRecipients;
    
    private List<NewsnoticeCompany> noticeCompanys;


}