package com.bcxin.ars.model;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.util.Date;

/**
 * 分公司基础信息
 * @author Ethan
 */
public class SbSubsidiaryBase extends BaseModel {

	private static final long serialVersionUID = 7649752662428917609L;

	/**
	 * 账户信息
	 */
	@JsonIgnoreProperties(value={"handler"})
	private User user;
	/**
	 * 用户ID
	 */
	@ModelAnnotation(getName="用户ID",column = "user_id")
	private Long userid;

	public Long getUserid() {
		return userid;
	}

	public void setUserid(Long userid) {
		this.userid = userid;
	}

	/**

	 * 编码
	 */
	@ModelAnnotation(getName="编码",column = "code")
	private String code;

	/**
	 * 分公司名称
	 */
	@ModelAnnotation(getName="分公司名称",column = "company_name")
	private String companyName;

	/**
	 * 注册地址
	 */
	@ModelAnnotation(getName="注册地址",column = "register_address")
	private String registerAddress;

	/**
	 * 经营地
	 */
	@ModelAnnotation(getName="经营地",column = "business_place")
	private String businessPlace;

	/**
	 * 备案机关编码
	 */
	@ModelAnnotation(getName="备案机关编码",column = "filing_authority_code")
	private String filingAuthorityCode;

	/**
	 * 备案机关名称
	 */
	@ModelAnnotation(getName="备案机关名称",column = "filing_authority_name")
	private String filingAuthorityName;

	/**
	 * 备案机关日期
	 */
	@ModelAnnotation(getName="备案机关日期",column = "filing_authority_date")
	private String filingAuthorityDate;

	/**
	 * 负责人
	 */
	@ModelAnnotation(getName="负责人",column = "money_principal")
	private String moneyPrincipal;

	/**
	 * 负责人身份证号
	 */
	@ModelAnnotation(getName="负责人身份证号",column = "money_principal_id")
	private String moneyPrincipalId;

	/**
	 * 负责人手机号
	 */
	@ModelAnnotation(getName="负责人手机号",column = "money_principal_phone")
	private String moneyPrincipalPhone;

	/***
	 * 公司许可证号
	 */
	@ModelAnnotation(getName="公司许可证号",column = "tel")
	private String publicSecurityLicenseNumber;

	public String getPublicSecurityLicenseNumber() {
		return publicSecurityLicenseNumber;
	}

	public void setPublicSecurityLicenseNumber(String publicSecurityLicenseNumber) {
		this.publicSecurityLicenseNumber = publicSecurityLicenseNumber;
	}
	public static long getSerialVersionUID() {
		return serialVersionUID;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getCompanyName() {
		return companyName;
	}

	public void setCompanyName(String companyName) {
		this.companyName = companyName;
	}

	public String getRegisterAddress() {
		return registerAddress;
	}

	public void setRegisterAddress(String registerAddress) {
		this.registerAddress = registerAddress;
	}

	public String getBusinessPlace() {
		return businessPlace;
	}

	public void setBusinessPlace(String businessPlace) {
		this.businessPlace = businessPlace;
	}

	public String getFilingAuthorityCode() {
		return filingAuthorityCode;
	}

	public void setFilingAuthorityCode(String filingAuthorityCode) {
		this.filingAuthorityCode = filingAuthorityCode;
	}

	public String getFilingAuthorityName() {
		return filingAuthorityName;
	}

	public void setFilingAuthorityName(String filingAuthorityName) {
		this.filingAuthorityName = filingAuthorityName;
	}

	public String getFilingAuthorityDate() {
		return filingAuthorityDate;
	}

	public void setFilingAuthorityDate(String filingAuthorityDate) {
		this.filingAuthorityDate = filingAuthorityDate;
	}

	public String getMoneyPrincipal() {
		return moneyPrincipal;
	}

	public void setMoneyPrincipal(String moneyPrincipal) {
		this.moneyPrincipal = moneyPrincipal;
	}

	public String getMoneyPrincipalId() {
		return moneyPrincipalId;
	}

	public void setMoneyPrincipalId(String moneyPrincipalId) {
		this.moneyPrincipalId = moneyPrincipalId;
	}

	public String getMoneyPrincipalPhone() {
		return moneyPrincipalPhone;
	}

	public void setMoneyPrincipalPhone(String moneyPrincipalPhone) {
		this.moneyPrincipalPhone = moneyPrincipalPhone;
	}

	@Override
	public String toString() {
		return "SbSubsidiaryBase{" +
				"user=" + user +
				", userid=" + userid +
				", code='" + code + '\'' +
				", companyName='" + companyName + '\'' +
				", registerAddress='" + registerAddress + '\'' +
				", businessPlace='" + businessPlace + '\'' +
				", filingAuthorityCode='" + filingAuthorityCode + '\'' +
				", filingAuthorityName='" + filingAuthorityName + '\'' +
				", filingAuthorityDate='" + filingAuthorityDate + '\'' +
				", moneyPrincipal='" + moneyPrincipal + '\'' +
				", moneyPrincipalId='" + moneyPrincipalId + '\'' +
				", moneyPrincipalPhone='" + moneyPrincipalPhone + '\'' +
				'}';
	}
}
