package com.bcxin.ars.model;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;

import java.util.Date;

/**
 * 海外经营信息管理
 * @author Ethan
 */
@Data
public class SbBusinessOutsideManagement extends BaseModel {

	private static final long serialVersionUID = 7649752662428917609L;

	/**
	 * 账户信息
	 */
	@JsonIgnoreProperties(value={"handler"})
	private User user;
	/**
	 * 用户ID
	 */
	@ModelAnnotation(getName="用户ID",column = "user_id")
	private Long userid;

	/**
	 *涉外经营国别
	 */
	@ModelAnnotation(getName="涉外经营国别",column = "user_id")
	private String national;

	/**
	 * 安保范围
	 */
	@ModelAnnotation(getName="安保范围",column = "security_scope")
	private String securityScope;

	/**
	 * 经营起始时间
	 */
	@ModelAnnotation(getName="经营起始时间",column = "business_start_time")
	private Date businessStartTime;

	/**
	 * 经营结束时间
	 */
	@ModelAnnotation(getName="经营结束时间",column = "business_end_time")
	private Date businessEndTime;

	/**
	 * 经营模式
	 */
	@ModelAnnotation(getName="经营模式",column = "business_model")
	private String businessModel;

	/**
	 *  备案公安机关名称
	 */
	@ModelAnnotation(getName="备案公安机关名称",column = "filing_authority_name")
	private String filingAuthorityName;

	/**
	 *  备案日期
	 */
	@ModelAnnotation(getName="备案日期",column = "filing_authority_date")
	private Date filingAuthorityDate;

	/**
	 * 保安服务类型
	 * @return
	 */
	@ModelAnnotation(getName="保安服务类型",column = "security_type")
	private String securityType;

	/**
	 * 其他保安服务范围名称(保安范围为其他则此列必填)
	 */
	@ModelAnnotation(getName="其他保安服务范围名称",column = "otherSecScopeType")
	private String otherSecScopeType;


	/**
	 * 公司名称
	 */
	private String companyname;


	public String getOtherSecScopeType() {
		return otherSecScopeType;
	}

	public void setOtherSecScopeType(String otherSecScopeType) {
		this.otherSecScopeType = otherSecScopeType;
	}



	public Long getUserid() {
		return userid;
	}

	public void setUserid(Long userid) {
		this.userid = userid;
	}
	
	public String getSecurityType() {
		return securityType;
	}

	public void setSecurityType(String securityType) {
		this.securityType = securityType;
	}

	public static long getSerialVersionUID() {
		return serialVersionUID;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

    public String getNational() {
        return national;
    }

    public void setNational(String national) {
        this.national = national;
    }

    public String getSecurityScope() {
        return securityScope;
    }

    public void setSecurityScope(String securityScope) {
        this.securityScope = securityScope;
    }


    public String getBusinessModel() {
        return businessModel;
    }

    public void setBusinessModel(String businessModel) {
        this.businessModel = businessModel;
    }

    public String getFilingAuthorityName() {
        return filingAuthorityName;
    }

    public void setFilingAuthorityName(String filingAuthorityName) {
        this.filingAuthorityName = filingAuthorityName;
    }

	public Date getBusinessStartTime() {
		return businessStartTime;
	}

	public void setBusinessStartTime(Date businessStartTime) {
		this.businessStartTime = businessStartTime;
	}

	public Date getBusinessEndTime() {
		return businessEndTime;
	}

	public void setBusinessEndTime(Date businessEndTime) {
		this.businessEndTime = businessEndTime;
	}

	public Date getFilingAuthorityDate() {
		return filingAuthorityDate;
	}

	public void setFilingAuthorityDate(Date filingAuthorityDate) {
		this.filingAuthorityDate = filingAuthorityDate;
	}


	@Override
    public String toString() {
        return "SbBusinessOutsideManagement{" +
                "user=" + user +
                ", userid=" + userid +
                ", national='" + national + '\'' +
                ", securityScope='" + securityScope + '\'' +
                ", businessStartTime='" + businessStartTime + '\'' +
                ", businessEndTime='" + businessEndTime + '\'' +
                ", businessModel='" + businessModel + '\'' +
                ", filingAuthorityName='" + filingAuthorityName + '\'' +
                ", filingAuthorityDate='" + filingAuthorityDate + '\'' +
                '}';
    }
}
